package org.sophia.slate_work.blocks.entities;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.NullIota;
import at.petrak.hexcasting.api.utils.NBTHelper;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.sophia.slate_work.misc.KnownBroadcasters;
import org.sophia.slate_work.registries.BlockRegistry;

public class BroadcasterLociEntity extends class_2586 {
    private class_2487 iota;
    public BroadcasterLociEntity(class_2338 pos, class_2680 state) {
        super(BlockRegistry.BROADCASTER_LOCI_ENTITY, pos, state);
        iota = IotaType.serialize(new NullIota());
    }

    public Iota getIota() {
        if (iota != null && field_11863 instanceof class_3218 worldServer) {
            return IotaType.deserialize(iota, worldServer);
        }
        return new NullIota();
    }

    public class_2487 getIotaCompound(){
        return iota;
    }

    public void setIota(Iota iota){
        KnownBroadcasters.INSTANCE.setBroadcaster(this, iota);
        this.iota = IotaType.serialize(iota);
        this.method_5431();
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("iota", iota);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        iota = NBTHelper.getCompound(nbt, "iota");
    }

    @Override
    public class_2487 method_16887() {
        var z = new class_2487();
        this.method_11007(z);
        return z;
    }

    @Override
    public @Nullable class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public void method_5431() {
        super.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), class_2248.field_31036);
    }
}
