package org.sophia.slate_work.blocks.entities;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import org.sophia.slate_work.GUI.FakeInvHotbarLoci;
import org.sophia.slate_work.GUI.HotbarLociScreenHandler;
import org.sophia.slate_work.storage.HotbarLociSlot;
import org.sophia.slate_work.storage.LociIterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import static org.sophia.slate_work.registries.BlockRegistry.HOTBAR_LOCI_ENTITY;

@SuppressWarnings("UnstableApiUsage")
public class HotbarLociEntity extends HexBlockEntity implements SlottedStorage<ItemVariant>, ExtendedScreenHandlerFactory {
    private final class_2371<class_1799> stacks = class_2371.method_10213(6, class_1799.field_8037);
    private int slot = 0;

    public HotbarLociEntity(class_2338 pWorldPosition, class_2680 pBlockState) {
        super(HOTBAR_LOCI_ENTITY, pWorldPosition, pBlockState);
    }

    @Override
    protected void saveModData(class_2487 tag) {
        class_1262.method_5426(tag, stacks);
        tag.method_10569("select", slot);
    }

    @Override
    protected void loadModData(class_2487 tag) {
        if (field_11863 != null && field_11863.field_9236) stacks.clear(); // Done only on the client as a basic protection
        class_1262.method_5429(tag, stacks);
        slot = tag.method_10550("select");
    }

    public class_1799 removeStack(int slot){
        var stack = this.stacks.get(slot).method_7972();
        this.stacks.set(slot, class_1799.field_8037);
        this.sync();
        return stack;
    }

    public class_1799 removeStack(int slot, int count){
        var stack = this.stacks.get(slot);
        this.sync();
        return stack.method_7971(count);
    }

    public List<class_1799> getStacks(){
        return this.stacks;
    }

    public List<class_1799> getStacksSorted(){
        List<class_1799> list = new ArrayList<>();
        for (int i = 0; i < 6; i++){
            list.add(this.getSlotStack(Math.floorMod(this.getSlot()+i, 6)));
        }
        return list;
    }

    public class_1799 getCurrentSlot(){
        return this.stacks.get(this.getSlot());
    }

    public int getSlot() {
        return Math.floorMod(slot, 5); // In case someone fucks shit up (me)
    }

    public void setSlot(int slot) {
        this.slot = slot;
        this.sync();
    }

    @Override
    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43471("block.slate_work.hotbar_loci");
    }

    @Override
    public @Nullable class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new HotbarLociScreenHandler(syncId, playerInventory, this);
    }

    public void setStack(int slot, class_1799 stack){
        this.stacks.set(slot, stack);
        this.sync();
    }

    @Override
    public void sync() {
        super.sync();
        if (this.field_11863 instanceof class_3218 world){
            world.method_14178().method_14128(this.method_11016());
        }
    }

    public class_1263 getInv(){
        return new FakeInvHotbarLoci(this);
    }

    @Override
    public @UnmodifiableView List<SingleSlotStorage<ItemVariant>> getSlots() {
        ArrayList<SingleSlotStorage<ItemVariant>> slots = new ArrayList<>();
        int i = 0;
        for (var item : this.stacks) {
            slots.add(new HotbarLociSlot(this, i));
            i++;
        }
        return slots;
    }

    @Override
    public int getSlotCount() {
        return 6;
    }

    @Override
    public SingleSlotStorage<ItemVariant> getSlot(int slot) {
        return new HotbarLociSlot(this, slot);
    }

    public int getFreeSlot(ItemVariant variant){
        int i = 0;
        for (var item : this.stacks){
            if ((ItemVariant.of(item) == variant || item.method_7960()) && item.method_7914() > item.method_7947()) return i;
            i++;
        }
        return -1;
    }

    public class_1799 getSlotStack(int slot){
        return this.stacks.get(slot);
    }

    @Override
    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        var slot = getFreeSlot(resource);
        if (slot == -1) return 0;

        var stack = getSlotStack(slot);
        var copy = stack.method_7972();
        if (copy.method_7960()) {
            this.setStack(slot, resource.toStack((int) maxAmount));
            this.sync();
        }

        if (copy.method_7947()+maxAmount > copy.method_7914()) {
            stack.method_7939(copy.method_7914());
            this.sync();
            return maxAmount-copy.method_7947();
        } else {
            stack.method_7939(copy.method_7947() + (int) maxAmount);
            this.sync();
            return maxAmount;
        }
    }

    @Override
    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        transaction.addCloseCallback((a,b) -> {
            if (b.wasCommitted()) {
                int i = 0;
                for (var stack : this.stacks){
                    if (ItemVariant.of(stack).equals(resource)) break;
                    i++;
                }
                this.getStacks().get(i).method_7971((int) maxAmount);
                this.sync();
            }
        });
        class_1799 selected = null;
        for (var stack : this.stacks){
            if (ItemVariant.of(stack).equals(resource)){
                selected = stack;
                break;
            }
        }
        if (selected == null) return 0;
        int count = selected.method_7947();
        if (count > maxAmount){
            return maxAmount;
        } else {
            return count;
        }
    }

    @Override
    public @NotNull Iterator<StorageView<ItemVariant>> iterator() {
        return new LociIterator<>(this);
    }
}
