package org.sophia.slate_work.blocks.entities;

import at.petrak.hexcasting.api.addldata.ADIotaHolder;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.casting.mishaps.MishapOthersName;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import org.sophia.slate_work.registries.BlockRegistry;

public class MacroLociEntity extends class_2586 implements class_1263 {
    // The Holy Slot, The Slot. The Slot
    private class_1799 theSlot;
    public HexPattern pattern;

    public MacroLociEntity(class_2338 pos, class_2680 state) {
        super(BlockRegistry.MACRO_LOCI_ENTITY, pos, state);
        // The Slot
        this.theSlot = class_1799.field_8037;
        this.pattern = HexPattern.fromAngles("qaq", HexDir.NORTH_EAST);
    }

    public HexPattern getPattern() {
        return pattern;
    }

    public void setFocusContents(Iota iota, @Nullable CastingEnvironment env) throws MishapOthersName {
        var holder = IXplatAbstractions.INSTANCE.findDataHolder(theSlot);
        if (this.method_5442() || holder == null) return;
        var written = holder.writeIota(iota, false);
        if (written && env != null) {
            var trueName = MishapOthersName.getTrueNameFromDatum(holder.readIota((class_3218) field_11863), (class_3222) env.getCastingEntity());
            if (trueName != null)
                throw new MishapOthersName(trueName);
        }

        this.method_5431();
    }

    public void setPattern(HexPattern pattern) {
        this.pattern = pattern;
        this.method_5431();
    }

    @Override
    public @Nullable class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        // The Slot
        this.theSlot = class_1799.method_7915(nbt.method_10562("the_slot"));
        this.pattern = HexPattern.fromNBT(nbt.method_10562("pattern"));
    }

    public @Nullable class_2561 getDisplay(){
        var holder = IXplatAbstractions.INSTANCE.findDataHolder(theSlot);
        if (holder != null){
            if (holder.readIotaTag() != null) {
                return IotaType.getDisplay(holder.readIotaTag());
            }
        }
        return class_2561.method_30163("");
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_2487 compound = new class_2487();
        // The Slot
        theSlot.method_7953(compound);
        nbt.method_10566("pattern",this.pattern.serializeToNBT());
        nbt.method_10566("the_slot",compound);
    }

    public boolean method_49104(class_1263 hopperInventory, int slot, class_1799 stack) {
        return false;
    }

    @Override
    public int method_5439() {
        return 1;
    }

    @Override
    public boolean method_5442() {
        return theSlot.method_7960();
    }

    @Override
    public boolean method_5437(int slot, class_1799 stack) {
        ADIotaHolder holder = IXplatAbstractions.INSTANCE.findDataHolder(stack);
        return holder != null;
    }

    @Override
    public class_1799 method_5438(int slot) {
        return this.theSlot.method_7972();
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        var copy = theSlot.method_7972();
        theSlot = class_1799.field_8037;
        this.method_5431();
        return copy;
    }

    @Override
    public class_1799 method_5441(int slot) {
        var stack = this.theSlot.method_7972();
        theSlot = class_1799.field_8037;
        this.method_5431();
        return stack;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        theSlot = stack;
        this.method_5431();
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return false;
    }

    @Override
    public void method_5431() {
        super.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), class_2248.field_31036);
    }

    @Override
    public class_2487 method_16887() {
        var compound = new class_2487();
        this.method_11007(compound);
        return compound;
    }

    @Override
    public void method_5448() {
        theSlot = class_1799.field_8037;
        this.method_5431();
    }

    @Override
    public int method_5444() {
        return 1;
    }
}
