package org.sophia.slate_work.blocks.entities;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import org.sophia.slate_work.storage.LociIterator;
import org.sophia.slate_work.storage.StorageLociSlot;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import static org.sophia.slate_work.registries.BlockRegistry.STORAGE_LOCI_ENTITY;

// So this almost works like a fucked up Inventory. Instead of ItemStacks, it uses a pair of ItemStack (for the type)
// and a Long for the real amount held. Janky? Yes, should work? Hope so!
@SuppressWarnings(value = "UnstableApiUsage")
public class StorageLociEntity extends HexBlockEntity implements SlottedStorage<ItemVariant> {
    private static final class_3545<ItemVariant,Long> emptySlot = new class_3545<>(ItemVariant.blank(), 0L);
    private final class_3545<ItemVariant,Long>[] slots = class_2371.method_10213(16, emptySlot).toArray(new class_3545[16]);
    // Java, please, I just want an array of ItemStack.EMPTY at first

    public StorageLociEntity(class_2338 pos, class_2680 state) {
        super(STORAGE_LOCI_ENTITY, pos, state);
    }

    @Override
    protected void saveModData(class_2487 nbt) {
        class_2499 nbtList = new class_2499();

        for(int i = 0; i < this.slots.length; ++i) {
            ItemVariant stack = slots[i].method_15442();
            if (!stack.isBlank()) {
                class_2487 nbtCompound = new class_2487();
                nbtCompound.method_10567("Slot", (byte) i);
                nbtCompound.method_10566("Item", stack.toNbt());
                nbtCompound.method_10544("Count",slots[i].method_15441());
                nbtList.add(nbtCompound);
            }
        }
        if (!nbtList.isEmpty()) {
            nbt.method_10566("Items", nbtList);
            nbt.method_10556("Empty", false); // *Just* in case...
        } else {
            nbt.method_10556("Empty", true);
        }
    }

    @Override
    protected void loadModData(class_2487 nbt) {
        var items = nbt.method_10554("Items", class_2520.field_33260);

        if (nbt.method_10577("Empty")){
            this.clear();
        }

        for (int i = 0; i < this.slots.length; ++i) {
            class_2487 compound = items.method_10602(i);
            class_3545<ItemVariant,Long> stack = new class_3545<>(ItemVariant.fromNbt(compound.method_10562("Item")),(compound.method_10537("Count")));
            this.slots[i] = stack;
        }
    }

    public boolean isEmpty() {
        for (var z : this.slots){
            if (!z.method_15442().isBlank() || z.method_15441() != 0) return false;
        }
        return true;
    }

    // Returns the slot found empty, else returns -1 if the Locus is full
    public int isFull(){
        int i = 0;
        for (var z : this.slots){
            if (z.method_15442().isBlank() || z.method_15441() == 0) return i;
            i++;
        }
        return -1;
    }


    /**
     *  Returns a *copy*
     *  **/
    public class_3545<ItemVariant,Long> getStack(int slot) {
        return new class_3545<>(this.slots[slot].method_15442(),this.slots[slot].method_15441());
    }

    // You better know what you are doing...
    public class_3545<ItemVariant,Long>[] getInventory(){
        return this.slots;
    }

    public class_3545<ItemVariant,Long> removeStack(int slot, int amount) {
        if (amount <= 0) return emptySlot; //Pain.
        var pair = this.slots[slot];
        var copy = pair.method_15442();
        long returned;

        if (copy == ItemVariant.blank() || pair.method_15441() == 0){
            this.slots[slot] = emptySlot;
            return emptySlot;
        }
        if (pair.method_15441() <= amount) {
            returned = pair.method_15441();
            this.slots[slot] = emptySlot;
        }
        else {
            this.slots[slot].method_34965(this.slots[slot].method_15441() - amount);
            returned = amount;
        }
        this.sync();
        return new class_3545<>(copy,returned);
    }

    public @Nullable Integer getSlot(ItemVariant item){
        for (int i = 0; i < slots.length; i++) {
            var stored = this.slots[i].method_15442();
            if (item.getItem() == stored.getItem() && item.getNbt() == stored.getNbt())
                    return i;
        }
        this.sync();
        return null;
    }

    public class_3545<ItemVariant,Long> removeStack(int slot) {
        var pair = this.slots[slot];
        var copy = pair.method_15442();
        if (!copy.isBlank()) {
            this.slots[slot] = new class_3545<>(emptySlot.method_15442(), emptySlot.method_15441());
        }
        this.sync();
        return new class_3545<>(copy,pair.method_15441());
    }

    public void setStack(int slot, ItemVariant stack, long amount) {
        if (amount <= 0){ // If this somehow comes from overflow, you kind of deserve it
            this.slots[slot] = new class_3545<>(emptySlot.method_15442(), emptySlot.method_15441());
            this.sync();
            return;
        }
        this.slots[slot] = new class_3545<>(stack, amount);
        this.sync();
    }

    public void setStack(int slot, class_3545<ItemVariant, Long> pair) {
        this.setStack(slot, pair.method_15442(), pair.method_15441());
    }

    public void clear() {
        Arrays.fill(this.slots, new class_3545<>(emptySlot.method_15442(),emptySlot.method_15442()));
        if (this.field_11863 != null) this.sync();
    }

    @Override
    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        var slotT = getSlot(resource);
        if (slotT == null) slotT = this.isFull();
        if (slotT  == -1) return 0;
        int slot = slotT;

        var stack = getStack(slot);
        transaction.addCloseCallback((a,z) -> {
            if (z.wasCommitted()) {
                if (stack.method_15442().isBlank()) this.setStack(slot, new class_3545<>(resource, maxAmount));
                else this.setStack(slot, new class_3545<>(stack.method_15442(), stack.method_15441() + maxAmount));
                this.sync();
            }
        });
        return maxAmount;
    }

    @Override
    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        var slot = getSlot(resource);
        if (slot == null) return 0;
        if (maxAmount <= 0) return 0;

        var pair = this.slots[slot];
        var copy = pair.method_15442();
        long returned;

        if (copy == ItemVariant.blank() || pair.method_15441() == 0){
            this.slots[slot] = emptySlot;
        }
        if (pair.method_15441() <= maxAmount) {
            returned = pair.method_15441();
        } else {
            returned = maxAmount;
        }
        this.method_5431();
        transaction.addCloseCallback((a,z) -> {
            if (z.wasCommitted()) {
                this.removeStack(slot, (int) maxAmount);
            }
        });
        return returned;
    }

    @Override
    public @NotNull Iterator<StorageView<ItemVariant>> iterator() {
        return new LociIterator<>(this);
    }

    @Override
    public int getSlotCount() {
        return 16;
    }

    @Override
    public StorageLociSlot getSlot(int slot) {
        return new StorageLociSlot(this, slot);
    }

    @Override
    public @UnmodifiableView List<SingleSlotStorage<ItemVariant>> getSlots() {
        return SlottedStorage.super.getSlots();
    }
}
