package org.sophia.slate_work.client.blockEntityRenders;

import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.sophia.slate_work.blocks.entities.HotbarLociEntity;
import org.sophia.slate_work.registries.BlockRegistry;

import java.util.ArrayList;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;

import static at.petrak.hexcasting.api.block.circle.BlockCircleComponent.ENERGIZED;
import static org.sophia.slate_work.blocks.AbstractSlate.FACING;
import static org.sophia.slate_work.client.blockEntityRenders.SaveLociRenderer.rotateY;

public class HotbarLociRenderer implements class_827<HotbarLociEntity> {
    private final class_918 itemRenderer;

    public HotbarLociRenderer(class_5614.@NotNull class_5615 context){
        itemRenderer = context.method_43335();
    }

    @Override
    public boolean isInRenderDistance(HotbarLociEntity blockEntity, class_243 pos) {
        return class_827.super.method_33892(blockEntity, pos);
    }

    @Override
    public int method_33893() {
        return class_827.super.method_33893();
    }

    @Override
    public void render(HotbarLociEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        matrices.method_22903();
        matrices.method_22904(0.5,0.5,0.5);
        if (entity.method_10997() != null) {
            var bs = entity.method_10997().method_8320(entity.method_11016());
            if (bs.method_26204() == BlockRegistry.HOTBAR_LOCI && class_310.method_1551().method_1560() != null) {
                double speed = 3;
                if (bs.method_11654(ENERGIZED)) speed = 8;
                long time = entity.method_10997().method_8510();

                int rotationX = 0;
                int rotationY = 0;
                switch (bs.method_11654(FACING)){
                    case field_11036 -> rotationY = 0;
                    case field_11033 -> rotationY = 180;
                    case field_11043 -> rotationY = 270;
                    case field_11035 -> rotationY = 90;
                    case field_11034 -> {rotationY = 90; rotationX = 270;}
                    case field_11039 -> {rotationY = 270; rotationX = 90;}
                }


                float radZ = (float) (Math.PI/180)*rotationY;
                matrices.method_49278(new Quaternionf(Math.sin(radZ/2),0,0f,Math.cos(radZ/2f)), 0f, 0, 0f);

                float radX = (float) (Math.PI/180)*rotationX;
                matrices.method_22907(new Quaternionf(0,0,Math.sin(radX/2),Math.cos(radX/2f)));

                matrices.method_22903();
                matrices.method_22905(1,1,1);
                matrices.method_22904(0,-0.7,0);

                double spin = (Math.PI/180)*time%360*speed;
                matrices.method_22907(new Quaternionf(0,Math.sin(spin/2),0,Math.cos(spin/2f)));

                var itemsTemp = entity.getStacks();
                var items = new ArrayList<class_1799>();
                for (var item : itemsTemp){
                    if (!item.method_7960()) items.add(item);
                }
                class_1799 selectedSlot = entity.getCurrentSlot();
                var radius = (Math.PI*2)/items.toArray().length;
                int i = 0;
                float scale = (float) (1/radius)-0.15f;
                matrices.method_22905(0.75f,0.75f,0.75f);
                for (class_1799 item : items){
                    matrices.method_22903();
                    matrices.method_22904(Math.sin(radius*i)*scale,
                            Math.sin((double) time/10)/(6+4/speed) +1, //Math.sin((time/100)/(speed/4)) +1
                            Math.cos(radius*i)*scale);
                    if (item == selectedSlot){
                        matrices.method_22904(0,0.2,0);
                        matrices.method_22905(1.2f,1.2f,1.2f);
                    }
                    class_1087 bakedModel = itemRenderer.method_4019(item, entity.method_10997(), null, 0);
                    itemRenderer.method_23179(item, class_811.field_4318, false, matrices, vertexConsumers, light, overlay, bakedModel);
                    matrices.method_22909();
                    i++;
                }
                matrices.method_22909();
            }
        }
        matrices.method_22909();
    }
}
