package org.sophia.slate_work.client.blockEntityRenders;

import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_827;
import net.minecraft.client.render.*;
import org.joml.Quaternionf;
import org.sophia.slate_work.blocks.entities.SaveLociEntity;

import static org.sophia.slate_work.Slate_work.MOD_ID;
import static org.sophia.slate_work.blocks.SaveLoci.HORIZONTAL;

public class SaveLociRenderer implements class_827<SaveLociEntity> {
    public SaveLociRenderer(class_5614.class_5615 context){
    }

    @Override
    public void render(SaveLociEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        if (entity.method_10997() != null) {
            var bs = entity.method_10997().method_8320(entity.method_11016());
            if (bs.method_26215()) return;
            if (!bs.method_28498(HORIZONTAL)) return;
            matrices.method_22903();
            int rotation = 0;
            float rad = (float) (Math.PI/180)*((entity.method_10997().method_8510()%360)+entity.method_10997().method_8510())*4;

            var buf = vertexConsumers.getBuffer(class_1921.method_42600(new class_2960(MOD_ID,"textures/white_texture.png")));
            switch (bs.method_11654(HORIZONTAL)){
                case field_11034 -> rotation = 270;
                case field_11035 -> rotation = 180;
                case field_11039 -> rotation = 90;
            }
            rotateY(matrices, rotation);

            float scale = 0.20f;

            matrices.method_22904(0,1,0.2);
            matrices.method_22905(scale,scale,scale);

            matrices.method_22903();
            matrices.method_49278(new Quaternionf(0,0,Math.cos(rad/2),Math.sin(rad/2f)),0.25f*(1/scale)+0.5f,0.45f*(1/scale)+0.5f,0);
            matrices.method_22904(0.25*(1/scale),0.45*(1/scale),0); //Right
            makeSquare(buf,0x99c890f0, matrices);
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_49278(new Quaternionf(0,0,Math.cos(rad/2),Math.sin(rad/2f)),0.55f*(1/scale)+0.5f,0.45f*(1/scale)+0.5f,0);
            matrices.method_22904(0.55*(1/scale),0.45*(1/scale),0); //Left
            makeSquare(buf,0x99c890f0, matrices);
            matrices.method_22909();


            matrices.method_22903();
            matrices.method_22904(0,0,0.1);
            rad = rad + (float) Math.PI;
            matrices.method_22903();
            matrices.method_49278(new Quaternionf(0,0,Math.cos(rad/2),Math.sin(rad/2f)),0.25f*(1/scale)+0.5f,0.45f*(1/scale)+0.5f,0);
            matrices.method_22904(0.25*(1/scale),0.45*(1/scale),0); //Right
            makeSquare(buf,0x99c890f0, matrices);
            matrices.method_22909();

            matrices.method_22903();
            matrices.method_49278(new Quaternionf(0,0,Math.cos(rad/2),Math.sin(rad/2f)),0.55f*(1/scale)+0.5f,0.45f*(1/scale)+0.5f,0);
            matrices.method_22904(0.55*(1/scale),0.45*(1/scale),0); //Left
            makeSquare(buf,0x99c890f0, matrices);
            matrices.method_22909();

            matrices.method_22909();
            matrices.method_22909();
        }
    }

    public static void rotateY(class_4587 matrices, int y){
        float rad = (float) (Math.PI/180)*y;
        matrices.method_49278(new Quaternionf(0,Math.sin(rad/2),0f,Math.cos(rad/2f)),0.5f,0.5f,0.5f);
    }

    public static void makeSquare(class_4588 buff, int color, class_4587 stack){
        var pose = stack.method_23760();
        var view = pose.method_23761();
        var normalMatrix = pose.method_23762();
        buff.method_22918(view, 0f, 1f, 0f).method_39415(color).method_22913(0f, 1f).method_22922(class_4608.field_21444).method_22916(class_765.field_32768).method_23763(normalMatrix, 0.0F, 1.0F, 0.0F).method_1344();
        buff.method_22918(view, 1f, 1f, 0f).method_39415(color).method_22913(1f, 1f).method_22922(class_4608.field_21444).method_22916(class_765.field_32768).method_23763(normalMatrix, 0.0F, 1.0F, 0.0F).method_1344();
        buff.method_22918(view, 1f, 0f, 0f).method_39415(color).method_22913(1f, 0f).method_22922(class_4608.field_21444).method_22916(class_765.field_32768).method_23763(normalMatrix, 0.0F, 1.0F, 0.0F).method_1344();
        buff.method_22918(view, 0f, 0f, 0f).method_39415(color).method_22913(0f, 0f).method_22922(class_4608.field_21444).method_22916(class_765.field_32768).method_23763(normalMatrix, 0.0F, 1.0F, 0.0F).method_1344();
    }
}
