package org.sophia.slate_work.client.lens;

import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.client.ScryingLensOverlayRegistry;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.lib.HexItems;
import com.mojang.datafixers.util.Pair;
import org.sophia.slate_work.blocks.entities.MacroLociEntity;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;

public class MacroLociScrying implements ScryingLensOverlayRegistry.OverlayBuilder {
    @Override
    public void addLines(List<Pair<class_1799, class_2561>> list, class_2680 blockState, class_2338 blockPos, class_1657 playerEntity, class_1937 world, class_2350 direction) {
        var loci = world.method_8321(blockPos);
        if (!(loci instanceof MacroLociEntity)){
            return;
        }
        list.add(new Pair<>(class_1799.field_8037,
                HexUtils.styledWith(class_2561.method_43471(
                    "slate_work.scrying.macro.top"), class_124.field_1065)
                .method_10852(new PatternIota(((MacroLociEntity) loci).getPattern()).display())));
        var item = ((MacroLociEntity) loci).method_5438(0);
        try {
            if (((MacroLociEntity) loci).method_5437(0, item.method_7909().method_7854())) {
                list.add(new Pair<>(item,
                        ((MacroLociEntity) loci).getDisplay()
                ));
            }
        } catch (Exception e) {
            list.add(new Pair<>(HexItems.LORE_FRAGMENT.method_7854(), HexUtils.styledWith(class_2561.method_43471("slate_work.scrying.macro.error"), class_124.field_1079)));
        }
    }
}
