package org.sophia.slate_work.client.lens;

import at.petrak.hexcasting.api.client.ScryingLensOverlayRegistry;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.lib.HexItems;
import com.mojang.datafixers.util.Pair;
import org.sophia.slate_work.blocks.entities.MacroLociEntity;
import org.sophia.slate_work.blocks.entities.SentinelLociEntity;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;

public class SentinelLociScrying implements ScryingLensOverlayRegistry.OverlayBuilder{
    @Override
    public void addLines(List<Pair<class_1799, class_2561>> list, class_2680 blockState, class_2338 blockPos, class_1657 playerEntity, class_1937 world, class_2350 direction) {
        var loci = world.method_8321(blockPos);
        if (loci instanceof SentinelLociEntity sent){
            var vec = sent.getSentPos();
            list.add(new Pair<>(
                    class_1802.field_8449.method_7854(),
                    HexUtils.styledWith(class_2561.method_43470(String.format("(%.2f, %.2f, %.2f)", vec.field_1352, vec.field_1351, vec.field_1350)), class_124.field_1061)
                    ));
        }
    }
}
