package org.sophia.slate_work.datagen;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.block.circle.BlockAbstractImpetus;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1747;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.data.client.*;
import org.sophia.slate_work.registries.BlockRegistry;

import java.util.Optional;

import static at.petrak.hexcasting.api.block.circle.BlockCircleComponent.ENERGIZED;
import static org.sophia.slate_work.Slate_work.MOD_ID;
import static org.sophia.slate_work.blocks.AbstractSlate.FACING;
import static org.sophia.slate_work.blocks.RedstoneLoci.POWERED;
import static org.sophia.slate_work.blocks.SaveLoci.HORIZONTAL;
import static org.sophia.slate_work.blocks.SaveLoci.TOP_PART;
import static org.sophia.slate_work.registries.BlockRegistry.ENERGIZED_BLOCKS;
import static org.sophia.slate_work.registries.BlockRegistry.SAVE_LOCI;

public class BlockModelDatagen extends FabricModelProvider {

    public BlockModelDatagen(FabricDataOutput output) {
        super(output);
    }

    @Override
    public void generateBlockStateModels(class_4910 generator) {

        registerEnergizedOnly("ambit_loci", BlockRegistry.AMBIT_LOCI, generator);
        registerEnergizedOnly("crafting_loci", BlockRegistry.CRAFTING_LOCI, generator);
        registerEnergizedOnly("broadcaster_loci", BlockRegistry.BROADCASTER_LOCI, generator);
        registerEnergizedFacing("storage_loci", BlockRegistry.STORAGE_LOCI, generator);
        registerEnergizedFacing("speed_loci", BlockRegistry.SPEED_LOCI, generator);
        registerEnergizedFacing("macro_loci", BlockRegistry.MACRO_LOCI, generator);
        registerEnergizedFacing("mute_loci", BlockRegistry.MUTE_LOCI, generator);
        registerEnergizedFacing("sentinel_loci", BlockRegistry.SENTINEL_LOCI, generator);
        registerEnergizedFacing("hotbar_loci", BlockRegistry.HOTBAR_LOCI, generator);
        registerSaveLoci("save_loci", SAVE_LOCI, generator);
        registerRedstoneLocus("redstone_loci", BlockRegistry.REDSTONE_LOCI, generator);
        registerEnergizedFacing("accelerator_loci", BlockRegistry.ACCELERATOR_LOCI, generator);

        registerImpetus("listening", BlockRegistry.LISTENING_IMPETUS, generator);
    }

    private static final String impeti = "block/impeti/";

    private static void registerRedstoneLocus(String name, class_2248 block, class_4910 generator){
        var bsvNormal = class_4935.method_25824().method_25828(class_4936.field_22887, new class_2960(MOD_ID, "block/" + name));
        var bsvEnergized = class_4935.method_25824().method_25828(class_4936.field_22887, new class_2960(MOD_ID, "block/" + name + "_energized"));
        var mapEnergy = class_4926.method_25783(POWERED).method_25793(true, bsvEnergized).method_25793(false, bsvNormal);

        var RotUp = class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22890);
        var RotNorth = class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22891);
        var RotDown = class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22892);
        var RotSouth = class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22892).method_25828(class_4936.field_22885, class_4936.class_4937.field_22891);
        var RotEast = class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22891).method_25828(class_4936.field_22885, class_4936.class_4937.field_22891);
        var RotWest = class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22893).method_25828(class_4936.field_22885, class_4936.class_4937.field_22891);

        class_4926 mapFac = class_4926.method_25783(FACING)
                .method_25793(class_2350.field_11036, RotUp)
                .method_25793(class_2350.field_11043, RotNorth)
                .method_25793(class_2350.field_11033, RotDown)
                .method_25793(class_2350.field_11035, RotSouth)
                .method_25793(class_2350.field_11034, RotEast)
                .method_25793(class_2350.field_11039, RotWest);

        generator.field_22830.accept(class_4925.method_25769(block).method_25775(mapEnergy).method_25775(mapFac));
    }

    private static void registerImpetus(String name, class_2248 block, class_4910 generator){
        var path = impeti+name+"/";
        String[] pain = {"top", "bottom", "front", "back", "left", "right"};
        class_4945[] morePain = {class_4945.field_23023, class_4945.field_23024, class_4945.field_23019, class_4945.field_23020, class_4945.field_23022, class_4945.field_23021};
        class_4944 lit = new class_4944();
        class_4944 unLit = new class_4944();
        lit.method_25868(class_4945.field_23012, new class_2960(HexAPI.MOD_ID, "block/slate"));
        unLit.method_25868(class_4945.field_23012, new class_2960(HexAPI.MOD_ID, "block/slate"));
        int i = 0;
        for (String ouch : pain) {
            lit.method_25868(morePain[i], new class_2960(MOD_ID, path+ouch+"_lit"));
            unLit.method_25868(morePain[i], new class_2960(MOD_ID, path+ouch+"_dim"));
            i++;
        }
        var litModel = class_4943.field_22942.method_25847(block, "_lit", lit, generator.field_22831);
        var dimModel = class_4943.field_22942.method_25847(block, "_dim", unLit, generator.field_22831);

        var RotNorth = class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22890);
        var RotSouth = class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22892);
        var RotUp = class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22893);
        var RotDown = class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22891);
        var RotEast = class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22891);
        var RotWest = class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22893);

        class_4926 mapFac = class_4926.method_25783(FACING)
                .method_25793(class_2350.field_11036, RotUp)
                .method_25793(class_2350.field_11043, RotNorth)
                .method_25793(class_2350.field_11033, RotDown)
                .method_25793(class_2350.field_11035, RotSouth)
                .method_25793(class_2350.field_11034, RotEast)
                .method_25793(class_2350.field_11039, RotWest);


        generator.field_22830.accept(class_4925.method_25769(block).method_25775(class_4926.method_25783(ENERGIZED)
                .method_35878(((aBoolean) -> {
                    class_4935 powered;
                    if (aBoolean) {
                        powered = class_4935.method_25824().method_25828(class_4936.field_22887, litModel); } else {
                        powered = class_4935.method_25824().method_25828(class_4936.field_22887, dimModel); }
                    return java.util.List.of(powered);
                }))).method_25775(mapFac)
        );
    }

    private static void registerSaveLoci(String name, class_2248 block, class_4910 generator){
        var bsvNormal = class_4935.method_25824().method_25828(class_4936.field_22887, new class_2960(MOD_ID,"block/"+name));
        var bsvEnergized = class_4935.method_25824().method_25828(class_4936.field_22887, new class_2960(MOD_ID,"block/" + name + "_energized"));

        var bsvTop = class_4935.method_25824().method_25828(class_4936.field_22887, new class_2960(MOD_ID, "block/empty"));
        var bsvBottom = class_4935.method_25824().method_25828(class_4936.field_22887, new class_2960(MOD_ID, "block/save_loci"));

        var mapTop = class_4926.method_25783(TOP_PART).method_25793(true, bsvTop).method_25793(false, bsvBottom);
        var map = class_4926.method_25783(ENERGIZED).method_25793(true,bsvEnergized).method_25793(false, bsvNormal);

        var facMap = class_4926.method_25783(HORIZONTAL)
                .method_25793(class_2350.field_11043, class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22890))
                .method_25793(class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22891))
                .method_25793(class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22892))
                .method_25793(class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22893));

        generator.field_22830.accept(class_4925.method_25769(block).method_25775(map).method_25775(mapTop).method_25775(facMap));
    }

    private static void registerEnergizedOnly(String name, class_2248 block, class_4910 generator){
        var bsvNormal = class_4935.method_25824().method_25828(class_4936.field_22887, new class_2960(MOD_ID,"block/"+name));
        var bsvEnergized = class_4935.method_25824().method_25828(class_4936.field_22887, new class_2960(MOD_ID,"block/" + name + "_energized"));
        var map = class_4926.method_25783(ENERGIZED).method_25793(true,bsvEnergized).method_25793(false, bsvNormal);

        generator.field_22830.accept(class_4925.method_25769(block).method_25775(map));
    }

    private static void registerEnergizedFacing(String name, class_2248 block, class_4910 generator) {
        var bsvNormal = class_4935.method_25824().method_25828(class_4936.field_22887, new class_2960(MOD_ID, "block/" + name));
        var bsvEnergized = class_4935.method_25824().method_25828(class_4936.field_22887, new class_2960(MOD_ID, "block/" + name + "_energized"));
        var mapEnergy = class_4926.method_25783(ENERGIZED).method_25793(true, bsvEnergized).method_25793(false, bsvNormal);

        var RotUp = class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22890);
        var RotNorth = class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22891);
        var RotDown = class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22892);
        var RotSouth = class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22892).method_25828(class_4936.field_22885, class_4936.class_4937.field_22891);
        var RotEast = class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22891).method_25828(class_4936.field_22885, class_4936.class_4937.field_22891);
        var RotWest = class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22893).method_25828(class_4936.field_22885, class_4936.class_4937.field_22891);

        class_4926 mapFac = class_4926.method_25783(FACING)
                .method_25793(class_2350.field_11036, RotUp)
                .method_25793(class_2350.field_11043, RotNorth)
                .method_25793(class_2350.field_11033, RotDown)
                .method_25793(class_2350.field_11035, RotSouth)
                .method_25793(class_2350.field_11034, RotEast)
                .method_25793(class_2350.field_11039, RotWest);

        generator.field_22830.accept(class_4925.method_25769(block).method_25775(mapEnergy).method_25775(mapFac));
    }

    @Override
    public void generateItemModels(class_4915 itemModelGenerator) {
        for (var item : ENERGIZED_BLOCKS.entrySet()){
            if (item.getKey().method_12832().equals("save_loci")) continue;
            if (item.getValue() instanceof class_1747 bi && bi.method_7711() instanceof BlockAbstractImpetus impetus) {
                itemModelGenerator.method_25733(item.getValue(), new class_4942(
                        Optional.of(new class_2960(item.getKey().method_12836(), "block/" + item.getKey().method_12832() + "_lit")),
                        Optional.empty()
                ));
            } else {
                itemModelGenerator.method_25733(item.getValue(), new class_4942(
                        Optional.of(new class_2960(item.getKey().method_12836(), "block/" + item.getKey().method_12832() + "_energized")),
                        Optional.empty()
                ));
            }
        }
        itemModelGenerator.method_25733(SAVE_LOCI.method_8389(), new class_4942(
                Optional.of(new class_2960(MOD_ID, "block/save_loci")),
                Optional.empty()
        ));
    }
}
