package org.sophia.slate_work.item;

import at.petrak.hexcasting.common.items.HexBaubleItem;
import at.petrak.hexcasting.common.lib.HexSounds;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import org.jetbrains.annotations.Nullable;
import org.sophia.slate_work.blocks.impetus.ListeningImpetusEntity;
import org.sophia.slate_work.registries.AttributeRegistry;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import net.minecraft.class_5151;

public class WhisperingStone extends class_1792 implements HexBaubleItem, class_5151 {
    //TODO: Maybe make this wearable/use Attributes?
    public WhisperingStone(class_1793 settings) {
        super(settings);
    }

    public static final class_1322 WHISPERING = new class_1322(
            UUID.fromString("8fe68dab-717e-4970-b0b3-be869fe608dd"),
            "Whispering Stone Speech", 1, class_1322.class_1323.field_6328);

    @Override
    public class_1269 method_7884(class_1838 context) {
        var world = context.method_8045();
        if (!world.method_8608()){
            var stack = context.method_8041();
            var entity = world.method_8321(context.method_8037());
            if (entity instanceof ListeningImpetusEntity listening && !listening.isDefault()){
                if (context.method_8036() != null){
                    context.method_8036().method_17356(HexSounds.ABACUS, class_3419.field_15248, 1f, 1f);
                }
                stack.method_7959("cords", class_2512.method_10692(listening.method_11016()));
                stack.method_7959("string", class_2519.method_23256(listening.getString()));
                return class_1269.field_5812;
            }
            if (context.method_8036() != null && context.method_8036().method_5715() && stack.method_7941("cords") != null) {
                context.method_8036().method_17356(HexSounds.ABACUS_SHAKE, class_3419.field_15248, 1f, 1f);
                stack.method_7983("cords");
                stack.method_7983("string");
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!world.field_9236){

            var stack = user.method_5998(hand);
            var cordNBT = stack.method_7941("cords");
            if (cordNBT != null && world.method_8321(class_2512.method_10691(cordNBT)) instanceof ListeningImpetusEntity listening){
                var compound = new class_2487();
                compound.method_10582("stringed", listening.getString());
                stack.method_7959("string", compound);
            } else {
                stack.method_7983("cords");
                stack.method_7983("string");
            }
            return class_1271.method_22430(stack);
        }
        return super.method_7836(world, user, hand);
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        var cordNBT = stack.method_7941("cords");
        var stringNBT = stack.method_7941("string");
        if (cordNBT != null && stringNBT != null){
            tooltip.add(class_2561.method_43471("item.slate_work.whispering_stone.string").method_10852(
                    class_2561.method_43470(stringNBT.method_10558("stringed")).method_27695(class_124.field_1076, class_124.field_1067)
            ));
            tooltip.add(class_2561.method_43471("item.slate_work.whispering_stone.cords").method_10852(
                    class_2561.method_43470("(").method_27693(class_2512.method_10691(cordNBT).method_23854()).method_27693(")").method_27692(class_124.field_1061)
            ));
        } else {
            tooltip.add(class_2561.method_43471("item.slate_work.whispering_stone.no_cords").method_27692(class_124.field_1061));
        }
    }

    @Override
    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        var out = HashMultimap.create(super.method_7844(slot));
        if (slot == class_1304.field_6174 || slot == class_1304.field_6173 || slot == class_1304.field_6171) {
            out.put(AttributeRegistry.WHISPERING, WHISPERING);
        }
        return out;
    }

    @Override
    public Multimap<class_1320, class_1322> getHexBaubleAttrs(class_1799 stack) {
        HashMultimap<class_1320, class_1322> out = HashMultimap.create();
        out.put(AttributeRegistry.WHISPERING, WHISPERING);
        return out;
    }

    @Override
    public class_1304 method_7685() {
        return class_1304.field_6174;
    }
}
