package org.sophia.slate_work.misc;

import org.jetbrains.annotations.Nullable;
import org.sophia.slate_work.blocks.impetus.ListeningImpetusEntity;
import org.sophia.slate_work.compat.SlateWorksTrinkets;
import org.sophia.slate_work.registries.AttributeRegistry;
import org.sophia.slate_work.registries.BlockRegistry;
import org.sophia.slate_work.saving.Listeners;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2512;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class ChatHelper {
    private static ChatHelper helper;
    private Boolean TRINKETS = false;
    public class_3545<String, Long> LAST_CHECK_DATA = new class_3545<>("", 0L);
    public ShouldRun LAST_CHECK = new ShouldRun(false, false, "", Optional.empty(), false, Optional.empty());

    public static ChatHelper getHelper() {
        if (helper == null){
            return new ChatHelper();
        }
        return helper;
    }

    private ChatHelper(){
        helper = this;
    }

    public void setTRINKETS(Boolean TRINKETS) {
        this.TRINKETS = TRINKETS;
    }

    public ShouldRun of(boolean blocked, boolean item, String string, Optional<ListeningImpetusEntity> entity, boolean failed, Optional<class_1799> whispering){
        ShouldRun record = new ShouldRun(blocked, item, string, entity, failed, whispering);
        if (entity.isPresent() && entity.get().method_10997() != null) {
            this.LAST_CHECK = record;
            this.LAST_CHECK_DATA = new class_3545<>(string, entity.get().method_10997().method_8510());
        }
        return record;
    }

    public ChatHelper.ShouldRun willBlock(String compared, class_3222 sender){
        if (compared.equals(LAST_CHECK_DATA.method_15442()) && sender.method_37908().method_8510() == LAST_CHECK_DATA.method_15441()){
            return LAST_CHECK;
        }
        class_3218 world = sender.method_51469();
        if (sender.method_26825(AttributeRegistry.WHISPERING) > 0) {
            var ref = new ItemHold();
            sender.method_5877().iterator().forEachRemaining((item) -> {
                if (item.method_31574(BlockRegistry.WHISPERING_STONE)) {
                    ref.stack = item;
                }
            });
            if (ref.stack == null) {
                sender.method_5661().forEach((item) -> {
                    if (item.method_31574(BlockRegistry.WHISPERING_STONE)) {
                        ref.stack = item;
                    }
                });
            }
            if (ref.stack == null && TRINKETS) {
                SlateWorksTrinkets.finder(ref, sender);
            }

            if (ref.stack != null) {
                var cordNBT = ref.stack.method_7941("cords");
                if (cordNBT != null) {
                    if (world.method_8321(class_2512.method_10691(cordNBT)) instanceof ListeningImpetusEntity entity) {
                        if (compared.startsWith(entity.getString())) {
                            if (entity.isRunning()) {
                                return of(true, true, compared, Optional.empty(), false, Optional.of(ref.stack));
                            } else {
                                return of(true, true, compared, Optional.of(entity), false, Optional.of(ref.stack));
                            }
                        }
                    } else {
                        var mon = ref.stack.method_7941("string");
                        if (mon != null) {
                            var string = mon.method_10558("stringed");
                            if (compared.startsWith(string)) {
                                return of(true, true, compared, Optional.empty(), true, Optional.of(ref.stack));
                            }
                        }
                    }

                }
            }
        }
        for (var listen : Listeners.getListenersAroundPos(sender.method_51469(), sender.method_24515())){
            if (world.method_8321(listen) instanceof ListeningImpetusEntity entity){
                if (entity.isRunning()) continue;
                if (entity.method_11016().method_19770(sender.method_19538()) < 16*16 && compared.startsWith(entity.getString()))
                    return of(true, false, compared, Optional.of(entity), false, Optional.empty());
            }
        }
        return of(false, false, compared, Optional.empty(), false, Optional.empty());
    }


    /**
     * @param blocked is if the message should be blocked
     * @param item is if it was casted via the item
     * @param string is the message that will be sent to the Listening Impetus Entity
     * @param entity is the Listening Impetus Entity
     * @param failed is if the item "hard failed" (IE: if it should be cleared)
     * @param whispering is the Whispering Stone that was used
     *
     * **/
    public record ShouldRun(boolean blocked, boolean item, String string, Optional<ListeningImpetusEntity> entity, boolean failed, Optional<class_1799> whispering){}
    public class ItemHold{
        @Nullable class_1799 stack;

        public @Nullable class_1799 getStack() {
            return stack;
        }

        public void setStack(@Nullable class_1799 stack) {
            this.stack = stack;
        }
    }
}
