package org.sophia.slate_work.mixins;

import at.petrak.hexcasting.api.casting.circles.ICircleComponent;
import at.petrak.hexcasting.api.casting.eval.ExecutionClientView;
import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.ListIota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.blocks.circles.BlockSlate;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.*;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

@Mixin(BlockSlate.class)
public abstract class MixinBlockSlate {

    @Inject(method = "acceptControlFlow",
            at = @At(value = "INVOKE",
                    target = "Lat/petrak/hexcasting/api/casting/eval/vm/CastingVM;queueExecuteAndWrapIota(Lat/petrak/hexcasting/api/casting/iota/Iota;Lnet/minecraft/server/world/ServerWorld;)Lat/petrak/hexcasting/api/casting/eval/ExecutionClientView;"
            ), cancellable = true)
    void slate_works$acceptControlFlow(CastingImage imageIn, CircleCastEnv env, class_2350 enterDir, class_2338 pos, class_2680 bs,
                      class_3218 world, CallbackInfoReturnable<ICircleComponent.ControlFlow> cir, @Local HexPattern pattern,
                      @Local Stream exitDirs, @Local CastingVM vm){
        var macroNBT = imageIn.getUserData().method_10554("macros", class_2520.field_33260);
        String angleSig = pattern.anglesSignature();

        Map<String, Iota> macros = new HashMap<>();
        for (class_2520 temp : macroNBT) {
            class_2487 nbtElement = (class_2487) temp;
            macros.put(
                    HexPattern.fromNBT(nbtElement.method_10562("pattern")).anglesSignature(),
                    IotaType.deserialize(nbtElement.method_10562("macro") ,world)
            );
        }
        if (macros.containsKey(angleSig)){
            var macro = macros.get(angleSig);
            ExecutionClientView result;

            if (macro instanceof ListIota pain){

                var spell = new ArrayList<Iota>();
                for (var iota : pain.getList()){
                    spell.add(iota);
                }

                result = vm.queueExecuteAndWrapIotas(spell, world);
            } else {

                result = vm.queueExecuteAndWrapIota(macro, world);
            }

            cir.setReturnValue(result.getResolutionType().getSuccess() ? new ICircleComponent.ControlFlow.Continue(vm.getImage(), exitDirs.toList()) : new ICircleComponent.ControlFlow.Stop());
            cir.cancel();
        }
    }
}
