package org.sophia.slate_work.mixins;

import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.circles.CircleExecutionState;
import at.petrak.hexcasting.api.casting.circles.ICircleComponent;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

@Mixin(ICircleComponent.class)
public interface MixinCircleComponent {
    @Inject(method = "sfx",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/player/PlayerEntity;DDDLnet/minecraft/sound/SoundEvent;Lnet/minecraft/sound/SoundCategory;FF)V"),
            locals = LocalCapture.CAPTURE_FAILSOFT,
            cancellable = true
    ) // A *few* extra vars
    private static void slate_work$shushYou(class_2338 pos, class_2680 bs, class_1937 world, BlockEntityAbstractImpetus impetus, boolean success, CallbackInfo ci, class_243 vpos, class_243 vecOutDir, FrozenPigment colorizer, UUID activator, float pitch, class_3414 sound){
        if (impetus != null){
            var image = impetus.getExecutionState().currentImage;
            var volume = image.getUserData().method_10583("volume");
            var mute = image.getUserData().method_10577("mute");
            if (mute){
                world.method_43128(null, vpos.field_1352, vpos.field_1351, vpos.field_1350, sound, class_3419.field_15245, volume, pitch);
                ci.cancel();
            }
        }
    }
}
