package org.sophia.slate_work.mixins;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.circles.CircleExecutionState;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.sideeffects.EvalSound;
import at.petrak.hexcasting.api.utils.MediaHelper;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import org.jetbrains.annotations.Nullable;
import org.sophia.slate_work.blocks.entities.HotbarLociEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import javax.print.attribute.standard.Media;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2512;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

@Mixin(CircleCastEnv.class)
public abstract class MixinCircleEnv extends CastingEnvironment{
    public MixinCircleEnv(class_3218 world, CircleExecutionState execState) {
        super(world);
    }

    @Shadow public abstract CircleExecutionState circleState();

    @Shadow @Final protected CircleExecutionState execState;

    @Shadow public abstract @Nullable BlockEntityAbstractImpetus getImpetus();

    @WrapOperation(method = "postExecution(Lat/petrak/hexcasting/api/casting/eval/CastResult;)V",
            at = @At(value = "INVOKE",
                    target = "Lat/petrak/hexcasting/api/casting/eval/sideeffects/EvalSound;sound()Lnet/minecraft/sound/SoundEvent;"
            )
    )
    public class_3414 slate_work$shushYouToo(EvalSound instance, Operation<class_3414> original){
        var image = this.circleState().currentImage;
        var volume = image.getUserData().method_10583("volume");
        var mute = image.getUserData().method_10577("mute");
        if (mute && this.getImpetus() != null && volume != 0 && instance.sound() != null){
            if (this.getImpetus().method_10997() != null) {
                class_2338 soundPos = this.execState.currentPos;
                this.getImpetus().method_10997().method_8396(null, soundPos, instance.sound(), class_3419.field_15248, volume, 1.0F);
            }
        }
        return null;
    }

    @Inject(method = "getUsableStacks", at = @At("RETURN"), cancellable = true, remap = false)
    private void slate_work$getUsableStacks(CastingEnvironment.StackDiscoveryMode mode, CallbackInfoReturnable<List<class_1799>> cir){
        var data = this.execState.currentImage.getUserData();
        if (world.method_8321(class_2512.method_10691(data.method_10562("hotbar_loci"))) instanceof HotbarLociEntity entity){
            //var list = cir.getReturnValue();
            var list = new ArrayList<>(entity.getStacksSorted());
            list.addAll(cir.getReturnValue());
            cir.setReturnValue(list);
        }
    }

    @Inject(method = "getPrimaryStacks", at = @At("RETURN"), cancellable = true, remap = false)
    private void slate_work$gePrimaryStacks(CallbackInfoReturnable<List<HeldItemInfo>> cir){
        var data = this.execState.currentImage.getUserData();
        if (world.method_8321(class_2512.method_10691(data.method_10562("hotbar_loci"))) instanceof HotbarLociEntity entity){
            var list = new ArrayList<>(cir.getReturnValue()); //makes it Mutable
            list.add(new HeldItemInfo(entity.getCurrentSlot(), class_1268.field_5810));
            cir.setReturnValue(list);
        }
    }

    @Inject(method = "replaceItem", at = @At("RETURN"), cancellable = true)
    private void slate_work$replaceItem(Predicate<class_1799> stackOk, class_1799 replaceWith, @Nullable class_1268 hand, CallbackInfoReturnable<Boolean> cir){
        if (cir.getReturnValue()) return;
        var data = this.execState.currentImage.getUserData();
        if (world.method_8321(class_2512.method_10691(data.method_10562("hotbar_loci"))) instanceof HotbarLociEntity entity){
            int slot = 0;
            for (class_1799 stack: entity.getStacksSorted()){
                if (stackOk.test(stack)){
                    entity.setStack(slot, replaceWith);
                    entity.sync();
                    cir.setReturnValue(true);
                    return;
                }
                slot++;
            }
        }
    }

    @Inject(method = "extractMediaEnvironment", at = @At("RETURN"), cancellable = true, remap = false)
    private void slate_work$extractMedia(long cost, boolean simulate, CallbackInfoReturnable<Long> cir){
        var data = this.execState.currentImage.getUserData();
        if (world.method_8321(class_2512.method_10691(data.method_10562("hotbar_loci"))) instanceof HotbarLociEntity entity){
            var media = cir.getReturnValue();

            ArrayList<ADMediaHolder> sources = new ArrayList<>();
            for (class_1799 item : entity.getStacksSorted()) {
                var holder = HexAPI.instance().findMediaHolder(item);
                if (holder != null && holder.canProvide()) sources.add(holder);
            }
            sources.sort(MediaHelper::compareMediaItem);

            for (var source : sources) {
                var found = MediaHelper.extractMedia(source, media, false, simulate);
                media -= found;
                if (media <= 0) {
                    break;
                }
            }
            cir.setReturnValue(media);
        }
    }
}
