package org.sophia.slate_work.registries;

import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.sophia.slate_work.blocks.*;
import org.sophia.slate_work.blocks.entities.*;
import org.sophia.slate_work.blocks.impetus.ListeningImpetus;
import org.sophia.slate_work.blocks.impetus.ListeningImpetusEntity;
import org.sophia.slate_work.item.AllayPigment;
import org.sophia.slate_work.item.WhisperingStone;

import java.util.HashMap;

import static at.petrak.hexcasting.api.block.circle.BlockCircleComponent.ENERGIZED;
import static net.minecraft.class_1814.field_8907;
import static org.sophia.slate_work.Slate_work.MOD_ID;

import AmbitLoci;
import SpeedLoci;

public class BlockRegistry {
    private static final class_4970.class_2251 slateSetting = class_4970.class_2251.method_9630(class_2246.field_28888).method_29292().method_9629(1.5F, 6.0F);
    private static final class_4970.class_2251 locusSetting = slateSetting.method_50012(class_3619.field_15971);


    private static final HashMap<class_2960, class_2248> BLOCK_REGISTRY = new HashMap<>();
    private static final HashMap<class_2960, class_1792> ITEM_REGISTRY = new HashMap<>();
    public static HashMap<class_2960, class_1792> ENERGIZED_BLOCKS = new HashMap<>();

    public static StorageLoci STORAGE_LOCI = registerBlockItem("storage_loci", new StorageLoci(locusSetting));
    public static CraftingLoci CRAFTING_LOCI = registerBlockItem("crafting_loci", new CraftingLoci(locusSetting.method_22488()));
    public static AmbitLoci AMBIT_LOCI = registerBlockItem("ambit_loci", new AmbitLoci(locusSetting));
    public static SpeedLoci SPEED_LOCI = registerBlockItem("speed_loci", new SpeedLoci(locusSetting));
    public static MacroLoci MACRO_LOCI = registerBlockItem("macro_loci", new MacroLoci(locusSetting));
    public static MuteLoci MUTE_LOCI = registerBlockItem("mute_loci", new MuteLoci(locusSetting));
    public static SentinelLoci SENTINEL_LOCI = registerBlockItem("sentinel_loci", new SentinelLoci(locusSetting));
    public static BroadcasterLoci BROADCASTER_LOCI = registerBlockItem("broadcaster_loci", new BroadcasterLoci(locusSetting));
    public static SaveLoci SAVE_LOCI = registerBlockItem("save_loci", new SaveLoci(locusSetting.method_50012(class_3619.field_15972)));
    public static HotbarLoci HOTBAR_LOCI = registerBlockItem("hotbar_loci", new HotbarLoci(locusSetting));
    public static RedstoneLoci REDSTONE_LOCI = registerBlockItem("redstone_loci", new RedstoneLoci(locusSetting));
    public static AcceleratorLoci ACCELERATOR_LOCI = registerBlockItem("accelerator_loci", new AcceleratorLoci(locusSetting));

    public static ListeningImpetus LISTENING_IMPETUS = registerBlockItem("listening_impetus", new ListeningImpetus(locusSetting.method_50012(class_3619.field_15972)));


    public static class_2591<StorageLociEntity> STORAGE_LOCI_ENTITY = registerBlockEntity("storage_loci",
            FabricBlockEntityTypeBuilder.create(StorageLociEntity::new, STORAGE_LOCI).build());
    public static class_2591<CraftingLociEntity> CRAFTING_LOCI_ENTITY = registerBlockEntity("crafting_loci",
            FabricBlockEntityTypeBuilder.create(CraftingLociEntity::new, CRAFTING_LOCI).build());
    public static class_2591<MacroLociEntity> MACRO_LOCI_ENTITY = registerBlockEntity("macro_loci",
            FabricBlockEntityTypeBuilder.create(MacroLociEntity::new, MACRO_LOCI).build());
    public static class_2591<SentinelLociEntity> SENTINEL_LOCI_ENTITY = registerBlockEntity("sentinel_loci",
            FabricBlockEntityTypeBuilder.create(SentinelLociEntity::new, SENTINEL_LOCI).build());
    public static class_2591<BroadcasterLociEntity> BROADCASTER_LOCI_ENTITY = registerBlockEntity("broadcaster_loci",
            FabricBlockEntityTypeBuilder.create(BroadcasterLociEntity::new, BROADCASTER_LOCI).build());
    public static class_2591<SaveLociEntity> SAVE_LOCI_ENTITY = registerBlockEntity("save_loci",
            FabricBlockEntityTypeBuilder.create(SaveLociEntity::new, SAVE_LOCI).build());
    public static class_2591<HotbarLociEntity> HOTBAR_LOCI_ENTITY = registerBlockEntity("hotbar_loci",
            FabricBlockEntityTypeBuilder.create(HotbarLociEntity::new, HOTBAR_LOCI).build());
    
    public static class_2591<ListeningImpetusEntity> LISTENING_IMPETUS_ENTITY = registerBlockEntity("listening_impetus",
            FabricBlockEntityTypeBuilder.create(ListeningImpetusEntity::new, LISTENING_IMPETUS).build());


    public static AllayPigment ALLAY_PIGMENT = registerItem("allay_pigment", new AllayPigment(new class_1792.class_1793().method_7889(1)));
    public static WhisperingStone WHISPERING_STONE = registerItem("whispering_stone", new WhisperingStone(new class_1792.class_1793().method_7889(1)));

    public static final class_5321<class_1761> SLATE_WORK_GROUP_KEY = class_5321.method_29179(class_7923.field_44687.method_30517(), new class_2960(MOD_ID,"item_group"));
    public static final class_1761 SLATE_WORK_GROUP = FabricItemGroup.builder()
            .method_47320(() -> new class_1799(AMBIT_LOCI))
            .method_47321(class_2561.method_43471("itemGroup.slate_work")).method_47324();

    public static void init(){
        for (var e : BLOCK_REGISTRY.entrySet()){
            class_2378.method_10230(class_7923.field_41175, e.getKey(),e.getValue());
        }

        for (var e : ITEM_REGISTRY.entrySet()){
            class_2378.method_10230(class_7923.field_41178, e.getKey(), e.getValue());
            if (e.getValue() instanceof class_1747 block && block.method_7711() instanceof BlockCircleComponent){
                ENERGIZED_BLOCKS.put(e.getKey(), e.getValue());
            }
            ItemGroupEvents.modifyEntriesEvent(SLATE_WORK_GROUP_KEY).register(group -> group.method_45421(e.getValue()));
        }

        class_2378.method_39197(class_7923.field_44687, SLATE_WORK_GROUP_KEY, SLATE_WORK_GROUP);
    }


    private static <T extends class_2248> T registerBlockItem(String name, T block){
        BLOCK_REGISTRY.put(new class_2960(MOD_ID,name), block);
        ITEM_REGISTRY.put(new class_2960(MOD_ID,name), new class_1747(block.method_9564().method_11657(ENERGIZED, true).method_26204(), new class_1792.class_1793().method_7894(field_8907)));
        return block;
    }

    private static <T extends class_2591<?>> T registerBlockEntity(String name, T blockEntityType){
        return class_2378.method_10230(class_7923.field_41181, new class_2960(MOD_ID,name), blockEntityType);
    }

    private static <T extends class_1792> T registerItem(String name, T item){
        ITEM_REGISTRY.put(new class_2960(MOD_ID,name), item);
        return item;
    }
}
