package org.sophia.slate_work.registries;

import at.petrak.hexcasting.api.casting.eval.vm.ContinuationFrame;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import org.jetbrains.annotations.NotNull;
import org.sophia.slate_work.casting.contuinations.FrameCheckItems;
import org.sophia.slate_work.casting.contuinations.FrameGetItems;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

import static at.petrak.hexcasting.api.HexAPI.modLoc;

public class FrameRegistry {
    private static final Map<class_2960, ContinuationFrame.Type<?>> CONTINUATIONS = new LinkedHashMap<>();
    public static final class_2378<ContinuationFrame.Type<?>> REGISTRY = IXplatAbstractions.INSTANCE.getContinuationTypeRegistry();

    public static void init(){
        for (var e : CONTINUATIONS.entrySet()){
            class_2378.method_10230(REGISTRY,e.getKey(),e.getValue());
        }
    }

    public static final ContinuationFrame.Type<@NotNull FrameGetItems> GET_ITEM = continuation("get_items", FrameGetItems.TYPE);
    public static final ContinuationFrame.Type<@NotNull FrameCheckItems> CHECK_ITEM = continuation("check_items", FrameCheckItems.TYPE);


    // Who would be copying Hex Code :clueless:
    private static <U extends ContinuationFrame, T extends ContinuationFrame.Type<U>> T continuation(String name, T continuation) {
        var old = CONTINUATIONS.put(modLoc(name), continuation);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + name);
        }
        return continuation;
    }
}
