package org.sophia.slate_work.saving;

import org.sophia.slate_work.blocks.impetus.ListeningImpetusEntity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

import static org.sophia.slate_work.Slate_work.chunk_listeners;

@SuppressWarnings("UnstableApiUsage")
public class Listeners {

    /** Returns a stored list of Listeners **/
    @SuppressWarnings("ComparatorMethodParameterNotUsed")
    public static List<class_2338> getListenersAroundPos(class_3218 world, class_2338 centerPos){
        var centerChunk = new class_1923(centerPos);
        ArrayList<class_2338> listeners = new ArrayList<>();
        for (var i = 0; i < 9; i++) { // gets all the chunks around the player in a 3x3 cube
            var x = (i % 3) -1;
            var z = ((int) (Math.floor(i/3.0)) % 3) -1;
            listeners.addAll(getListeners(world, centerChunk.field_9181 + x, centerChunk.field_9180 + z));
        }
        listeners.sort((a, b) -> { // cant have 2 BlockPoses at the same point
            if (a.method_10262(centerPos) > b.method_10262(centerPos)) {
                return 1;
            }
            return -1;
        });
        return listeners;
    }

    public static void saveListener(class_3218 world, class_2338 pos){
        var chunk = world.method_22350(pos);
        var z = new ArrayList<>(chunk.getAttachedOrCreate(chunk_listeners)); // it *really* doesn't like messing with the given Array
        z.add(pos.method_10062()); // Sometimes they were added as "mutable," so just to make sure they are all the same type
        chunk.setAttached(chunk_listeners, z);
        checkListeners(world, pos);
        chunk.method_12008(true); // Might not need this? But not a bad idea
    }

    public static void removeListener(class_3218 world, class_2338 pos){
        var chunk = world.method_22350(pos);
        var z = new ArrayList<>(chunk.getAttachedOrCreate(chunk_listeners));
        z.remove(pos);
        chunk.setAttached(chunk_listeners, z);
        checkListeners(world, pos);
        chunk.method_12008(true);
    }

    // Checks if there are any invalid Listeners, and cleans them up
    public static void checkListeners(class_3218 world, class_2338 pos){
        var z = getListeners(world, pos);
        z.removeIf(x -> !(world.method_8321(x) instanceof ListeningImpetusEntity));
        world.method_22350(pos).setAttached(chunk_listeners, z);
    }

    public static List<class_2338> getListeners(class_3218 world, class_2338 pos){
        var chunk = world.method_22350(pos);
        return new ArrayList<>(chunk.getAttachedOrCreate(chunk_listeners));
    }

    public static List<class_2338> getListeners(class_3218 world, class_1923 pos){
        var chunk = world.method_8497(pos.field_9181, pos.field_9180);
        return new ArrayList<>(chunk.getAttachedOrCreate(chunk_listeners));
    }

    public static List<class_2338> getListeners(class_3218 world, int x, int z){
        var chunk = world.method_8497(x, z);
        return new ArrayList<>(chunk.getAttachedOrCreate(chunk_listeners));
    }
}
