/*
 * Decompiled with CFR 0.152.
 */
package org.sophia.slate_work.blocks.entities;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import org.sophia.slate_work.GUI.FakeInvHotbarLoci;
import org.sophia.slate_work.GUI.HotbarLociScreenHandler;
import org.sophia.slate_work.registries.BlockRegistry;
import org.sophia.slate_work.storage.HotbarLociSlot;
import org.sophia.slate_work.storage.LociIterator;

public class HotbarLociEntity
extends HexBlockEntity
implements SlottedStorage<ItemVariant>,
ExtendedScreenHandlerFactory {
    private final class_2371<class_1799> stacks = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
    private int slot = 0;

    public HotbarLociEntity(class_2338 pWorldPosition, class_2680 pBlockState) {
        super(BlockRegistry.HOTBAR_LOCI_ENTITY, pWorldPosition, pBlockState);
    }

    protected void saveModData(class_2487 tag) {
        class_1262.method_5426((class_2487)tag, this.stacks);
        tag.method_10569("select", this.slot);
    }

    protected void loadModData(class_2487 tag) {
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.stacks.clear();
        }
        class_1262.method_5429((class_2487)tag, this.stacks);
        this.slot = tag.method_10550("select");
    }

    public class_1799 removeStack(int slot) {
        class_1799 stack = ((class_1799)this.stacks.get(slot)).method_7972();
        this.stacks.set(slot, (Object)class_1799.field_8037);
        this.sync();
        return stack;
    }

    public class_1799 removeStack(int slot, int count) {
        class_1799 stack = (class_1799)this.stacks.get(slot);
        this.sync();
        return stack.method_7971(count);
    }

    public List<class_1799> getStacks() {
        return this.stacks;
    }

    public List<class_1799> getStacksSorted() {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        for (int i = 0; i < 6; ++i) {
            list.add(this.getSlotStack(Math.floorMod(this.getSlot() + i, 6)));
        }
        return list;
    }

    public class_1799 getCurrentSlot() {
        return (class_1799)this.stacks.get(this.getSlot());
    }

    public int getSlot() {
        return Math.floorMod(this.slot, 5);
    }

    public void setSlot(int slot) {
        this.slot = slot;
        this.sync();
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.slate_work.hotbar_loci");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new HotbarLociScreenHandler(syncId, playerInventory, this);
    }

    public void setStack(int slot, class_1799 stack) {
        this.stacks.set(slot, (Object)stack);
        this.sync();
    }

    public void sync() {
        super.sync();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            world.method_14178().method_14128(this.method_11016());
        }
    }

    public class_1263 getInv() {
        return new FakeInvHotbarLoci(this);
    }

    public @UnmodifiableView List<SingleSlotStorage<ItemVariant>> getSlots() {
        ArrayList<SingleSlotStorage<ItemVariant>> slots = new ArrayList<SingleSlotStorage<ItemVariant>>();
        int i = 0;
        for (class_1799 item : this.stacks) {
            slots.add(new HotbarLociSlot(this, i));
            ++i;
        }
        return slots;
    }

    public int getSlotCount() {
        return 6;
    }

    public SingleSlotStorage<ItemVariant> getSlot(int slot) {
        return new HotbarLociSlot(this, slot);
    }

    public int getFreeSlot(ItemVariant variant) {
        int i = 0;
        for (class_1799 item : this.stacks) {
            if ((ItemVariant.of((class_1799)item) == variant || item.method_7960()) && item.method_7914() > item.method_7947()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public class_1799 getSlotStack(int slot) {
        return (class_1799)this.stacks.get(slot);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        int slot = this.getFreeSlot(resource);
        if (slot == -1) {
            return 0L;
        }
        class_1799 stack = this.getSlotStack(slot);
        class_1799 copy = stack.method_7972();
        if (copy.method_7960()) {
            this.setStack(slot, resource.toStack((int)maxAmount));
            this.sync();
        }
        if ((long)copy.method_7947() + maxAmount > (long)copy.method_7914()) {
            stack.method_7939(copy.method_7914());
            this.sync();
            return maxAmount - (long)copy.method_7947();
        }
        stack.method_7939(copy.method_7947() + (int)maxAmount);
        this.sync();
        return maxAmount;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        transaction.addCloseCallback((a, b) -> {
            if (b.wasCommitted()) {
                class_1799 stack;
                int i = 0;
                Iterator iterator = this.stacks.iterator();
                while (iterator.hasNext() && !ItemVariant.of((class_1799)(stack = (class_1799)iterator.next())).equals(resource)) {
                    ++i;
                }
                this.getStacks().get(i).method_7971((int)maxAmount);
                this.sync();
            }
        });
        class_1799 selected = null;
        for (class_1799 stack : this.stacks) {
            if (!ItemVariant.of((class_1799)stack).equals(resource)) continue;
            selected = stack;
            break;
        }
        if (selected == null) {
            return 0L;
        }
        int count = selected.method_7947();
        if ((long)count > maxAmount) {
            return maxAmount;
        }
        return count;
    }

    @NotNull
    public Iterator<StorageView<ItemVariant>> iterator() {
        return new LociIterator<HotbarLociEntity>(this);
    }
}

