/*
 * Decompiled with CFR 0.152.
 */
package org.sophia.slate_work.blocks.entities;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import org.sophia.slate_work.registries.BlockRegistry;
import org.sophia.slate_work.storage.LociIterator;
import org.sophia.slate_work.storage.StorageLociSlot;

public class StorageLociEntity
extends HexBlockEntity
implements SlottedStorage<ItemVariant> {
    private static final class_3545<ItemVariant, Long> emptySlot = new class_3545((Object)ItemVariant.blank(), (Object)0L);
    private final class_3545<ItemVariant, Long>[] slots = (class_3545[])class_2371.method_10213((int)16, emptySlot).toArray((Object[])new class_3545[16]);

    public StorageLociEntity(class_2338 pos, class_2680 state) {
        super(BlockRegistry.STORAGE_LOCI_ENTITY, pos, state);
    }

    protected void saveModData(class_2487 nbt) {
        class_2499 nbtList = new class_2499();
        for (int i = 0; i < this.slots.length; ++i) {
            ItemVariant stack = (ItemVariant)this.slots[i].method_15442();
            if (stack.isBlank()) continue;
            class_2487 nbtCompound = new class_2487();
            nbtCompound.method_10567("Slot", (byte)i);
            nbtCompound.method_10566("Item", (class_2520)stack.toNbt());
            nbtCompound.method_10544("Count", ((Long)this.slots[i].method_15441()).longValue());
            nbtList.add((Object)nbtCompound);
        }
        if (!nbtList.isEmpty()) {
            nbt.method_10566("Items", (class_2520)nbtList);
            nbt.method_10556("Empty", false);
        } else {
            nbt.method_10556("Empty", true);
        }
    }

    protected void loadModData(class_2487 nbt) {
        class_2499 items = nbt.method_10554("Items", 10);
        if (nbt.method_10577("Empty")) {
            this.clear();
        }
        for (int i = 0; i < this.slots.length; ++i) {
            class_3545 stack;
            class_2487 compound = items.method_10602(i);
            this.slots[i] = stack = new class_3545((Object)ItemVariant.fromNbt((class_2487)compound.method_10562("Item")), (Object)compound.method_10537("Count"));
        }
    }

    public boolean isEmpty() {
        for (class_3545<ItemVariant, Long> z : this.slots) {
            if (((ItemVariant)z.method_15442()).isBlank() && (Long)z.method_15441() == 0L) continue;
            return false;
        }
        return true;
    }

    public int isFull() {
        int i = 0;
        for (class_3545<ItemVariant, Long> z : this.slots) {
            if (((ItemVariant)z.method_15442()).isBlank() || (Long)z.method_15441() == 0L) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public class_3545<ItemVariant, Long> getStack(int slot) {
        return new class_3545((Object)((ItemVariant)this.slots[slot].method_15442()), (Object)((Long)this.slots[slot].method_15441()));
    }

    public class_3545<ItemVariant, Long>[] getInventory() {
        return this.slots;
    }

    public class_3545<ItemVariant, Long> removeStack(int slot, int amount) {
        long returned;
        if (amount <= 0) {
            return emptySlot;
        }
        class_3545<ItemVariant, Long> pair = this.slots[slot];
        ItemVariant copy = (ItemVariant)pair.method_15442();
        if (copy == ItemVariant.blank() || (Long)pair.method_15441() == 0L) {
            this.slots[slot] = emptySlot;
            return emptySlot;
        }
        if ((Long)pair.method_15441() <= (long)amount) {
            returned = (Long)pair.method_15441();
            this.slots[slot] = emptySlot;
        } else {
            this.slots[slot].method_34965((Object)((Long)this.slots[slot].method_15441() - (long)amount));
            returned = amount;
        }
        this.sync();
        return new class_3545((Object)copy, (Object)returned);
    }

    @Nullable
    public Integer getSlot(ItemVariant item) {
        for (int i = 0; i < this.slots.length; ++i) {
            ItemVariant stored = (ItemVariant)this.slots[i].method_15442();
            if (item.getItem() != stored.getItem() || item.getNbt() != stored.getNbt()) continue;
            return i;
        }
        this.sync();
        return null;
    }

    public class_3545<ItemVariant, Long> removeStack(int slot) {
        class_3545<ItemVariant, Long> pair = this.slots[slot];
        ItemVariant copy = (ItemVariant)pair.method_15442();
        if (!copy.isBlank()) {
            this.slots[slot] = new class_3545((Object)((ItemVariant)emptySlot.method_15442()), (Object)((Long)emptySlot.method_15441()));
        }
        this.sync();
        return new class_3545((Object)copy, (Object)((Long)pair.method_15441()));
    }

    public void setStack(int slot, ItemVariant stack, long amount) {
        if (amount <= 0L) {
            this.slots[slot] = new class_3545((Object)((ItemVariant)emptySlot.method_15442()), (Object)((Long)emptySlot.method_15441()));
            this.sync();
            return;
        }
        this.slots[slot] = new class_3545((Object)stack, (Object)amount);
        this.sync();
    }

    public void setStack(int slot, class_3545<ItemVariant, Long> pair) {
        this.setStack(slot, (ItemVariant)pair.method_15442(), (Long)pair.method_15441());
    }

    public void clear() {
        Arrays.fill(this.slots, new class_3545((Object)((ItemVariant)emptySlot.method_15442()), (Object)((ItemVariant)emptySlot.method_15442())));
        if (this.field_11863 != null) {
            this.sync();
        }
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        Integer slotT = this.getSlot(resource);
        if (slotT == null) {
            slotT = this.isFull();
        }
        if (slotT == -1) {
            return 0L;
        }
        int slot = slotT;
        class_3545<ItemVariant, Long> stack = this.getStack(slot);
        transaction.addCloseCallback((a, z) -> {
            if (z.wasCommitted()) {
                if (((ItemVariant)stack.method_15442()).isBlank()) {
                    this.setStack(slot, (class_3545<ItemVariant, Long>)new class_3545((Object)resource, (Object)maxAmount));
                } else {
                    this.setStack(slot, (class_3545<ItemVariant, Long>)new class_3545((Object)((ItemVariant)stack.method_15442()), (Object)((Long)stack.method_15441() + maxAmount)));
                }
                this.sync();
            }
        });
        return maxAmount;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        Integer slot = this.getSlot(resource);
        if (slot == null) {
            return 0L;
        }
        if (maxAmount <= 0L) {
            return 0L;
        }
        class_3545<ItemVariant, Long> pair = this.slots[slot];
        ItemVariant copy = (ItemVariant)pair.method_15442();
        if (copy == ItemVariant.blank() || (Long)pair.method_15441() == 0L) {
            this.slots[slot.intValue()] = emptySlot;
        }
        long returned = (Long)pair.method_15441() <= maxAmount ? (Long)pair.method_15441() : maxAmount;
        this.method_5431();
        transaction.addCloseCallback((a, z) -> {
            if (z.wasCommitted()) {
                this.removeStack(slot, (int)maxAmount);
            }
        });
        return returned;
    }

    @NotNull
    public Iterator<StorageView<ItemVariant>> iterator() {
        return new LociIterator<StorageLociEntity>(this);
    }

    public int getSlotCount() {
        return 16;
    }

    public StorageLociSlot getSlot(int slot) {
        return new StorageLociSlot(this, slot);
    }

    public @UnmodifiableView List<SingleSlotStorage<ItemVariant>> getSlots() {
        return super.getSlots();
    }
}

