/*
 * Decompiled with CFR 0.152.
 */
package net.mokus.azara.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.mokus.azara.effect.ModEffects;
import net.mokus.azara.item.DamageTrackingWeapon;
import net.mokus.azara.item.Registry.ModItems;
import org.jetbrains.annotations.Nullable;

public class LongSword
extends class_1829
implements DamageTrackingWeapon {
    private static final UUID REACH_MODIFIER_ID = UUID.fromString("d21cf99e-47f4-11ec-81d3-0242ac130003");
    private static final UUID ATTACK_RANGE_MODIFIER_ID = UUID.fromString("d21cfa62-47f4-11ec-81d3-0242ac130003");
    private static final String DAMAGE_KEY = "DamageDealt";
    public static final int DAMAGE_THRESHOLD = 40;

    public LongSword(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        Multimap baseModifiers = super.method_7844(slot);
        if (slot == class_1304.field_6173) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(baseModifiers);
            builder.put((Object)ReachEntityAttributes.REACH, (Object)new class_1322(REACH_MODIFIER_ID, "Reach modifier", 1.5, class_1322.class_1323.field_6328));
            builder.put((Object)ReachEntityAttributes.ATTACK_RANGE, (Object)new class_1322(ATTACK_RANGE_MODIFIER_ID, "Attack range modifier", 0.75, class_1322.class_1323.field_6328));
            return builder.build();
        }
        return baseModifiers;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        int damageDealt;
        class_1799 stack = user.method_5998(hand);
        if (!world.field_9236 && (damageDealt = this.getDamageDealt(stack)) >= 20) {
            if (damageDealt >= 40) {
                this.setDamageDealt(stack, 20);
                if (stack.method_7909() == ModItems.GREATER_RAGE_SWORD) {
                    user.method_6092(new class_1293(ModEffects.RAGEEFFECT, 100, 1));
                } else if (stack.method_7909() == ModItems.GREATER_BLOOM_SWORD) {
                    user.method_6092(new class_1293(ModEffects.BLOOMEFFECT, 100, 1));
                }
            } else {
                this.setDamageDealt(stack, damageDealt - 20);
                if (stack.method_7909() == ModItems.GREATER_RAGE_SWORD) {
                    user.method_6092(new class_1293(ModEffects.RAGEEFFECT, 100, 0));
                } else if (stack.method_7909() == ModItems.GREATER_BLOOM_SWORD) {
                    user.method_6092(new class_1293(ModEffects.BLOOMEFFECT, 100, 0));
                }
            }
        }
        return class_1271.method_22427((Object)stack);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        return true;
    }

    private int getDamageDealt(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        return nbt.method_10550(DAMAGE_KEY);
    }

    private void setDamageDealt(class_1799 stack, int amount) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10569(DAMAGE_KEY, amount);
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        int damage = this.getDamageDealt(stack);
        float progress = Math.min(1.0f, (float)damage / 40.0f);
        return Math.round(progress * 13.0f);
    }

    public int method_31571(class_1799 stack) {
        int damage = this.getDamageDealt(stack);
        if (damage >= 40) {
            return 12534015;
        }
        if (damage >= 20) {
            return 49151;
        }
        return 0x808080;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.azara.dtw.desc"));
        if (stack.method_7909() == ModItems.GREATER_RAGE_SWORD) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.azara.greater_rage_sword.desc"));
        } else if (stack.method_7909() == ModItems.GREATER_BLOOM_SWORD) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.azara.greater_bloom_sword.desc"));
        }
        super.method_7851(stack, world, tooltip, context);
    }
}

