/*
 * Decompiled with CFR 0.152.
 */
package net.mokus.azara.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.mokus.azara.effect.ModEffects;
import net.mokus.azara.item.DamageTrackingWeapon;
import net.mokus.azara.item.Registry.ModItems;
import org.jetbrains.annotations.Nullable;

public class LongSword
extends class_1829
implements DamageTrackingWeapon {
    private static final UUID REACH_MODIFIER_ID = UUID.fromString("d21cf99e-47f4-11ec-81d3-0242ac130003");
    private static final UUID ATTACK_RANGE_MODIFIER_ID = UUID.fromString("d21cfa62-47f4-11ec-81d3-0242ac130003");
    private static final String DAMAGE_KEY = "DamageDealt";
    public static final int DAMAGE_THRESHOLD = 60;

    public LongSword(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        Multimap baseModifiers = super.method_7844(slot);
        if (slot == class_1304.field_6173) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(baseModifiers);
            builder.put((Object)ReachEntityAttributes.REACH, (Object)new class_1322(REACH_MODIFIER_ID, "Reach modifier", 1.5, class_1322.class_1323.field_6328));
            builder.put((Object)ReachEntityAttributes.ATTACK_RANGE, (Object)new class_1322(ATTACK_RANGE_MODIFIER_ID, "Attack range modifier", 0.75, class_1322.class_1323.field_6328));
            return builder.build();
        }
        return baseModifiers;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!world.field_9236) {
            class_239 hitResult = user.method_5745(5.0, 0.0f, false);
            if (hitResult.method_17783() == class_239.class_240.field_1332) {
                return class_1271.method_22430((Object)stack);
            }
            int damageDealt = this.getDamageDealt(stack);
            if (damageDealt >= 30) {
                if (damageDealt >= 60) {
                    this.setDamageDealt(stack, 30);
                    if (stack.method_7909() == ModItems.GREATER_RAGE_SWORD) {
                        user.method_6092(new class_1293(ModEffects.RAGEEFFECT, 100, 0));
                    } else if (stack.method_7909() == ModItems.GREATER_BLOOM_SWORD) {
                        user.method_6092(new class_1293(ModEffects.BLOOMEFFECT, 100, 1));
                    }
                    return class_1271.method_22427((Object)stack);
                }
                this.setDamageDealt(stack, damageDealt - 30);
                if (stack.method_7909() == ModItems.GREATER_RAGE_SWORD) {
                    user.method_6092(new class_1293(ModEffects.RAGEEFFECT, 100, 0));
                } else if (stack.method_7909() == ModItems.GREATER_BLOOM_SWORD) {
                    user.method_6092(new class_1293(ModEffects.BLOOMEFFECT, 100, 0));
                }
                return class_1271.method_22427((Object)stack);
            }
        }
        return class_1271.method_22430((Object)stack);
    }

    public class_1269 method_7884(class_1838 context) {
        class_2680 state;
        class_1657 user = context.method_8036();
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1799 stack = context.method_8041();
        if (!world.field_9236 && user != null && user.method_5715() && (state = world.method_8320(pos)).method_26204() == class_2246.field_16329) {
            int currentStage = stack.method_7948().method_10550("CustomModelData");
            int nextStage = (currentStage + 1) % 5;
            stack.method_7948().method_10569("CustomModelData", nextStage);
            user.method_6122(context.method_20287(), stack.method_7972());
            user.method_7353((class_2561)class_2561.method_43470((String)"Sword style has changed!").method_27692(class_124.field_1080), true);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        return true;
    }

    private int getDamageDealt(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        return nbt.method_10550(DAMAGE_KEY);
    }

    private void setDamageDealt(class_1799 stack, int amount) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10569(DAMAGE_KEY, amount);
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        int damage = this.getDamageDealt(stack);
        float progress = Math.min(1.0f, (float)damage / 60.0f);
        return Math.round(progress * 13.0f);
    }

    public int method_31571(class_1799 stack) {
        int damage = this.getDamageDealt(stack);
        if (damage >= 60) {
            return 12534015;
        }
        if (damage >= 30) {
            return 49151;
        }
        return 0x808080;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        int modelStage;
        tooltip.add((class_2561)class_2561.method_43471((String)"item.azara.dtw.desc"));
        if (stack.method_7909() == ModItems.GREATER_RAGE_SWORD) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.azara.greater_rage_sword.desc"));
        } else if (stack.method_7909() == ModItems.GREATER_BLOOM_SWORD) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.azara.greater_bloom_sword.desc"));
        }
        if (stack.method_7985() && (modelStage = stack.method_7969().method_10550("CustomModelData")) > 0) {
            String appearanceName = switch (modelStage) {
                case 1 -> "Folly Tree Branch";
                case 2 -> "Arasaka";
                case 3 -> "Count Dooku";
                case 4 -> "Think Fast Chucklenuts";
                default -> "Unknown";
            };
            tooltip.add((class_2561)class_2561.method_43470((String)("Style: " + appearanceName)).method_27692(class_124.field_1076));
        }
        super.method_7851(stack, world, tooltip, context);
    }
}

