/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.api.impl.btwaila.tooltip;

import java.util.ArrayList;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import sunsetsatellite.catalyst.core.util.NumberUtil;
import sunsetsatellite.catalyst.fluids.api.IFluidInventory;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.SIFluids;
import toufoumaster.btwaila.gui.components.AdvancedInfoComponent;
import toufoumaster.btwaila.tooltips.TileTooltip;
import toufoumaster.btwaila.util.ProgressBarOptions;
import toufoumaster.btwaila.util.TextureOptions;

public abstract class SIBaseTooltip<T>
extends TileTooltip<T> {
    public void drawFluids(IFluidInventory inv, AdvancedInfoComponent c, boolean collapse) {
        if (inv.getFluidInventorySize() <= 2) {
            for (int id = 0; id < inv.getFluidInventorySize(); ++id) {
                if (inv.getFluidCapacityForSlot(id) <= 0) continue;
                FluidStack stack = inv.getFluidInSlot(id);
                if (stack != null && stack.fluid != null) {
                    BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch((Object)((Block)stack.fluid.blocks.get(0)));
                    ProgressBarOptions options = new ProgressBarOptions(152, stack.fluid.getName().replace("Flowing ", "").replace("Still ", "").replace("Signaling Energy", "sE") + ": " + NumberUtil.format((double)stack.amount) + "/" + NumberUtil.format((double)inv.getFluidCapacityForSlot(id)) + " ", false, true, new TextureOptions(0, TextureRegistry.getTexture((String)"signalindustries:block/reality_fabric")), new TextureOptions(0xFFFFFF, model.getBlockTextureFromSideAndMetadata(Side.TOP, 0)));
                    c.drawProgressBarTextureWithText(stack.amount, inv.getFluidCapacityForSlot(id), options, 0);
                    continue;
                }
                ProgressBarOptions options = new ProgressBarOptions(152, "Empty: 0/" + NumberUtil.format((double)inv.getFluidCapacityForSlot(id)) + " ", false, true, new TextureOptions(0, TextureRegistry.getTexture((String)"signalindustries:block/reality_fabric")), new TextureOptions(0, TextureRegistry.getTexture((String)"signalindustries:block/reality_fabric")));
                c.drawProgressBarTextureWithText(0, inv.getFluidCapacityForSlot(id), options, 0);
            }
        } else {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int id = 0; id < inv.getFluidInventorySize(); ++id) {
                if (inv.getFluidCapacityForSlot(id) <= 0) continue;
                FluidStack stack = inv.getFluidInSlot(id);
                if (stack != null && stack.fluid != null && stack.fluid != SIFluids.ENERGY && collapse) {
                    stacks.add(new ItemStack((Block)stack.fluid.blocks.get(0), stack.amount));
                    continue;
                }
                if (stack != null && stack.fluid != null && stack.fluid == SIFluids.ENERGY) {
                    BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch((Object)((Block)stack.fluid.blocks.get(0)));
                    ProgressBarOptions options = new ProgressBarOptions(152, stack.fluid.getName().replace("Flowing ", "").replace("Still ", "").replace("Signaling Energy", "sE") + ": " + NumberUtil.format((double)stack.amount) + "/" + NumberUtil.format((double)inv.getFluidCapacityForSlot(id)) + " ", false, true, new TextureOptions(0, TextureRegistry.getTexture((String)"signalindustries:block/reality_fabric")), new TextureOptions(0xFFFFFF, model.getBlockTextureFromSideAndMetadata(Side.TOP, 0)));
                    c.drawProgressBarTextureWithText(stack.amount, inv.getFluidCapacityForSlot(id), options, 0);
                    continue;
                }
                if (collapse) continue;
                ProgressBarOptions options = new ProgressBarOptions(152, "Empty: 0/" + NumberUtil.format((double)inv.getFluidCapacityForSlot(id)) + " ", false, true, new TextureOptions(0, TextureRegistry.getTexture((String)"signalindustries:block/reality_fabric")), new TextureOptions(0, TextureRegistry.getTexture((String)"signalindustries:block/reality_fabric")));
                c.drawProgressBarTextureWithText(0, inv.getFluidCapacityForSlot(id), options, 0);
            }
            c.drawItemList(stacks.toArray(new ItemStack[0]), 0);
            c.addOffY(8);
        }
    }
}

