/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.api.impl.tmb.category;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.net.command.TextFormatting;
import org.jetbrains.annotations.Nullable;
import sunsetsatellite.catalyst.fluids.api.impl.tmb.ExtendedTypedIngredient;
import sunsetsatellite.catalyst.fluids.api.impl.tmb.TMBFluidPlugin;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.fluids.util.RecipeExtendedSymbol;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.api.impl.tmb.translator.FluidMachineRecipeTranslator;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntryMachineFluid;
import sunsetsatellite.signalindustries.util.RecipeProperties;
import turing.tmb.RecipeLayoutBuilder;
import turing.tmb.api.ItemStackIngredientRenderer;
import turing.tmb.api.VanillaTypes;
import turing.tmb.api.drawable.IDrawable;
import turing.tmb.api.drawable.IDrawableAnimated;
import turing.tmb.api.drawable.IDrawableStatic;
import turing.tmb.api.drawable.IIngredientList;
import turing.tmb.api.ingredient.IIngredientRenderer;
import turing.tmb.api.ingredient.IIngredientType;
import turing.tmb.api.ingredient.ITypedIngredient;
import turing.tmb.api.recipe.ILookupContext;
import turing.tmb.api.recipe.IRecipeCategory;
import turing.tmb.api.recipe.IRecipeLayout;
import turing.tmb.api.recipe.IRecipeSlot;
import turing.tmb.api.recipe.IRecipeTranslator;
import turing.tmb.api.recipe.RecipeIngredientRole;
import turing.tmb.api.runtime.ITMBRuntime;
import turing.tmb.client.DrawableAnimated;
import turing.tmb.client.DrawableBlank;
import turing.tmb.client.DrawableIngredient;
import turing.tmb.client.DrawableTexture;
import turing.tmb.util.IngredientList;

public class CollectorRecipeCategory
implements IRecipeCategory<FluidMachineRecipeTranslator> {
    private final IDrawable background = new DrawableBlank(120, 60);
    private final IDrawable icon = new DrawableIngredient((Object)SIBlocks.basicCollector.getDefaultStack(), (IIngredientRenderer)ItemStackIngredientRenderer.INSTANCE);
    private final IDrawable arrow = new DrawableAnimated((IDrawableStatic)new DrawableTexture("/assets/tmb/textures/gui/gui_vanilla.png", 82, 128, 24, 16, 0, 0, 0, 0, 24, 16), 1, IDrawableAnimated.StartDirection.LEFT, false);
    private final IDrawable arrowBack = new DrawableTexture("/assets/tmb/textures/gui/gui_vanilla.png", 24, 133, 24, 16, 0, 0, 0, 0, 24, 16);
    private final int x = 44;

    public String getName() {
        return "Collector";
    }

    public String getNamespace() {
        return "signalindustries";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void drawRecipe(ITMBRuntime runtime, FluidMachineRecipeTranslator recipe, IRecipeLayout layout, List<IIngredientList> ingredients, ILookupContext context) {
        RecipeProperties data = (RecipeProperties)((RecipeEntryMachineFluid)((Object)recipe.getOriginal())).getData();
        this.getIngredients(recipe, layout, context, ingredients);
        if (data.thisTierOnly) {
            runtime.getGuiHelper().getMinecraft().font.drawStringWithShadow("Only at: " + data.tier.getTextColor() + data.tier.getRank() + TextFormatting.WHITE, 24, this.background.getHeight() - 10, -986896);
        } else {
            runtime.getGuiHelper().getMinecraft().font.drawStringWithShadow("Minimum tier: " + data.tier.getTextColor() + data.tier.getRank() + TextFormatting.WHITE, 24, this.background.getHeight() - 10, -986896);
        }
        this.arrowBack.draw(runtime.getGuiHelper(), 70, this.background.getHeight() / 2 - 5);
        this.arrow.draw(runtime.getGuiHelper(), 70, this.background.getHeight() / 2 - 5);
        runtime.getGuiHelper().getMinecraft().font.drawCenteredString(data.ticks + "t", 83, this.background.getHeight() / 2 - 14, -1);
    }

    public void getIngredients(FluidMachineRecipeTranslator recipe, IRecipeLayout layout, ILookupContext context, List<IIngredientList> ingredients) {
        RecipeProperties data = (RecipeProperties)((RecipeEntryMachineFluid)((Object)recipe.getOriginal())).getData();
        ingredients.add(0, (IIngredientList)IngredientList.fromRecipeSymbol((RecipeSymbol)((RecipeExtendedSymbol[])((RecipeEntryMachineFluid)((Object)recipe.getOriginal())).getInput())[0].asNormalSymbol()));
        ingredients.add(1, (IIngredientList)new IngredientList(new ITypedIngredient[]{ExtendedTypedIngredient.fluidStackIngredient((FluidStack)((FluidStack)((RecipeEntryMachineFluid)((Object)recipe.getOriginal())).getOutput()))}));
    }

    public IRecipeLayout getRecipeLayout() {
        return new RecipeLayoutBuilder().addInputSlot(0, (IIngredientType)VanillaTypes.ITEM_STACK).setPosition(44, this.background.getHeight() / 2 - 6).build().addOutputSlot(1, (IIngredientType)TMBFluidPlugin.FLUID_STACK).setPosition(100, this.background.getHeight() / 2 - 6).build().build();
    }

    public <I, T extends IIngredientType<I>> List<String> getTooltips(FluidMachineRecipeTranslator recipe, IRecipeSlot<I, T> slot, int mouseX, int mouseY) {
        if (slot.getRole() == RecipeIngredientRole.INPUT) {
            return Collections.singletonList(TextFormatting.ORANGE + "Not consumed!");
        }
        return super.getTooltips((IRecipeTranslator)recipe, slot, mouseX, mouseY);
    }
}

