/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.api.impl.tmb.translator;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.catalyst.fluids.api.impl.tmb.TMBFluidPlugin;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.fluids.util.RecipeExtendedSymbol;
import sunsetsatellite.catalyst.fluids.util.RecipeOutputStack;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntryMachineMultiOutput;
import turing.tmb.RecipeTranslator;
import turing.tmb.api.VanillaTypes;
import turing.tmb.api.ingredient.IIngredientType;
import turing.tmb.api.ingredient.ITypedIngredient;

public class MultiMachineRecipeTranslator
extends RecipeTranslator<RecipeEntryMachineMultiOutput> {
    public MultiMachineRecipeTranslator(RecipeEntryMachineMultiOutput recipe) {
        super((Object)recipe);
    }

    public boolean isValidInput(ITypedIngredient<?> ingredient) {
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            return Arrays.stream((RecipeExtendedSymbol[])((RecipeEntryMachineMultiOutput)((Object)this.recipe)).getInput()).anyMatch(symbol -> symbol.matches((ItemStack)ingredient.getCastIngredient((IIngredientType)VanillaTypes.ITEM_STACK)));
        }
        if (ingredient.getType() == TMBFluidPlugin.FLUID_STACK) {
            return Arrays.stream((RecipeExtendedSymbol[])((RecipeEntryMachineMultiOutput)((Object)this.recipe)).getInput()).anyMatch(symbol -> symbol.matchesFluid((FluidStack)ingredient.getCastIngredient((IIngredientType)TMBFluidPlugin.FLUID_STACK)));
        }
        return false;
    }

    public boolean isOutput(ITypedIngredient<?> ingredient) {
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            return Arrays.stream((RecipeOutputStack[])((RecipeEntryMachineMultiOutput)((Object)this.recipe)).getOutput()).filter(RecipeOutputStack::isItem).map(S -> S.stack).anyMatch(S -> {
                if (ingredient.getCastIngredient((IIngredientType)VanillaTypes.ITEM_STACK) == null) {
                    return false;
                }
                return S.isItemEqual(Objects.requireNonNull((ItemStack)ingredient.getCastIngredient((IIngredientType)VanillaTypes.ITEM_STACK)));
            });
        }
        if (ingredient.getType() == TMBFluidPlugin.FLUID_STACK) {
            return Arrays.stream((RecipeOutputStack[])((RecipeEntryMachineMultiOutput)((Object)this.recipe)).getOutput()).filter(RecipeOutputStack::isFluid).map(S -> S.fluid).anyMatch(S -> {
                if (ingredient.getCastIngredient((IIngredientType)TMBFluidPlugin.FLUID_STACK) == null) {
                    return false;
                }
                return S.isFluidEqual(Objects.requireNonNull((FluidStack)ingredient.getCastIngredient((IIngredientType)TMBFluidPlugin.FLUID_STACK)));
            });
        }
        return false;
    }
}

