/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.api.impl.vintagequesting;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.collection.Pair;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.SIDimensions;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.api.impl.vintagequesting.BasicQuestChapter;
import sunsetsatellite.signalindustries.api.impl.vintagequesting.PrototypeQuestChapter;
import sunsetsatellite.signalindustries.api.impl.vintagequesting.ReinforcedQuestChapter;
import sunsetsatellite.vintagequesting.VintageQuesting;
import sunsetsatellite.vintagequesting.gui.QuestChapterPage;
import sunsetsatellite.vintagequesting.quest.template.QuestTemplate;
import sunsetsatellite.vintagequesting.quest.template.TaskTemplate;
import sunsetsatellite.vintagequesting.quest.template.reward.ItemRewardTemplate;
import sunsetsatellite.vintagequesting.quest.template.task.ClickTaskTemplate;
import sunsetsatellite.vintagequesting.quest.template.task.RetrievalTaskTemplate;
import sunsetsatellite.vintagequesting.quest.template.task.VisitDimensionTaskTemplate;
import sunsetsatellite.vintagequesting.util.Logic;

public class VintageQuestingSIPlugin {
    public static final QuestChapterPage PROTOTYPE_CHAPTER = new PrototypeQuestChapter();
    public static final QuestChapterPage BASIC_CHAPTER = new BasicQuestChapter();
    public static final QuestChapterPage REINFORCED_CHAPTER = new ReinforcedQuestChapter();

    public void initializePlugin() {
        List<QuestTemplate> prototypeQuests = VintageQuestingSIPlugin.addPrototypeQuests();
        List<QuestTemplate> basicQuests = VintageQuestingSIPlugin.addBasicQuests();
        List<QuestTemplate> reinforcedQuests = VintageQuestingSIPlugin.addReinforcedQuests();
        List<QuestTemplate> awakenedQuests = VintageQuestingSIPlugin.addAwakenedQuests();
        for (QuestTemplate quest : prototypeQuests) {
            PROTOTYPE_CHAPTER.addQuest(quest);
        }
        for (QuestTemplate quest : PROTOTYPE_CHAPTER.getQuests()) {
            quest.setupPrerequisites();
        }
        for (QuestTemplate quest : basicQuests) {
            BASIC_CHAPTER.addQuest(quest);
        }
        for (QuestTemplate quest : BASIC_CHAPTER.getQuests()) {
            quest.setupPrerequisites();
        }
        for (QuestTemplate quest : reinforcedQuests) {
            REINFORCED_CHAPTER.addQuest(quest);
        }
        for (QuestTemplate quest : REINFORCED_CHAPTER.getQuests()) {
            quest.setupPrerequisites();
        }
        VintageQuesting.LOGGER.info("Loaded quests from: signalindustries!");
    }

    public static List<QuestTemplate> addPrototypeQuests() {
        QuestTemplate welcome = new QuestTemplate("signalindustries:welcome", "quest.signalindustries.welcome", (IItemConvertible)SIItems.rawSignalumCrystal, Logic.AND, Logic.AND).setTasks(Catalyst.listOf((Object[])new TaskTemplate[]{new ClickTaskTemplate("signalindustries:welcome/click")}));
        QuestTemplate genesis = VintageQuestingSIPlugin.simpleQuest("genesis", SIBlocks.signalumOre, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.rawSignalumCrystal, 32)})), Catalyst.listOf((Object[])new QuestTemplate[]{welcome}), welcome, 0, 1);
        QuestTemplate hammer = VintageQuestingSIPlugin.simpleQuest("hammer", (IItemConvertible)SIItems.ironPlateHammer, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.ironPlateHammer, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{welcome}), genesis, 0, 1);
        QuestTemplate cobblePlates = VintageQuestingSIPlugin.simpleQuest("cobblePlates", (IItemConvertible)SIItems.cobblestonePlate, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.cobblestonePlate, 4)})), Catalyst.listOf((Object[])new QuestTemplate[]{hammer}), hammer, -1, 1);
        QuestTemplate stonePlates = VintageQuestingSIPlugin.simpleQuest("stonePlates", (IItemConvertible)SIItems.stonePlate, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.stonePlate, 4)})), Catalyst.listOf((Object[])new QuestTemplate[]{hammer}), hammer, 1, 1);
        QuestTemplate tablet = VintageQuestingSIPlugin.simpleQuest("tablet", (IItemConvertible)SIItems.configurationTablet, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.configurationTablet, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{stonePlates, genesis}), stonePlates, 1, 0);
        QuestTemplate ioConfig = VintageQuestingSIPlugin.simpleClickQuest("ioConfig", (IItemConvertible)SIItems.itemManipulationCircuit, Catalyst.listOf((Object[])new QuestTemplate[]{tablet}), tablet, 1, 0);
        QuestTemplate prototypeCore = VintageQuestingSIPlugin.simpleQuest("prototypeCore", SIBlocks.prototypeMachineCore, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.prototypeMachineCore, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{genesis, cobblePlates, stonePlates}), hammer, 0, 2);
        QuestTemplate protoExtract = VintageQuestingSIPlugin.simpleQuest("prototypeExtractor", SIBlocks.prototypeExtractor, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.prototypeExtractor, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{prototypeCore}), prototypeCore, 0, 1);
        QuestTemplate energy = VintageQuestingSIPlugin.simpleClickQuest("energy", SIBlocks.energyFlowing, Catalyst.listOf((Object[])new QuestTemplate[]{protoExtract}), protoExtract, 0, 1);
        QuestTemplate protoPlate = VintageQuestingSIPlugin.simpleQuest("prototypePlateFormer", SIBlocks.prototypePlateFormer, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.prototypePlateFormer, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{prototypeCore}), prototypeCore, 1, 1);
        QuestTemplate protoSmelter = VintageQuestingSIPlugin.simpleQuest("prototypeAlloySmelter", SIBlocks.prototypeAlloySmelter, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.prototypeAlloySmelter, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{prototypeCore}), prototypeCore, -1, 1);
        QuestTemplate protoCrusher = VintageQuestingSIPlugin.simpleQuest("prototypeCrusher", SIBlocks.prototypeCrusher, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.prototypeCrusher, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{prototypeCore}), prototypeCore, 2, 1);
        QuestTemplate diamondGear = VintageQuestingSIPlugin.simpleQuest("diamondGear", (IItemConvertible)SIItems.diamondCuttingGear, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.diamondCuttingGear, 1)})), Catalyst.listOf((Object[])new QuestTemplate[0]), prototypeCore, -3, 1);
        QuestTemplate protoCutter = VintageQuestingSIPlugin.simpleQuest("prototypeCrystalCutter", SIBlocks.prototypeCrystalCutter, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.prototypeCrystalCutter, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{prototypeCore, diamondGear}), prototypeCore, -2, 1);
        QuestTemplate energyConduit = VintageQuestingSIPlugin.simpleQuest("energyConduit", SIBlocks.prototypeConduit, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.prototypeConduit, 4)})), Catalyst.listOf((Object[])new QuestTemplate[]{prototypeCore}), prototypeCore, 4, 1);
        QuestTemplate fluidConduit = VintageQuestingSIPlugin.simpleQuest("fluidConduit", SIBlocks.prototypeFluidConduit, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.prototypeFluidConduit, 4)})), Catalyst.listOf((Object[])new QuestTemplate[]{prototypeCore}), prototypeCore, 5, 1);
        QuestTemplate itemConduit = VintageQuestingSIPlugin.simpleQuest("itemConduit", SIBlocks.prototypeItemConduit, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.prototypeItemConduit, 4)})), Catalyst.listOf((Object[])new QuestTemplate[]{prototypeCore}), prototypeCore, 6, 1);
        QuestTemplate energyCell = VintageQuestingSIPlugin.simpleQuest("energyCell", SIBlocks.prototypeEnergyCell, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.prototypeEnergyCell, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{energyConduit}), energyConduit, 0, 1);
        QuestTemplate fluidTank = VintageQuestingSIPlugin.simpleQuest("fluidTank", SIBlocks.prototypeFluidTank, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.prototypeFluidTank, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{fluidConduit}), fluidConduit, 0, 1);
        QuestTemplate pump = VintageQuestingSIPlugin.simpleQuest("pump", SIBlocks.prototypePump, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.prototypePump, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{fluidConduit}), fluidConduit, 0, 2);
        QuestTemplate inserter = VintageQuestingSIPlugin.simpleQuest("inserter", SIBlocks.prototypeInserter, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.prototypeInserter, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{itemConduit}), itemConduit, 0, 1);
        QuestTemplate storageContainer = VintageQuestingSIPlugin.simpleQuest("storageContainer", SIBlocks.prototypeStorageContainer, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.prototypeStorageContainer, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{prototypeCore}), itemConduit, 1, 1);
        QuestTemplate crystal = VintageQuestingSIPlugin.simpleQuest("crystal", (IItemConvertible)SIItems.signalumCrystal, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.signalumCrystal, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{protoCutter}), energy, -1, 1);
        QuestTemplate crystalBattery = VintageQuestingSIPlugin.simpleQuest("crystalBattery", (IItemConvertible)SIItems.signalumCrystalBattery, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.signalumCrystalBattery, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{crystal}), crystal, 1, 1);
        return Catalyst.listOf((Object[])new QuestTemplate[]{welcome, genesis, hammer, cobblePlates, stonePlates, tablet, ioConfig, prototypeCore, protoPlate, diamondGear, protoCutter, protoCrusher, protoExtract, protoSmelter, energy, energyConduit, fluidConduit, itemConduit, energyCell, fluidTank, pump, inserter, storageContainer, crystal, crystalBattery});
    }

    public static List<QuestTemplate> addBasicQuests() {
        QuestTemplate emptyCrystal = new QuestTemplate("signalindustries:emptyCrystal", "quest.signalindustries.emptyCrystal", (IItemConvertible)SIItems.signalumCrystalEmpty, Logic.AND, Logic.AND).setTasks(Catalyst.listOf((Object[])new TaskTemplate[]{new RetrievalTaskTemplate("signalindustries:emptyCrystal/retrieval", SIItems.signalumCrystalEmpty.getDefaultStack())})).setPreRequisites(Catalyst.listOf((Object[])new QuestTemplate[]{VintageQuestingSIPlugin.getQuest("prototypeCrystalCutter")}));
        QuestTemplate steel = new QuestTemplate("signalindustries:steel", "quest.signalindustries.steel", (IItemConvertible)Items.INGOT_STEEL, Logic.AND, Logic.AND).setTasks(Catalyst.listOf((Object[])new TaskTemplate[]{new RetrievalTaskTemplate("signalindustries:steel/retrieval", Items.INGOT_STEEL.getDefaultStack())})).setX(1);
        QuestTemplate crystalDust = VintageQuestingSIPlugin.simpleQuest("crystalDust", (IItemConvertible)SIItems.emptySignalumCrystalDust, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.emptySignalumCrystalDust, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{emptyCrystal}), emptyCrystal, 0, 1);
        QuestTemplate crystalAlloy = VintageQuestingSIPlugin.simpleQuest("crystalAlloy", (IItemConvertible)SIItems.crystalAlloyIngot, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.crystalAlloyIngot, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{crystalDust, steel}), crystalDust, 0, 1);
        QuestTemplate crystalAlloyPlates = VintageQuestingSIPlugin.simpleQuest("crystalAlloyPlates", (IItemConvertible)SIItems.crystalAlloyPlate, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.crystalAlloyPlate, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{crystalAlloy}), crystalAlloy, 0, 1);
        QuestTemplate meteorCompass = VintageQuestingSIPlugin.simpleQuest("meteorCompass", (IItemConvertible)SIItems.meteorTracker, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.meteorTracker, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{crystalAlloy, VintageQuestingSIPlugin.getQuest("crystal")}), crystalAlloy, -1, 0);
        QuestTemplate steelPlates = VintageQuestingSIPlugin.simpleQuest("steelPlates", (IItemConvertible)SIItems.steelPlate, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.steelPlate, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{steel}), crystalAlloyPlates, 1, 0);
        QuestTemplate basicCore = VintageQuestingSIPlugin.simpleQuest("basicCore", SIBlocks.basicMachineCore, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicMachineCore, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{crystalAlloyPlates, steelPlates, VintageQuestingSIPlugin.getQuest("crystal")}), crystalAlloyPlates, -1, 1);
        QuestTemplate basicExtractor = VintageQuestingSIPlugin.simpleQuest("basicExtractor", SIBlocks.basicExtractor, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicExtractor, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore}), basicCore, 1, 1);
        QuestTemplate basicCrusher = VintageQuestingSIPlugin.simpleQuest("basicCrusher", SIBlocks.basicCrusher, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicCrusher, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore}), basicCore, 1, 2);
        QuestTemplate netherCoalDust = VintageQuestingSIPlugin.simpleQuest("netherCoalDust", (IItemConvertible)SIItems.netherCoalDust, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.netherCoalDust, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCrusher}), basicCrusher, 0, 1);
        QuestTemplate cheaperSteel = VintageQuestingSIPlugin.simpleQuest("cheaperSteel", (IItemConvertible)SIItems.tinyNetherCoalDust, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.tinyNetherCoalDust, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCrusher, netherCoalDust}), netherCoalDust, 0, 1);
        QuestTemplate basicSmelter = VintageQuestingSIPlugin.simpleQuest("basicSmelter", SIBlocks.basicAlloySmelter, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicAlloySmelter, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore}), basicCrusher, -1, 0);
        QuestTemplate basicCutter = VintageQuestingSIPlugin.simpleQuest("basicCutter", SIBlocks.basicCrystalCutter, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicCrystalCutter, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore}), basicCrusher, 1, 0);
        QuestTemplate basicInfuser = VintageQuestingSIPlugin.simpleQuest("basicInfuser", SIBlocks.basicInfuser, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicInfuser, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore}), basicCutter, 1, 0);
        QuestTemplate basicPress = VintageQuestingSIPlugin.simpleQuest("basicPress", SIBlocks.basicPlateFormer, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicPlateFormer, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore}), basicInfuser, 1, 0);
        QuestTemplate saturatedAlloy = VintageQuestingSIPlugin.simpleQuest("saturatedAlloy", (IItemConvertible)SIItems.saturatedSignalumAlloyIngot, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.saturatedSignalumAlloyIngot, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicInfuser}), basicInfuser, 0, 1);
        QuestTemplate saturatedAlloyPlate = VintageQuestingSIPlugin.simpleQuest("saturatedAlloyPlate", (IItemConvertible)SIItems.saturatedSignalumAlloyPlate, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.saturatedSignalumAlloyPlate, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{saturatedAlloy, basicPress}), basicPress, 0, 1);
        QuestTemplate signalumAlloyMesh = VintageQuestingSIPlugin.simpleQuest("signalumAlloyMesh", (IItemConvertible)SIItems.signalumAlloyMesh, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.signalumAlloyMesh, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{saturatedAlloyPlate, basicCutter}), saturatedAlloyPlate, 0, 1);
        QuestTemplate basicCollector = VintageQuestingSIPlugin.simpleQuest("basicCollector", SIBlocks.basicCollector, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicCollector, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore, signalumAlloyMesh}), signalumAlloyMesh, 0, 1);
        QuestTemplate basicChamber = VintageQuestingSIPlugin.simpleQuest("basicChamber", SIBlocks.basicCrystalChamber, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicCrystalChamber, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore}), basicSmelter, -1, 0);
        QuestTemplate basicChip = VintageQuestingSIPlugin.simpleQuest("basicChip", (IItemConvertible)SIItems.crystalChip, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.crystalChip, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCutter}), basicCutter, 0, 1);
        QuestTemplate basicEnergyCore = VintageQuestingSIPlugin.simpleQuest("basicEnergyCore", (IItemConvertible)SIItems.basicEnergyCore, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.basicEnergyCore, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicChip, crystalAlloyPlates}), basicChip, -1, 1);
        QuestTemplate basicAutoMiner = VintageQuestingSIPlugin.simpleQuest("basicAutoMiner", SIBlocks.basicAutomaticMiner, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicAutomaticMiner, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore, basicEnergyCore}), basicEnergyCore, 1, 2);
        QuestTemplate basicAssembler = VintageQuestingSIPlugin.simpleQuest("basicAssembler", SIBlocks.basicAssembler, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicAssembler, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore, basicEnergyCore}), basicAutoMiner, -1, 0);
        QuestTemplate basicInjector = VintageQuestingSIPlugin.simpleQuest("basicInjector", SIBlocks.basicEnergyInjector, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicEnergyInjector, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore, basicEnergyCore}), basicAssembler, -1, 0);
        QuestTemplate basicDynamo = VintageQuestingSIPlugin.simpleQuest("basicDynamo", SIBlocks.basicSignalumDynamo, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicSignalumDynamo, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore, basicEnergyCore}), basicAutoMiner, 1, 0);
        QuestTemplate basicCatalystConduit = VintageQuestingSIPlugin.simpleQuest("basicCatalystConduit", SIBlocks.basicCatalystConduit, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicCatalystConduit, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicDynamo}), basicDynamo, 0, 1);
        QuestTemplate precisionChip = VintageQuestingSIPlugin.simpleQuest("precisionChip", (IItemConvertible)SIItems.precisionControlChip, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.precisionControlChip, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicAutoMiner}), basicAutoMiner, 0, 1);
        QuestTemplate basicEnergyCell = VintageQuestingSIPlugin.simpleQuest("basicEnergyCell", SIBlocks.basicEnergyCell, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicEnergyCell, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore}), basicCore, -3, 1);
        QuestTemplate basicEnergyConduit = VintageQuestingSIPlugin.simpleQuest("basicEnergyConduit", SIBlocks.basicConduit, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicConduit, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicEnergyCell}), basicEnergyCell, -1, 0);
        QuestTemplate basicFluidTank = VintageQuestingSIPlugin.simpleQuest("basicFluidTank", SIBlocks.basicFluidTank, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicFluidTank, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore}), basicEnergyCell, 0, -1);
        QuestTemplate basicFluidConduit = VintageQuestingSIPlugin.simpleQuest("basicFluidConduit", SIBlocks.basicFluidConduit, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicFluidConduit, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicFluidTank}), basicFluidTank, -1, 0);
        QuestTemplate basicInserter = VintageQuestingSIPlugin.simpleQuest("basicInserter", SIBlocks.basicInserter, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicInserter, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore}), basicFluidTank, 0, -1);
        QuestTemplate basicItemConduit = VintageQuestingSIPlugin.simpleQuest("basicItemConduit", SIBlocks.basicItemConduit, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicItemConduit, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicInserter}), basicInserter, -1, 0);
        QuestTemplate basicRestrictItemConduit = VintageQuestingSIPlugin.simpleQuest("basicRestrictItemConduit", SIBlocks.basicRestrictItemConduit, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicRestrictItemConduit, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicInserter}), basicItemConduit, 0, -1);
        QuestTemplate basicSensorItemConduit = VintageQuestingSIPlugin.simpleQuest("basicSensorItemConduit", SIBlocks.basicSensorItemConduit, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicSensorItemConduit, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicInserter}), basicItemConduit, 0, -2);
        QuestTemplate basicContainer = VintageQuestingSIPlugin.simpleQuest("basicContainer", SIBlocks.basicStorageContainer, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicStorageContainer, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore}), basicItemConduit, -1, 0);
        QuestTemplate covers = VintageQuestingSIPlugin.simpleQuest("covers", (IItemConvertible)SIItems.blankCover, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack((Item)SIItems.blankCover, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{crystalAlloyPlates, steelPlates}), steelPlates, 2, 0);
        QuestTemplate conveyorCover = VintageQuestingSIPlugin.simpleQuest("conveyorCover", (IItemConvertible)SIItems.conveyorCover, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack((Item)SIItems.conveyorCover, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{covers}), covers, 1, 0);
        QuestTemplate pumpCover = VintageQuestingSIPlugin.simpleQuest("pumpCover", (IItemConvertible)SIItems.pumpCover, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack((Item)SIItems.pumpCover, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{covers}), covers, 1, 1);
        QuestTemplate voidCover = VintageQuestingSIPlugin.simpleQuest("voidCover", (IItemConvertible)SIItems.voidCover, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack((Item)SIItems.voidCover, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{covers}), covers, 1, -1);
        QuestTemplate redstoneCover = VintageQuestingSIPlugin.simpleQuest("redstoneCover", (IItemConvertible)SIItems.redstoneCover, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack((Item)SIItems.redstoneCover, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{covers}), covers, 1, -2);
        QuestTemplate switchCover = VintageQuestingSIPlugin.simpleQuest("switchCover", (IItemConvertible)SIItems.switchCover, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack((Item)SIItems.switchCover, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{covers}), covers, 1, 2);
        QuestTemplate glowingObsidian = VintageQuestingSIPlugin.simpleQuest("glowingObsidian", SIBlocks.glowingObsidian, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.glowingObsidian, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicInfuser}), cheaperSteel, -4, -1);
        QuestTemplate basicDrill = VintageQuestingSIPlugin.simpleQuest("basicDrill", (IItemConvertible)SIItems.basicSignalumDrill, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval", "retrieval2", "retrieval3"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.basicDrillCasing, 1), new ItemStack(SIItems.basicDrillBit, 1), new ItemStack(SIItems.basicSignalumDrill, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{steelPlates, crystalAlloyPlates, saturatedAlloyPlate}), saturatedAlloyPlate, 1, 0);
        QuestTemplate signaliteAlloyCoil = VintageQuestingSIPlugin.simpleQuest("signaliteAlloyCoil", SIBlocks.signalumAlloyCoil, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.signalumAlloyCoil, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{saturatedAlloyPlate, crystalAlloy}), saturatedAlloyPlate, 3, 2);
        QuestTemplate basicInductionSmelter = VintageQuestingSIPlugin.simpleQuest("basicInductionSmelter", SIBlocks.basicInductionSmelter, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval", "retrieval2", "retrieval3", "retrieval4", "retrieval5", "retrieval6"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicInductionSmelter, 1), new ItemStack(SIBlocks.basicCasing, 14), new ItemStack(SIBlocks.signalumAlloyCoil, 8), new ItemStack(SIBlocks.basicItemInputBus, 1), new ItemStack(SIBlocks.basicItemOutputBus, 1), new ItemStack(SIBlocks.basicEnergyConnector, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{signaliteAlloyCoil}), signaliteAlloyCoil, -1, 1);
        QuestTemplate basicEnergyConnector = VintageQuestingSIPlugin.simpleQuest("basicEnergyConnector", SIBlocks.basicEnergyConnector, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicEnergyConnector, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore, basicEnergyCore}), basicInductionSmelter, 1, 2);
        QuestTemplate basicItemInput = VintageQuestingSIPlugin.simpleQuest("basicItemInput", SIBlocks.basicItemInputBus, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicItemInputBus, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore}), basicInductionSmelter, 0, 1);
        QuestTemplate basicItemOutput = VintageQuestingSIPlugin.simpleQuest("basicItemOutput", SIBlocks.basicItemOutputBus, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicItemOutputBus, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore}), basicInductionSmelter, 2, 1);
        QuestTemplate basicCasing = VintageQuestingSIPlugin.simpleQuest("basicCasing", SIBlocks.basicCasing, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.basicCasing, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{crystalAlloyPlates}), basicEnergyConnector, 1, 0);
        QuestTemplate redstoneBooster = VintageQuestingSIPlugin.simpleQuest("redstoneBooster", SIBlocks.redstoneBooster, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.redstoneBooster, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{basicCore, basicEnergyCore}), basicEnergyCore, -2, 1);
        return Catalyst.listOf((Object[])new QuestTemplate[]{emptyCrystal, steel, crystalDust, crystalAlloy, crystalAlloyPlates, meteorCompass, steelPlates, basicCore, basicExtractor, basicCollector, basicCrusher, netherCoalDust, cheaperSteel, basicSmelter, basicInfuser, basicCutter, basicPress, saturatedAlloy, saturatedAlloyPlate, signalumAlloyMesh, basicChamber, basicAutoMiner, precisionChip, basicChip, basicEnergyCore, basicEnergyCell, basicFluidTank, basicInserter, basicItemConduit, basicRestrictItemConduit, basicSensorItemConduit, basicContainer, basicEnergyConduit, basicFluidConduit, basicAssembler, basicDynamo, basicCatalystConduit, basicInjector, covers, conveyorCover, pumpCover, redstoneCover, switchCover, voidCover, glowingObsidian, basicDrill, signaliteAlloyCoil, basicInductionSmelter, basicEnergyConnector, basicItemInput, basicItemOutput, basicCasing, redstoneBooster});
    }

    public static List<QuestTemplate> addReinforcedQuests() {
        QuestTemplate reinforcedAlloy = new QuestTemplate("signalindustries:reinforcedAlloy", "quest.signalindustries.reinforcedAlloy", (IItemConvertible)SIItems.reinforcedCrystalAlloyIngot, Logic.AND, Logic.AND).setTasks(Catalyst.listOf((Object[])new TaskTemplate[]{new RetrievalTaskTemplate("signalindustries:reinforcedAlloy/retrieval", SIItems.reinforcedCrystalAlloyIngot.getDefaultStack())})).setPreRequisites(Catalyst.listOf((Object[])new QuestTemplate[]{VintageQuestingSIPlugin.getQuest("basicSmelter"), VintageQuestingSIPlugin.getQuest("glowingObsidian")}));
        QuestTemplate reinforcedAlloyPlates = new QuestTemplate("signalindustries:reinforcedAlloyPlates", "quest.signalindustries.reinforcedAlloyPlates", (IItemConvertible)SIItems.reinforcedCrystalAlloyPlate, Logic.AND, Logic.AND).setTasks(Catalyst.listOf((Object[])new TaskTemplate[]{new RetrievalTaskTemplate("signalindustries:reinforcedAlloyPlates/retrieval", SIItems.reinforcedCrystalAlloyPlate.getDefaultStack())})).setPreRequisites(Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedAlloy, VintageQuestingSIPlugin.getQuest("basicPress")})).setY(reinforcedAlloy, 1);
        QuestTemplate signaliteGear = new QuestTemplate("signalindustries:signaliteGear", "quest.signalindustries.signaliteGear", (IItemConvertible)SIItems.signalumCuttingGear, Logic.AND, Logic.AND).setTasks(Catalyst.listOf((Object[])new TaskTemplate[]{new RetrievalTaskTemplate("signalindustries:signaliteGear/retrieval", SIItems.signalumCuttingGear.getDefaultStack())})).setPreRequisites(Catalyst.listOf((Object[])new QuestTemplate[]{VintageQuestingSIPlugin.getQuest("crystal")})).setY(reinforcedAlloyPlates, 2).setX(reinforcedAlloyPlates, -1);
        QuestTemplate reinforcedCore = new QuestTemplate("signalindustries:reinforcedCore", "quest.signalindustries.reinforcedCore", SIBlocks.reinforcedMachineCore, Logic.AND, Logic.AND).setTasks(Catalyst.listOf((Object[])new TaskTemplate[]{new RetrievalTaskTemplate("signalindustries:reinforcedCore/retrieval", SIBlocks.reinforcedMachineCore.getDefaultStack())})).setPreRequisites(Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedAlloyPlates, VintageQuestingSIPlugin.getQuest("saturatedAlloy"), VintageQuestingSIPlugin.getQuest("basicCore")})).setY(reinforcedAlloyPlates, 1).setX(reinforcedAlloyPlates, -1);
        QuestTemplate reinforcedCutter = VintageQuestingSIPlugin.simpleQuest("reinforcedCutter", SIBlocks.reinforcedCrystalCutter, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.reinforcedCrystalCutter, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedCore, signaliteGear}), reinforcedCore, 1, 2);
        QuestTemplate pureChip = VintageQuestingSIPlugin.simpleQuest("pureChip", (IItemConvertible)SIItems.pureCrystalChip, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.pureCrystalChip, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedCutter, VintageQuestingSIPlugin.getQuest("crystal")}), reinforcedCutter, 1, 0);
        QuestTemplate reinforcedEnergyCore = VintageQuestingSIPlugin.simpleQuest("reinforcedEnergyCore", (IItemConvertible)SIItems.reinforcedEnergyCore, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.reinforcedEnergyCore, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{pureChip}), pureChip, 1, -1);
        QuestTemplate reinforcedDrill = VintageQuestingSIPlugin.simpleQuest("reinforcedDrill", (IItemConvertible)SIItems.reinforcedSignalumDrill, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval", "retrieval2", "retrieval3"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.reinforcedSignalumDrill, 1), new ItemStack(SIItems.reinforcedDrillBit, 1), new ItemStack(SIItems.reinforcedDrillCasing, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedEnergyCore}), reinforcedEnergyCore, 1, -1);
        QuestTemplate dilithiumOre = VintageQuestingSIPlugin.simpleQuest("dilithiumOre", SIBlocks.dilithiumOre, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.dilithiumShard, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedDrill}), reinforcedDrill, 1, 0);
        QuestTemplate reinforcedTracker = VintageQuestingSIPlugin.simpleQuest("reinforcedTracker", (IItemConvertible)SIItems.reinforcedMeteorTracker, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.reinforcedMeteorTracker, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{dilithiumOre}), dilithiumOre, 0, -1);
        QuestTemplate dilithiumPlate = VintageQuestingSIPlugin.simpleQuest("dilithiumPlate", (IItemConvertible)SIItems.dilithiumPlate, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.dilithiumPlate, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{dilithiumOre}), dilithiumOre, 1, 0);
        QuestTemplate blueprint = VintageQuestingSIPlugin.simpleQuest("blueprint", (IItemConvertible)SIItems.blueprint, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.blueprint, 1)})), Catalyst.listOf((Object[])new QuestTemplate[0]), reinforcedEnergyCore, 0, 2);
        QuestTemplate builder = VintageQuestingSIPlugin.simpleQuest("builder", SIBlocks.reinforcedBuilder, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.reinforcedBuilder, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedEnergyCore, blueprint}), reinforcedEnergyCore, 1, 2);
        QuestTemplate dimensionalOre = VintageQuestingSIPlugin.simpleQuest("dimensionalOre", SIBlocks.dimensionalShardOre, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.dimensionalShard, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedDrill}), reinforcedDrill, 1, -2);
        QuestTemplate warpOrb = VintageQuestingSIPlugin.simpleQuest("warpOrb", (IItemConvertible)SIItems.warpOrb, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.warpOrb, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{dimensionalOre}), dimensionalOre, 1, 0);
        QuestTemplate reinforcedEnergyConnector = VintageQuestingSIPlugin.simpleQuest("reinforcedEnergyConnector", SIBlocks.reinforcedEnergyConnector, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.reinforcedEnergyConnector, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedEnergyCore, reinforcedCore}), reinforcedCore, -1, 1);
        QuestTemplate reinforcedItemInput = VintageQuestingSIPlugin.simpleQuest("reinforcedItemInput", SIBlocks.reinforcedItemInputBus, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.reinforcedItemInputBus, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedEnergyCore, reinforcedCore}), reinforcedEnergyConnector, -1, 0);
        QuestTemplate reinforcedItemOutput = VintageQuestingSIPlugin.simpleQuest("reinforcedItemOutput", SIBlocks.reinforcedItemOutputBus, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.reinforcedItemOutputBus, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedEnergyCore, reinforcedCore}), reinforcedEnergyConnector, -2, 0);
        QuestTemplate reinforcedFluidInput = VintageQuestingSIPlugin.simpleQuest("reinforcedFluidInput", SIBlocks.reinforcedFluidInputHatch, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.reinforcedFluidInputHatch, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedEnergyCore, reinforcedCore}), reinforcedEnergyConnector, -1, 1);
        QuestTemplate reinforcedFluidOutput = VintageQuestingSIPlugin.simpleQuest("reinforcedFluidOutput", SIBlocks.reinforcedFluidOutputHatch, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.reinforcedFluidOutputHatch, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedEnergyCore, reinforcedCore}), reinforcedEnergyConnector, -2, 1);
        QuestTemplate reinforcedCasing = VintageQuestingSIPlugin.simpleQuest("reinforcedCasing", SIBlocks.reinforcedCasing, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.reinforcedCasing, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedAlloyPlates}), reinforcedAlloyPlates, -2, 0);
        QuestTemplate reinforcedCasing2 = VintageQuestingSIPlugin.simpleQuest("reinforcedCasing2", SIBlocks.reinforcedCasing2, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.reinforcedCasing2, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedAlloyPlates}), reinforcedCasing, 0, -1);
        QuestTemplate reinforcedGrating = VintageQuestingSIPlugin.simpleQuest("reinforcedGrating", SIBlocks.reinforcedGrate, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.reinforcedGrate, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedAlloyPlates, VintageQuestingSIPlugin.getQuest("signalumAlloyMesh")}), reinforcedCasing, -1, 0);
        QuestTemplate booster = VintageQuestingSIPlugin.simpleQuest("booster", SIBlocks.dilithiumBooster, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.dilithiumBooster, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{dilithiumPlate}), dilithiumPlate, 1, 0);
        QuestTemplate stabilizer = VintageQuestingSIPlugin.simpleQuest("stabilizer", SIBlocks.dilithiumStabilizer, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.dilithiumStabilizer, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{dilithiumPlate}), booster, 0, 1);
        QuestTemplate reinforcedWrathBeacon = VintageQuestingSIPlugin.simpleQuest("reinforcedWrathBeacon", SIBlocks.reinforcedWrathBeacon, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval", "retrieval2"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.reinforcedWrathBeacon, 1), new ItemStack(SIBlocks.eternalTreeLog, 259)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedCore}), reinforcedCutter, 0, 1);
        QuestTemplate saturatedKey = VintageQuestingSIPlugin.simpleQuest("saturatedKey", (IItemConvertible)SIItems.saturatedKey, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.saturatedKey, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedWrathBeacon}), reinforcedWrathBeacon, 0, 1);
        QuestTemplate eclipse = VintageQuestingSIPlugin.simpleQuest("eclipse", (IItemConvertible)SIItems.infernalFragment, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.infernalFragment, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedWrathBeacon}), reinforcedWrathBeacon, -1, 0);
        QuestTemplate dilithiumChip = VintageQuestingSIPlugin.simpleQuest("dilithiumChip", (IItemConvertible)SIItems.dilithiumChip, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.dilithiumChip, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedCutter}), pureChip, 0, -2);
        QuestTemplate dimensionalChip = VintageQuestingSIPlugin.simpleQuest("dimensionalChip", (IItemConvertible)SIItems.dimensionalChip, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.dimensionalChip, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedCutter}), pureChip, 0, -3);
        QuestTemplate anchor = VintageQuestingSIPlugin.simpleQuest("anchor", SIBlocks.dimensionalAnchor, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval", "retrieval2", "retrieval3", "retrieval4"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.dimensionalAnchor, 1), new ItemStack(SIBlocks.dilithiumStabilizer, 4), new ItemStack(SIBlocks.glowingObsidian, 24), new ItemStack(SIBlocks.reinforcedCasing, 40)})), Catalyst.listOf((Object[])new QuestTemplate[]{warpOrb, stabilizer}), warpOrb, 1, -1);
        QuestTemplate pulsar = VintageQuestingSIPlugin.simpleQuest("pulsar", (IItemConvertible)SIItems.pulsar, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIItems.pulsar, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedEnergyCore}), reinforcedDrill, 0, -3);
        QuestTemplate pulsarAttachment = VintageQuestingSIPlugin.simpleQuest("pulsarAttachment", (IItemConvertible)SIItems.pulsarAttachment, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack((Item)SIItems.pulsarAttachment, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{pulsar}), pulsar, 1, 0);
        QuestTemplate reactor = VintageQuestingSIPlugin.simpleQuest("reactor", SIBlocks.signalumReactorCore, Catalyst.zip((List)Catalyst.listOf((Object[])new String[]{"retrieval"}), (List)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(SIBlocks.signalumReactorCore, 1)})), Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedEnergyCore, saturatedKey, reinforcedItemInput, reinforcedItemOutput, reinforcedEnergyConnector, reinforcedCasing}), saturatedKey, -1, 1);
        QuestTemplate eternity = new QuestTemplate("signalindustries:eternity", "quest.signalindustries.eternity", SIBlocks.realityFabric, Logic.AND, Logic.AND).setTasks(Catalyst.listOf((Object[])new TaskTemplate[]{new VisitDimensionTaskTemplate("signalindustries:eternity/visit", SIDimensions.ETERNITY)})).setPreRequisites(Catalyst.listOf((Object[])new QuestTemplate[]{pulsar, warpOrb})).setY(pulsar, -1).setX(pulsar, -1);
        return Catalyst.listOf((Object[])new QuestTemplate[]{reinforcedAlloy, reinforcedAlloyPlates, reinforcedCore, signaliteGear, reinforcedCutter, pureChip, reinforcedEnergyCore, reinforcedDrill, dilithiumOre, reinforcedTracker, dilithiumPlate, builder, blueprint, dimensionalOre, warpOrb, reinforcedEnergyConnector, reinforcedCasing, reinforcedFluidOutput, reinforcedFluidInput, reinforcedItemOutput, reinforcedItemInput, reinforcedGrating, reinforcedCasing2, booster, stabilizer, reinforcedWrathBeacon, eclipse, dilithiumChip, dimensionalChip, anchor, pulsar, pulsarAttachment, eternity, saturatedKey, reactor});
    }

    public static List<QuestTemplate> addAwakenedQuests() {
        return Catalyst.listOf((Object[])new QuestTemplate[0]);
    }

    public static QuestTemplate simpleQuest(String id, IItemConvertible icon, List<Pair<String, ItemStack>> tasks, List<QuestTemplate> preRequisites, QuestTemplate offsetQuest, int xOffset, int yOffset) {
        ArrayList<RetrievalTaskTemplate> retrievalTasks = new ArrayList<RetrievalTaskTemplate>();
        for (Pair<String, ItemStack> task : tasks) {
            retrievalTasks.add(new RetrievalTaskTemplate("signalindustries:" + id + "/" + (String)task.getLeft(), (ItemStack)task.getRight()));
        }
        return new QuestTemplate("signalindustries:" + id, "quest.signalindustries." + id, icon, Logic.AND, Logic.AND).setPreRequisites(preRequisites).setTasks(retrievalTasks).setX(offsetQuest, xOffset).setY(offsetQuest, yOffset);
    }

    public static QuestTemplate simpleQuest(String id, IItemConvertible icon, List<Pair<String, ItemStack>> tasks, List<Pair<String, ItemStack>> rewards, List<QuestTemplate> preRequisites, QuestTemplate offsetQuest, int xOffset, int yOffset) {
        ArrayList<RetrievalTaskTemplate> retrievalTasks = new ArrayList<RetrievalTaskTemplate>();
        for (Pair<String, ItemStack> task : tasks) {
            retrievalTasks.add(new RetrievalTaskTemplate("signalindustries:" + id + "/" + (String)task.getLeft(), (ItemStack)task.getRight()));
        }
        ArrayList<ItemRewardTemplate> itemRewards = new ArrayList<ItemRewardTemplate>();
        for (Pair<String, ItemStack> reward : rewards) {
            itemRewards.add(new ItemRewardTemplate("signalindustries:" + id + "/" + (String)reward.getLeft(), (ItemStack)reward.getRight()));
        }
        return new QuestTemplate("signalindustries:" + id, "quest.signalindustries." + id, icon, Logic.AND, Logic.AND).setPreRequisites(preRequisites).setTasks(retrievalTasks).setRewards(itemRewards).setX(offsetQuest, xOffset).setY(offsetQuest, yOffset);
    }

    public static QuestTemplate simpleClickQuest(String id, IItemConvertible icon, List<QuestTemplate> preRequisites, QuestTemplate offsetQuest, int xOffset, int yOffset) {
        return new QuestTemplate("signalindustries:" + id, "quest.signalindustries." + id, icon, Logic.AND, Logic.AND).setPreRequisites(preRequisites).setTasks(Catalyst.listOf((Object[])new TaskTemplate[]{new ClickTaskTemplate("signalindustries:" + id + "/click")})).setX(offsetQuest, xOffset).setY(offsetQuest, yOffset);
    }

    public static QuestTemplate getQuest(String id) {
        QuestTemplate item = (QuestTemplate)VintageQuesting.QUESTS.getItem("signalindustries:" + id);
        if (item == null) {
            throw new NullPointerException("Quest " + id + " not found!");
        }
        return item;
    }
}

