/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.blocks.logic;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.conduit.IConduitBlock;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.blocks.logic.base.BlockLogicTiered;
import sunsetsatellite.signalindustries.tiles.TileEntityMultiConduit;
import sunsetsatellite.signalindustries.util.Tier;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class BlockLogicMultiConduit
extends BlockLogicTiered {
    public BlockLogicMultiConduit(Block<?> block, Material material, Tier tier) {
        super(block, material, tier);
        block.withEntity(TileEntityMultiConduit::new);
    }

    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileEntityMultiConduit) {
            TileEntityMultiConduit multiConduit = (TileEntityMultiConduit)tile;
            for (IConduitBlock conduit : multiConduit.conduits) {
                if (conduit == null) continue;
                Random random = new Random();
                float xr = random.nextFloat() * 0.8f + 0.1f;
                float yr = random.nextFloat() * 0.8f + 0.1f;
                float zr = random.nextFloat() * 0.8f + 0.1f;
                EntityItem entityitem = new EntityItem(world, (double)((float)x + xr), (double)((float)y + yr), (double)((float)z + zr), new ItemStack((IItemConvertible)((BlockLogic)conduit)));
                float f3 = 0.05f;
                entityitem.xd = (float)random.nextGaussian() * f3;
                entityitem.yd = (float)random.nextGaussian() * f3 + 0.2f;
                entityitem.zd = (float)random.nextGaussian() * f3;
                world.entityJoinedWorld((Entity)entityitem);
            }
        }
        super.onBlockRemoved(world, x, y, z, data);
    }

    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        if (player.getCurrentEquippedItem() != null) {
            if (player.getCurrentEquippedItem().itemID < 16384) {
                Block b = Blocks.getBlock((int)player.getCurrentEquippedItem().itemID);
                if (b == null) {
                    return false;
                }
                BlockLogic block = b.getLogic();
                if (block instanceof IConduitBlock) {
                    TileEntityMultiConduit multiConduit;
                    IConduitBlock conduit = (IConduitBlock)block;
                    TileEntity tile = world.getTileEntity(x, y, z);
                    if (tile instanceof TileEntityMultiConduit && (multiConduit = (TileEntityMultiConduit)tile).addConduit(conduit)) {
                        player.getCurrentEquippedItem().consumeItem(player);
                        return true;
                    }
                }
            }
        } else {
            TileEntity tile = world.getTileEntity(x, y, z);
            if (tile instanceof TileEntityMultiConduit) {
                boolean normalConduitsConnected = false;
                Vec3i pos = new Vec3i(x, y, z);
                for (Direction dir : Direction.values()) {
                    BlockLogic connectedBlock;
                    Block b = dir.getBlock((WorldSource)world, pos);
                    if (b == null || !((connectedBlock = b.getLogic()) instanceof IConduitBlock)) continue;
                    normalConduitsConnected = true;
                    break;
                }
                TileEntityMultiConduit multiConduit = (TileEntityMultiConduit)tile;
                if (normalConduitsConnected && !EnvironmentHelper.isServerEnvironment()) {
                    Catalyst.displayGui((Player)player, (TileEntity)multiConduit, (String)SignalIndustries.key("gui/multi_conduit"));
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isSolidRender() {
        return false;
    }
}

