/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.blocks.models;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.client.render.block.model.BlockModelTransparent;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class BlockModelConnectedTexture
extends BlockModelTransparent<BlockLogic> {
    public List<Block<?>> connectsTo;
    protected final IconCoordinate[] texCoord;
    protected static final int[][] relCoords = new int[][]{{2, 5, 3, 4}, {2, 5, 3, 4}, {1, 4, 0, 5}, {1, 5, 0, 4}, {1, 3, 0, 2}, {1, 2, 0, 3}};

    public BlockModelConnectedTexture(Block<? extends BlockLogic> block, String key) {
        this(block, key, new ArrayList());
    }

    public BlockModelConnectedTexture(Block<? extends BlockLogic> block, String key, List<Block<?>> connectsTo) {
        super(block, false);
        this.connectsTo = connectsTo;
        this.texCoord = new IconCoordinate[]{TextureRegistry.getTexture((String)(key + "_0")), TextureRegistry.getTexture((String)(key + "_14")), TextureRegistry.getTexture((String)(key + "_13")), TextureRegistry.getTexture((String)(key + "_12")), TextureRegistry.getTexture((String)(key + "_11")), TextureRegistry.getTexture((String)(key + "_10")), TextureRegistry.getTexture((String)(key + "_9")), TextureRegistry.getTexture((String)(key + "_8")), TextureRegistry.getTexture((String)(key + "_7")), TextureRegistry.getTexture((String)(key + "_6")), TextureRegistry.getTexture((String)(key + "_5")), TextureRegistry.getTexture((String)(key + "_4")), TextureRegistry.getTexture((String)(key + "_3")), TextureRegistry.getTexture((String)(key + "_2")), TextureRegistry.getTexture((String)(key + "_1")), TextureRegistry.getTexture((String)(key + "_15"))};
        this.setAllTextures(0, TextureRegistry.getTexture((String)(key + "_0")));
    }

    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int state = this.checkNeighbors(blockAccess, x, y, z);
        BitSet bits = BlockModelConnectedTexture.intToBitSet(state, 6);
        BitSet subbits = new BitSet(4);
        for (int i = 0; i < 4; ++i) {
            subbits.set(i, bits.get(relCoords[side.getId()][i]));
        }
        return this.texCoord[BlockModelConnectedTexture.toInt(subbits)];
    }

    protected int checkNeighbors(WorldSource world, int x, int y, int z) {
        int state = 0;
        for (Side s : Side.values()) {
            int l;
            int k;
            int j;
            if (s == Side.NONE || world.getBlockId(j = x + s.getOffsetX(), k = y + s.getOffsetY(), l = z + s.getOffsetZ()) != this.block.id() && !this.connectsTo.contains(world.getBlock(j, k, l))) continue;
            state += (int)Math.pow(2.0, s.getId());
        }
        return state & 0x3F;
    }

    public static int toInt(BitSet s) {
        int v = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (!s.get(i)) continue;
            v |= 1 << i;
        }
        return v;
    }

    public static BitSet intToBitSet(int v, int l) {
        BitSet b = new BitSet(l);
        int i = 0;
        while (v != 0) {
            if (v % 2 != 0) {
                b.set(i);
            }
            ++i;
            v >>>= 1;
        }
        return b;
    }
}

