/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.blocks.models;

import java.util.HashMap;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.signalindustries.blocks.models.BlockModelMachine;
import sunsetsatellite.signalindustries.interfaces.IActiveForm;
import sunsetsatellite.signalindustries.util.MachineTextures;
import sunsetsatellite.signalindustries.util.VerticalMachineTextures;

public class BlockModelVerticalMachine
extends BlockModelMachine {
    protected VerticalMachineTextures verticalMachineTextures = new VerticalMachineTextures();

    public BlockModelVerticalMachine(Block<? extends BlockLogic> block) {
        super(block);
    }

    public BlockModelVerticalMachine(Block<? extends BlockLogic> block, MachineTextures machineTextures) {
        super(block, machineTextures);
    }

    public BlockModelVerticalMachine(Block<? extends BlockLogic> block, MachineTextures machineTextures, VerticalMachineTextures verticalMachineTextures) {
        super(block, machineTextures);
        this.verticalMachineTextures = verticalMachineTextures;
    }

    public BlockModelMachine withVerticalTextures(VerticalMachineTextures machineTextures) {
        this.verticalMachineTextures = machineTextures;
        return this;
    }

    @Override
    public IconCoordinate getBlockOverbrightTexture(WorldSource blockAccess, int x, int y, int z, int side) {
        TileEntity tileEntity = blockAccess.getTileEntity(x, y, z);
        if (tileEntity instanceof IActiveForm && ((IActiveForm)tileEntity).isBurning()) {
            int data = blockAccess.getBlockMetadata(x, y, z);
            boolean isVertical = data == 0 || data == 1;
            int index = isVertical ? VerticalMachineTextures.orientationLookUpVertical[6 * data + side] : Sides.orientationLookUpHorizontal[6 * Math.min(data, 5) + side];
            if (index >= Sides.orientationLookUpHorizontal.length) {
                return null;
            }
            Side id = Side.getSideById((int)index);
            return isVertical ? (this.verticalMachineTextures.overbrightVerticalTextures.get(id) == null ? null : TextureRegistry.getTexture((String)this.verticalMachineTextures.overbrightVerticalTextures.get(id))) : (this.machineTextures.overbrightTextures.get(id) == null ? null : TextureRegistry.getTexture((String)this.machineTextures.overbrightTextures.get(id)));
        }
        return null;
    }

    @Override
    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int index;
        TileEntity tileEntity;
        int data = blockAccess.getBlockMetadata(x, y, z);
        boolean isVertical = data == 0 || data == 1;
        HashMap<Side, String> usingTextures = this.machineTextures.defaultTextures;
        if (isVertical) {
            usingTextures = this.verticalMachineTextures.defaultVerticalTextures;
        }
        if ((tileEntity = blockAccess.getTileEntity(x, y, z)) instanceof IActiveForm && ((IActiveForm)tileEntity).isBurning()) {
            usingTextures = this.machineTextures.activeTextures;
            if (isVertical) {
                usingTextures = this.verticalMachineTextures.activeVerticalTextures;
            }
        }
        if ((index = isVertical ? VerticalMachineTextures.orientationLookUpVertical[6 * data + side.getId()] : Sides.orientationLookUpHorizontal[6 * Math.min(data, 5) + side.getId()]) >= Sides.orientationLookUpHorizontal.length) {
            return BLOCK_TEXTURE_UNASSIGNED;
        }
        Side id = Side.getSideById((int)index);
        return TextureRegistry.getTexture((String)usingTextures.get(id));
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        boolean isVertical = data == 0 || data == 1;
        int index = isVertical ? VerticalMachineTextures.orientationLookUpVertical[6 * data + side.getId()] : Sides.orientationLookUpHorizontal[6 * Math.min(data, 5) + side.getId()];
        if (index >= Sides.orientationLookUpHorizontal.length) {
            return BLOCK_TEXTURE_UNASSIGNED;
        }
        Side id = Side.getSideById((int)index);
        return isVertical ? TextureRegistry.getTexture((String)this.verticalMachineTextures.defaultVerticalTextures.get(id)) : TextureRegistry.getTexture((String)this.machineTextures.defaultTextures.get(id));
    }

    public VerticalMachineTextures verticalTextures() {
        return this.verticalMachineTextures;
    }

    public MachineTextures textures() {
        return this.machineTextures;
    }
}

