/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.covers;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.covers.CoverBase;
import sunsetsatellite.signalindustries.items.covers.ItemCover;
import sunsetsatellite.signalindustries.tiles.base.TileEntityWithName;

public class RedstoneCover
extends CoverBase {
    protected final String on = "signalindustries:block/redstone_cover_on";
    protected final String off = "signalindustries:block/redstone_cover_off";
    public boolean sensorActive;
    public int sensorMode = 0;
    public int sensorAmount = 0;
    public int sensorSlot = 0;
    public boolean sensorUseMeta = true;
    public boolean sensorUseData = false;
    public ItemStack sensorStack = null;

    @Override
    public void openConfiguration(Player player, Direction dir) {
        if (this.machine instanceof Container && this.machine instanceof TileEntity) {
            TileEntity tile = (TileEntity)this.machine;
            Catalyst.displayGui((Player)player, (TileEntity)tile, (String)SignalIndustries.key("gui/redstone_cover"), (CompoundTag)Catalyst.compoundOf((String[])new String[]{"side"}, (Object[])new Object[]{dir.ordinal()}));
        } else if (this.machine instanceof TileEntityWithName) {
            TileEntityWithName tile = (TileEntityWithName)((Object)this.machine);
            Catalyst.displayGui((Player)player, (TileEntity)tile, (String)SignalIndustries.key("gui/redstone_cover"), (CompoundTag)Catalyst.compoundOf((String[])new String[]{"side"}, (Object[])new Object[]{dir.ordinal()}));
        }
    }

    @Override
    public void readFromNbt(CompoundTag tag) {
        super.readFromNbt(tag);
        this.sensorActive = tag.getBoolean("IsActive");
        this.sensorMode = tag.getInteger("SensorMode");
        this.sensorSlot = tag.getInteger("SensorSlot");
        this.sensorAmount = tag.getInteger("CheckAmount");
        this.sensorUseMeta = tag.getBoolean("UseMeta");
        this.sensorUseData = tag.getBoolean("UseData");
        if (tag.containsKey("SensorStack")) {
            this.sensorStack = ItemStack.readItemStackFromNbt((CompoundTag)tag.getCompound("SensorStack"));
        }
    }

    @Override
    public void writeToNbt(CompoundTag tag) {
        super.writeToNbt(tag);
        tag.putBoolean("IsActive", this.sensorActive);
        tag.putInt("CheckAmount", this.sensorAmount);
        tag.putInt("SensorMode", this.sensorMode);
        tag.putInt("SensorSlot", this.sensorSlot);
        tag.putBoolean("UseMeta", this.sensorUseMeta);
        tag.putBoolean("UseData", this.sensorUseData);
        if (this.sensorStack != null) {
            CompoundTag itemNbt = new CompoundTag();
            this.sensorStack.writeToNBT(itemNbt);
            tag.putCompound("SensorStack", itemNbt);
        }
    }

    @Override
    public void tick() {
        ItemStack stack = null;
        boolean previousState = this.sensorActive;
        this.sensorActive = false;
        if (this.sensorSlot >= 0 && this.machine instanceof Container && this.machine instanceof TileEntity) {
            TileEntity tile = (TileEntity)this.machine;
            stack = ((Container)this.machine).getItem(this.sensorSlot);
            if (stack != null && this.sensorStack != null && stack.itemID == this.sensorStack.itemID) {
                this.sensorActive = this.checkIfValidForSensor(stack);
            }
            if (tile.worldObj != null && previousState != this.sensorActive) {
                tile.worldObj.notifyBlocksOfNeighborChange(tile.x, tile.y, tile.z, this.sensorActive ? 15 : 0);
            }
        } else if (this.machine instanceof Container && this.machine instanceof TileEntity) {
            TileEntity tile = (TileEntity)this.machine;
            for (int i = 0; i < ((Container)this.machine).getContainerSize(); ++i) {
                stack = ((Container)this.machine).getItem(i);
                if (stack == null || this.sensorStack == null || stack.itemID != this.sensorStack.itemID) continue;
                this.sensorActive = this.checkIfValidForSensor(stack);
                if (this.sensorActive) break;
            }
            if (tile.worldObj != null && previousState != this.sensorActive) {
                tile.worldObj.notifyBlocksOfNeighborChange(tile.x, tile.y, tile.z, this.sensorActive ? 15 : 0);
            }
        }
    }

    private boolean checkIfValidForSensor(ItemStack stack) {
        boolean yes = false;
        switch (this.sensorMode) {
            case 0: {
                yes = stack.stackSize == this.sensorAmount;
                break;
            }
            case 1: {
                yes = stack.stackSize != this.sensorAmount;
                break;
            }
            case 2: {
                yes = stack.stackSize > this.sensorAmount;
                break;
            }
            case 3: {
                yes = stack.stackSize < this.sensorAmount;
                break;
            }
            case 4: {
                yes = stack.stackSize >= this.sensorAmount;
                break;
            }
            case 5: {
                boolean bl = yes = stack.stackSize <= this.sensorAmount;
            }
        }
        if (this.sensorUseMeta && stack.getMetadata() != this.sensorStack.getMetadata()) {
            yes = false;
        }
        if (this.sensorUseData && !stack.getData().equals((Object)this.sensorStack.getData())) {
            yes = false;
        }
        return yes;
    }

    @Override
    public String getTexture() {
        return this.sensorActive ? "signalindustries:block/redstone_cover_on" : "signalindustries:block/redstone_cover_off";
    }

    @Override
    public ItemCover getItem() {
        return SIItems.redstoneCover;
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        if (this.machine instanceof Container && this.machine instanceof TileEntity) {
            this.sensorActive = false;
            TileEntity tile = (TileEntity)this.machine;
            if (tile.worldObj != null) {
                tile.worldObj.notifyBlocksOfNeighborChange(tile.x, tile.y, tile.z, 0);
            }
        }
    }

    public void buttonClicked(int id, int button, int channel) {
        switch (id) {
            case 2: {
                if (this.sensorAmount <= 0) break;
                --this.sensorAmount;
                break;
            }
            case 1: {
                ++this.sensorAmount;
                break;
            }
            case 3: {
                this.sensorUseMeta = !this.sensorUseMeta;
                break;
            }
            case 4: {
                this.sensorUseData = !this.sensorUseData;
                break;
            }
            case 0: {
                ++this.sensorMode;
                if (this.sensorMode != 6) break;
                this.sensorMode = 0;
                break;
            }
            case 5: {
                if (!(this.machine instanceof Container) || this.sensorSlot >= ((Container)this.machine).getContainerSize() - 1) break;
                ++this.sensorSlot;
                break;
            }
            case 6: {
                if (this.sensorSlot < 0) break;
                --this.sensorSlot;
            }
        }
    }
}

