/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.entities;

import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.monster.MobMonster;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.SIWeather;
import sunsetsatellite.signalindustries.entities.ProjectileSunbeam;

public class MobInfernal
extends MobMonster {
    private int beamsLaunched = 0;
    private int beamCooldown = 0;
    private DamageType lastDamageType = null;
    public boolean eclipseImmune = false;

    public MobInfernal(@Nullable World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"signalindustries", (String)"infernal");
        this.moveSpeed = 0.5f;
        this.attackStrength = 5;
        this.scoreValue = 1000;
        this.fireImmune = true;
        this.setHealthRaw(40);
        this.mobDrops.add(new WeightedRandomLootObject(SIItems.infernalFragment.getDefaultStack(), 1, 2));
    }

    protected void attackEntity(@NotNull Entity entity, float distance) {
        this.moveSpeed = this.beamCooldown > 0 ? 0.75f : 0.4f;
        double d = entity.x - this.x;
        double d1 = entity.z - this.z;
        if (this.attackTime <= 0) {
            if (!this.world.isClientSide) {
                if (this.beamCooldown > 0 && distance < 2.0f && entity.bb.maxY > this.bb.minY && entity.bb.minY < this.bb.maxY) {
                    entity.remainingFireTicks = 100;
                    entity.maxFireTicks = 100;
                    entity.hurt((Entity)this, this.attackStrength, DamageType.COMBAT);
                    this.yRot = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - 90.0f;
                    this.hasAttacked = true;
                } else if (this.beamCooldown <= 0 && distance < 10.0f) {
                    ProjectileSunbeam entityarrow = new ProjectileSunbeam(this.world, (Mob)this);
                    entityarrow.y += 0.3999999761581421;
                    double d2 = entity.y + (double)entity.getHeadHeight() - (double)0.2f - entityarrow.y;
                    float f1 = MathHelper.sqrt((double)(d * d + d1 * d1)) * 0.2f;
                    this.world.playSoundAtEntity((Entity)this, (Entity)this, "random.bow", 1.0f, 1.0f / (this.random.nextFloat() * 0.4f + 0.8f));
                    this.world.entityJoinedWorld((Entity)entityarrow);
                    entityarrow.setHeading(d, d2, d1, 0.6f, 12.0f);
                    ++this.beamsLaunched;
                    this.yRot = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - 90.0f;
                    this.hasAttacked = true;
                }
            }
            if (this.beamsLaunched < 10) {
                this.attackTime = this.beamCooldown > 0 ? 30 : 15;
            } else {
                this.beamsLaunched = 0;
                this.beamCooldown = 240;
            }
        }
    }

    public boolean hurt(Entity attacker, int i, DamageType type) {
        if (attacker instanceof MobInfernal) {
            return false;
        }
        this.lastDamageType = type;
        return super.hurt(attacker, i, type);
    }

    public int getMaxHealth() {
        return 40;
    }

    public void baseTick() {
        super.baseTick();
        if (this.beamCooldown > 0) {
            --this.beamCooldown;
        }
        if (this.target instanceof MobInfernal) {
            this.target = null;
        }
        if (this.isInWaterOrRain()) {
            this.hurt(null, 1, DamageType.DROWN);
        }
        if (this.world.getCurrentWeather() != SIWeather.weatherEclipse && !this.eclipseImmune) {
            this.hurt(null, 4, DamageType.DROWN);
        }
    }

    public void onDeath(Entity entity) {
        if (this.scoreValue >= 0 && entity != null) {
            entity.awardKillScore((Entity)this, this.scoreValue);
        }
        if (entity != null) {
            entity.killed((Mob)this);
        }
        this.dead = true;
        if (!(this.world.isClientSide || this.lastDamageType != null && this.lastDamageType.equals(DamageType.DROWN) || this.eclipseImmune)) {
            this.dropDeathItems();
        }
        this.world.sendTrackedEntityStatusUpdatePacket((Entity)this, (byte)3);
    }

    @NotNull
    public String getDefaultEntityTexture() {
        return "/assets/signalindustries/entity/infernal.png";
    }

    public String getEntityTexture() {
        return "/assets/signalindustries/entity/infernal.png";
    }

    public String getLivingSound() {
        return "fire.fire";
    }

    protected String getHurtSound() {
        return "random.fizz";
    }

    protected String getDeathSound() {
        return "random.fizz";
    }
}

