/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.entities;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.projectile.Projectile;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.SIItems;

public class ProjectileFallingMeteor
extends Projectile {
    public int blockID;

    public ProjectileFallingMeteor(World world) {
        super(world);
        this.blockID = Blocks.BASALT.id();
        this.modelItem = Blocks.BASALT.asItem();
    }

    public ProjectileFallingMeteor(World world, double x, double y, double z, int blockID) {
        super(world, x, y, z);
        this.blockID = blockID;
        this.modelItem = Blocks.getBlock((int)blockID).asItem();
    }

    protected void initProjectile() {
        this.damage = 10;
        this.defaultGravity = 0.03f;
        this.defaultProjectileSpeed = 1.0f;
    }

    public void setHeading(double newMotionX, double newMotionY, double newMotionZ, float speed, float randomness) {
        super.setHeadingPrecise(newMotionX, newMotionY, newMotionZ, speed);
    }

    public void tick() {
        super.tick();
        if (this.world != null) {
            if (this.blockID == SIBlocks.signalumOre.id()) {
                for (int j = 0; j < 4; ++j) {
                    this.world.spawnParticle("blueflame", this.x + 0.5, this.y, this.z + 0.5, this.xd * (double)0.05f, this.yd * (double)0.05f - (double)0.1f, this.zd * (double)0.05f, 0, 256.0);
                }
                this.world.spawnParticle("blueflame", this.x + 0.5, this.y, this.z + 0.5, this.xd * (double)0.05f, this.yd * (double)0.05f - (double)0.1f, this.zd * (double)0.05f, 0, 256.0);
            } else {
                for (int j = 0; j < 4; ++j) {
                    this.world.spawnParticle("flame", this.x + 0.5, this.y, this.z + 0.5, this.xd * (double)0.05f, this.yd * (double)0.05f - (double)0.1f, this.zd * (double)0.05f, 0, 256.0);
                }
                this.world.spawnParticle("flame", this.x + 0.5, this.y, this.z + 0.5, this.xd * (double)0.05f, this.yd * (double)0.05f - (double)0.1f, this.zd * (double)0.05f, 0, 256.0);
            }
        }
    }

    public void onHit(HitResult hitResult) {
        if (this.world != null && !this.world.isClientSide && this.blockID == SIBlocks.signalumOre.id()) {
            EntityItem entityitem = new EntityItem(this.world, (double)((float)this.x), (double)((float)this.y), (double)((float)this.z), new ItemStack(SIItems.rawSignalumCrystal, this.random.nextInt(3) + 1));
            if (this.world != null) {
                this.world.entityJoinedWorld((Entity)entityitem);
            }
        }
        super.onHit(hitResult);
    }
}

