/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.items.applications;

import com.mojang.nbt.tags.CompoundTag;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import sunsetsatellite.catalyst.core.util.ICustomDescription;
import sunsetsatellite.signalindustries.abilities.trigger.BoostAbility;
import sunsetsatellite.signalindustries.abilities.trigger.ProjectileAbility;
import sunsetsatellite.signalindustries.abilities.trigger.ScanAbility;
import sunsetsatellite.signalindustries.abilities.trigger.ShieldAbility;
import sunsetsatellite.signalindustries.abilities.trigger.TriggerBaseAbility;
import sunsetsatellite.signalindustries.abilities.trigger.TriggerBaseEffectAbility;
import sunsetsatellite.signalindustries.items.ItemSignalumPowerHarness;

public class ItemTrigger
extends Item
implements ICustomDescription {
    public static final HashMap<String, TriggerBaseAbility> abilities = new HashMap();

    public ItemTrigger(String translationKey, String namespaceId, int id) {
        super(translationKey, namespaceId, id);
        abilities.put("projectile", new ProjectileAbility("Projectlie", 50, 1));
        abilities.put("boost", new BoostAbility("Boost", 150, 5));
        abilities.put("shield", new ShieldAbility("Shield", 300, 15, 10, 5));
        abilities.put("scan", new ScanAbility("Scan", 150, 3, 15, 1));
    }

    public String getDescription(ItemStack stack) {
        if (this.getAbility(stack) != null) {
            return "Ability: " + TextFormatting.RED + this.getAbility((ItemStack)stack).name + TextFormatting.WHITE + " | Cost: " + TextFormatting.RED + this.getAbility((ItemStack)stack).cost + TextFormatting.WHITE + " | Cooldown: " + TextFormatting.RED + this.getAbility((ItemStack)stack).cooldown;
        }
        return "Unconfigured!";
    }

    public TriggerBaseAbility getAbility(ItemStack stack) {
        if (stack.getData().containsKey("ability") && abilities.containsKey(stack.getData().getString("ability"))) {
            return abilities.get(stack.getData().getString("ability"));
        }
        return null;
    }

    public String getAbilityName(ItemStack stack) {
        return stack.getData().getString("ability");
    }

    public String getLanguageKey(ItemStack stack) {
        if (this.getAbility(stack) != null) {
            return "item.signalindustries.trigger." + stack.getData().getString("ability");
        }
        return "item.signalindustries.trigger.null";
    }

    public boolean onUseItemOnBlock(ItemStack itemstack, Player entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        CompoundTag energy;
        int amount;
        ItemStack harness;
        TriggerBaseAbility ability = this.getAbility(itemstack);
        if (ability != null && entityplayer.inventory.armorItemInSlot(2) != null && entityplayer.inventory.armorItemInSlot(2).getItem() instanceof ItemSignalumPowerHarness && (harness = entityplayer.inventory.armorItemInSlot(2)).getData().getInteger("cooldown_" + this.getAbilityName(itemstack)) <= 0 && (amount = (energy = ((ItemSignalumPowerHarness)harness.getItem()).getFluidStack(0, harness)).getInteger("amount")) >= ability.cost) {
            if (ability instanceof TriggerBaseEffectAbility) {
                boolean active = harness.getData().getBoolean("active_" + this.getAbilityName(itemstack));
                if (active) {
                    harness.getData().putBoolean("active_" + this.getAbilityName(itemstack), false);
                    ((Map)harness.getData().getValue()).remove("effectTime_" + this.getAbilityName(itemstack));
                    harness.getData().putInt("cooldown_" + this.getAbilityName(itemstack), ability.cooldown);
                    ((TriggerBaseEffectAbility)ability).deactivate(blockX, blockY, blockZ, entityplayer, world, itemstack, harness);
                } else {
                    harness.getData().putBoolean("active_" + this.getAbilityName(itemstack), true);
                    harness.getData().putInt("effectTime_" + this.getAbilityName(itemstack), ((TriggerBaseEffectAbility)ability).effectTime);
                    energy.putInt("amount", amount - ability.cost);
                    ability.activate(blockX, blockY, blockZ, entityplayer, world, itemstack, harness);
                }
            } else {
                energy.putInt("amount", amount - ability.cost);
                harness.getData().putInt("cooldown_" + this.getAbilityName(itemstack), ability.cooldown);
                ability.activate(blockX, blockY, blockZ, entityplayer, world, itemstack, harness);
            }
        }
        return true;
    }

    public void inventoryTick(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        super.inventoryTick(itemstack, world, entity, i, flag);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.inventory.armorItemInSlot(2) != null && player.inventory.armorItemInSlot(2).getItem() instanceof ItemSignalumPowerHarness) {
                ItemStack harness = player.inventory.armorItemInSlot(2);
                boolean active = harness.getData().getBoolean("active_" + this.getAbilityName(itemstack));
                CompoundTag energy = ((ItemSignalumPowerHarness)harness.getItem()).getFluidStack(0, harness);
                int amount = energy.getInteger("amount");
                TriggerBaseAbility trigger = this.getAbility(itemstack);
                if (trigger instanceof TriggerBaseEffectAbility && active) {
                    TriggerBaseEffectAbility ability = (TriggerBaseEffectAbility)trigger;
                    if (amount >= ability.costPerTick) {
                        energy.putInt("amount", amount - ability.costPerTick);
                        ability.tick(player, world, itemstack, harness);
                    } else {
                        harness.getData().putBoolean("active_" + this.getAbilityName(itemstack), false);
                        ((Map)harness.getData().getValue()).remove("effectTime_" + this.getAbilityName(itemstack));
                        harness.getData().putInt("cooldown_" + this.getAbilityName(itemstack), ability.cooldown);
                        ability.deactivate(player, world, itemstack, harness);
                    }
                    if (harness.getData().getInteger("effectTime_" + this.getAbilityName(itemstack)) <= 0) {
                        harness.getData().putBoolean("active_" + this.getAbilityName(itemstack), false);
                        ((Map)harness.getData().getValue()).remove("effectTime_" + this.getAbilityName(itemstack));
                        harness.getData().putInt("cooldown_" + this.getAbilityName(itemstack), ability.cooldown);
                        ability.deactivate(player, world, itemstack, harness);
                    }
                }
            }
        }
    }

    public ItemStack onUseItem(ItemStack itemstack, World world, Player entityplayer) {
        CompoundTag energy;
        int amount;
        ItemStack harness;
        TriggerBaseAbility ability = this.getAbility(itemstack);
        if (ability != null && entityplayer.inventory.armorItemInSlot(2) != null && entityplayer.inventory.armorItemInSlot(2).getItem() instanceof ItemSignalumPowerHarness && (harness = entityplayer.inventory.armorItemInSlot(2)).getData().getInteger("cooldown_" + this.getAbilityName(itemstack)) <= 0 && (amount = (energy = ((ItemSignalumPowerHarness)harness.getItem()).getFluidStack(0, harness)).getInteger("amount")) >= ability.cost) {
            if (ability instanceof TriggerBaseEffectAbility) {
                boolean active = harness.getData().getBoolean("active_" + this.getAbilityName(itemstack));
                if (active) {
                    harness.getData().putBoolean("active_" + this.getAbilityName(itemstack), false);
                    ((Map)harness.getData().getValue()).remove("effectTime_" + this.getAbilityName(itemstack));
                    harness.getData().putInt("cooldown_" + this.getAbilityName(itemstack), ability.cooldown);
                    ((TriggerBaseEffectAbility)ability).deactivate(entityplayer, world, itemstack, harness);
                } else {
                    harness.getData().putBoolean("active_" + this.getAbilityName(itemstack), true);
                    harness.getData().putInt("effectTime_" + this.getAbilityName(itemstack), ((TriggerBaseEffectAbility)ability).effectTime);
                    energy.putInt("amount", amount - ability.cost);
                    ability.activate(entityplayer, world, itemstack, harness);
                }
            } else {
                energy.putInt("amount", amount - ability.cost);
                harness.getData().putInt("cooldown_" + this.getAbilityName(itemstack), ability.cooldown);
                ability.activate(entityplayer, world, itemstack, harness);
            }
        }
        return super.onUseItem(itemstack, world, entityplayer);
    }
}

