/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.items.models;

import java.util.ArrayList;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.item.model.ItemModelBlock;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.HardIllegalArgumentException;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.HologramWorld;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.util.Fluid;

public class ItemModelBlockSIFluidTank
extends ItemModelBlock {
    public ItemModelBlockSIFluidTank(ItemBlock<?> itemBlock) {
        super(itemBlock);
    }

    public void renderItemIntoGui(Tessellator tessellator, Font font, TextureManager textureManager, ItemStack itemStack, int x, int y, float brightness, float alpha) {
        if (itemStack != null) {
            NamespaceID fluidId;
            if (!itemStack.getData().containsKey("Fluid")) {
                super.renderItemIntoGui(tessellator, font, textureManager, itemStack, x, y, brightness, alpha);
                return;
            }
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)2884);
            try {
                fluidId = NamespaceID.getTemp((String)itemStack.getData().getCompound("Fluid").getString("fluid"));
            }
            catch (HardIllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            Block fluid = (Block)((Fluid)Fluid.fluidMap.get((Object)fluidId)).blocks.get(0);
            int fluidAmount = itemStack.getData().getCompound("Fluid").getInteger("amount");
            BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch((Object)fluid);
            if (model != null) {
                RenderBlocks blockRenderer = new RenderBlocks((WorldSource)new HologramWorld((ArrayList)Catalyst.listOf((Object[])new BlockInstance[]{new BlockInstance(fluid, new Vec3i(), 0, null)})));
                GL11.glBlendFunc((int)770, (int)771);
                TextureRegistry.blockAtlas.bind();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(x - 2), (float)(y + 3), (float)-3.0f);
                GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
                GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
                GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                if (this.useColor) {
                    int color = this.getColor(itemStack);
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)alpha);
                } else {
                    GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
                }
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                BlockModel.renderBlocks.useInventoryTint = this.useColor;
                RenderBlocks original = BlockModel.renderBlocks;
                BlockModel.setRenderBlocks((RenderBlocks)blockRenderer);
                model.renderBlockOnInventory(tessellator, 0, brightness, alpha, null);
                BlockModel.renderBlocks.useInventoryTint = true;
                BlockModel.setRenderBlocks((RenderBlocks)original);
                GL11.glPopMatrix();
            }
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
        }
        super.renderItemIntoGui(tessellator, font, textureManager, itemStack, x, y, brightness, alpha);
    }
}

