/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.items.tools;

import com.mojang.nbt.tags.CompoundTag;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.entity.EntityRendererItem;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.item.tool.ItemToolPickaxe;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import sunsetsatellite.catalyst.fluids.api.IFluidInventory;
import sunsetsatellite.catalyst.fluids.api.IItemFluidContainer;
import sunsetsatellite.catalyst.fluids.util.Fluid;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.interfaces.IHasOverlay;
import sunsetsatellite.signalindustries.interfaces.IPowerSuit;
import sunsetsatellite.signalindustries.interfaces.ITiered;
import sunsetsatellite.signalindustries.items.ItemSignalumPowerHarness;
import sunsetsatellite.signalindustries.util.Tier;

public class ItemSignalumDrill
extends ItemToolPickaxe
implements ITiered,
IItemFluidContainer,
IHasOverlay {
    public Tier tier;
    public int blockDestroyCost = 1;

    public ItemSignalumDrill(String lang, String namespaceId, int id, ToolMaterial enumtoolmaterial, Tier tier) {
        super(lang, namespaceId, id, enumtoolmaterial);
        this.tier = tier;
    }

    @Override
    public void renderOverlay(HudIngame guiIngame, Player player, int height, int width, int mouseX, int mouseY, Font fontRenderer, EntityRendererItem itemRenderer) {
        ContainerInventory inv = player.inventory;
        ItemStack drill = inv.getCurrentItem();
        int i = inv.armorItemInSlot(2) != null && inv.armorItemInSlot(2).getItem() instanceof ItemSignalumPowerHarness ? height - 128 : height - 64;
        fontRenderer.drawStringWithShadow("Signalite Drill", 4, i += 16, -65536);
        fontRenderer.drawStringWithShadow("Energy: ", 4, i += 16, -1);
        fontRenderer.drawStringWithShadow(String.valueOf(drill.getData().getInteger("energy")), 4 + fontRenderer.getStringWidth("Energy: "), i, -32640);
        fontRenderer.drawStringWithShadow(this.getModeString(drill), 4, i += 10, -1);
    }

    @Override
    public void renderOverlay(ItemStack stack, IPowerSuit signalumPowerSuit, HudIngame guiIngame, Player player, int height, int width, int mouseX, int mouseY, Font fontRenderer, EntityRendererItem itemRenderer) {
    }

    public String getModeString(ItemStack stack) {
        DrillMode mode = this.getMode(stack);
        switch (mode.ordinal()) {
            case 0: {
                return TextFormatting.GRAY + "Normal";
            }
            case 1: {
                return TextFormatting.YELLOW + "3x3";
            }
            case 2: {
                return TextFormatting.RED + "3x3 (Unsafe)";
            }
        }
        return TextFormatting.GRAY + "Normal";
    }

    public DrillMode getMode(ItemStack stack) {
        try {
            return DrillMode.valueOf(stack.getData().getString("mode"));
        }
        catch (IllegalArgumentException e) {
            return DrillMode.NORMAL;
        }
    }

    public void setMode(ItemStack stack, DrillMode mode) {
        stack.getData().putString("mode", mode.toString());
    }

    public boolean onBlockDestroyed(World world, ItemStack itemstack, int i, int ox, int oy, int oz, Side side, Mob mob) {
        if (world.isClientSide) {
            return true;
        }
        int energy = itemstack.getData().getInteger("energy");
        DrillMode mode = this.getMode(itemstack);
        switch (mode.ordinal()) {
            case 0: {
                if (energy < this.blockDestroyCost) break;
                itemstack.getData().putInt("energy", energy - this.blockDestroyCost);
                break;
            }
            case 1: 
            case 2: {
                if (side.getAxis() == Axis.Y) {
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            Block block = world.getBlock(ox + x, oy, oz + z);
                            if (energy < this.blockDestroyCost) continue;
                            itemstack.getData().putInt("energy", energy - this.blockDestroyCost);
                            energy = itemstack.getData().getInteger("energy");
                            int meta = world.getBlockMetadata(ox + x, oy, oz + z);
                            TileEntity tile = world.getTileEntity(ox + x, oy, oz + z);
                            if (!((Player)mob).canHarvestBlock(block) || tile != null && this.getMode(itemstack) != DrillMode.X3_UNSAFE) continue;
                            block.harvestBlock(world, (Player)mob, ox + x, oy, oz + z, meta, null);
                            world.setBlockWithNotify(ox + x, oy, oz + z, 0);
                        }
                    }
                } else if (side.getAxis() == Axis.Z) {
                    for (int x = -1; x <= 1; ++x) {
                        for (int y = -1; y <= 1; ++y) {
                            Block block = world.getBlock(ox + x, oy + y, oz);
                            if (energy < this.blockDestroyCost) continue;
                            itemstack.getData().putInt("energy", energy - this.blockDestroyCost);
                            energy = itemstack.getData().getInteger("energy");
                            int meta = world.getBlockMetadata(ox + x, oy + y, oz);
                            TileEntity tile = world.getTileEntity(ox + x, oy + y, oz);
                            if (!((Player)mob).canHarvestBlock(block) || tile != null && this.getMode(itemstack) != DrillMode.X3_UNSAFE) continue;
                            block.harvestBlock(world, (Player)mob, ox + x, oy + y, oz, meta, null);
                            world.setBlockWithNotify(ox + x, oy + y, oz, 0);
                        }
                    }
                } else {
                    if (side.getAxis() != Axis.X) break;
                    for (int z = -1; z <= 1; ++z) {
                        for (int y = -1; y <= 1; ++y) {
                            Block block = world.getBlock(ox, oy + y, oz + z);
                            if (energy < this.blockDestroyCost) continue;
                            itemstack.getData().putInt("energy", energy - this.blockDestroyCost);
                            energy = itemstack.getData().getInteger("energy");
                            int meta = world.getBlockMetadata(ox, oy + y, oz + z);
                            TileEntity tile = world.getTileEntity(ox, oy + y, oz + z);
                            if (!((Player)mob).canHarvestBlock(block) || tile != null && this.getMode(itemstack) != DrillMode.X3_UNSAFE) continue;
                            block.harvestBlock(world, (Player)mob, ox, oy + y, oz + z, meta, null);
                            world.setBlockWithNotify(ox, oy + y, oz + z, 0);
                        }
                    }
                }
                break;
            }
        }
        return true;
    }

    @Override
    public Tier getTier() {
        return this.tier;
    }

    public int getCapacity(ItemStack stack) {
        return 4000 * this.tier.ordinal();
    }

    public int getRemainingCapacity(ItemStack stack) {
        return this.getCapacity(stack) - stack.getData().getInteger("energy");
    }

    public int getFluidAmount(ItemStack stack) {
        return stack.getData().getInteger("energy");
    }

    public boolean canFill(ItemStack stack) {
        return this.getRemainingCapacity(stack) > 0;
    }

    public boolean canDrain(ItemStack stack) {
        return false;
    }

    public FluidStack getCurrentFluid(ItemStack stack) {
        return new FluidStack(SIFluids.ENERGY, this.getCapacity(stack));
    }

    public void setCurrentFluid(FluidStack fluidStack, ItemStack stack) {
        if (fluidStack.fluid != SIFluids.ENERGY) {
            return;
        }
        stack.getData().putInt("saturation", fluidStack.amount);
    }

    public ItemStack fill(FluidStack fluidStack, ItemStack stack) {
        if (fluidStack == null) {
            return null;
        }
        if (fluidStack.fluid == SIFluids.ENERGY) {
            int remaining = this.getRemainingCapacity(stack);
            int saturation = stack.getData().getInteger("energy");
            int amount = fluidStack.amount;
            if (remaining == 0) {
                return null;
            }
            if (amount > remaining) {
                fluidStack.amount -= remaining;
                CompoundTag data = new CompoundTag();
                data.putInt("energy", this.getCapacity(stack));
                stack.setData(data);
                return stack;
            }
            CompoundTag data = new CompoundTag();
            data.putInt("energy", saturation + amount);
            fluidStack.amount -= amount;
            stack.setData(data);
            return stack;
        }
        return null;
    }

    public ItemStack fill(FluidStack fluidStack, ItemStack stack, IFluidInventory tile) {
        return this.fill(fluidStack, stack);
    }

    public ItemStack fill(FluidStack fluidStack, ItemStack stack, IFluidInventory tile, int maxAmount) {
        if (fluidStack == null) {
            return null;
        }
        if (fluidStack.fluid == SIFluids.ENERGY) {
            int remaining = this.getRemainingCapacity(stack);
            int saturation = stack.getData().getInteger("energy");
            int amount = Math.min(fluidStack.amount, maxAmount);
            if (remaining == 0) {
                return null;
            }
            int result = Math.min(amount, remaining);
            if (result == 0) {
                return null;
            }
            fluidStack.amount -= result;
            CompoundTag data = new CompoundTag();
            data.putInt("energy", saturation + result);
            stack.setData(data);
            return stack;
        }
        return null;
    }

    public ItemStack fill(FluidStack fluidStack, ItemStack stack, IItemFluidContainer inv) {
        return this.fill(fluidStack, stack);
    }

    public void drain(ItemStack stack, int slot, IFluidInventory tile) {
    }

    public void drain(ItemStack stack, ItemStack other, int slot, IItemFluidContainer inv) {
    }

    public FluidStack drain(ItemStack stack, int amount) {
        return null;
    }

    public List<Fluid> getAllowedFluids(ItemStack stack) {
        return Collections.singletonList(SIFluids.ENERGY);
    }

    public ItemStack getFilled(ItemStack stack, FluidStack fluidStack) {
        return stack;
    }

    public String getDescription(ItemStack stack) {
        return "Tier: " + this.tier.getTextColor() + this.tier.getRank() + "\nMode: " + this.getModeString(stack) + "\nEnergy: " + TextFormatting.RED + stack.getData().getInteger("energy") + "/" + this.getCapacity(stack) + TextFormatting.WHITE;
    }

    public float getStrVsBlock(ItemStack itemstack, Block<?> block) {
        float superValue = super.getStrVsBlock(itemstack, block);
        if (block.hasTag(BlockTags.MINEABLE_BY_SHOVEL)) {
            superValue = this.material.getEfficiency(false);
        }
        if (superValue == 1.0f) {
            return 1.0f;
        }
        if (itemstack.getData().getInteger("energy") >= this.blockDestroyCost) {
            return this.material.getEfficiency(false);
        }
        return 1.0f;
    }

    public boolean canHarvestBlock(Mob mob, ItemStack itemStack, Block<?> block) {
        Integer miningLevel = (Integer)miningLevels.get(block);
        if (miningLevel != null) {
            return this.material.getMiningLevel() >= miningLevel;
        }
        return block.hasTag(BlockTags.MINEABLE_BY_PICKAXE) || block.hasTag(BlockTags.MINEABLE_BY_SHOVEL);
    }

    public boolean hitEntity(ItemStack itemstack, Mob target, Mob attacker) {
        return true;
    }

    public static enum DrillMode {
        NORMAL,
        X3,
        X3_UNSAFE;

    }
}

