/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.menus;

import java.util.List;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.crafting.ContainerListener;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import net.minecraft.core.player.inventory.slot.Slot;
import sunsetsatellite.catalyst.fluids.api.IFluidInventory;
import sunsetsatellite.catalyst.fluids.impl.MenuFluid;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.fluids.util.SlotFluid;
import sunsetsatellite.signalindustries.interfaces.IPlayerPowerSuit;
import sunsetsatellite.signalindustries.invs.InventoryBackpack;
import sunsetsatellite.signalindustries.items.attachments.ItemBackpackAttachment;
import sunsetsatellite.signalindustries.util.InventorySerializer;
import sunsetsatellite.signalindustries.util.SlotBackpack;

public class MenuBackpack
extends MenuFluid {
    public int backpackSlotIndex;
    public boolean isArmor;

    public MenuBackpack(ContainerInventory playerInv, int backpackSlotIndex, boolean isArmor) {
        super((IFluidInventory)new InventoryBackpack(isArmor ? ((IPlayerPowerSuit)playerInv.player).getPowerSuit().getAttachmentClass(ItemBackpackAttachment.class) : playerInv.getItem(backpackSlotIndex)));
        this.backpackSlotIndex = backpackSlotIndex;
        this.isArmor = isArmor;
        ItemStack backpack = isArmor ? ((IPlayerPowerSuit)playerInv.player).getPowerSuit().getAttachmentClass(ItemBackpackAttachment.class) : playerInv.getItem(backpackSlotIndex);
        if (backpack != null && backpack.getItem() instanceof ItemBackpackAttachment) {
            switch (((ItemBackpackAttachment)backpack.getItem()).getTier()) {
                case BASIC: {
                    InventorySerializer.loadInvFromNBT(backpack, this.itemInventory, 27, 2);
                    for (int y = 0; y < 2; ++y) {
                        this.addFluidSlot(new SlotFluid(this.fluidInventory, y, 174, 36 + 18 * y));
                    }
                    int numberOfRows = 3;
                    int i = (numberOfRows - 4) * 18;
                    for (int j = 0; j < numberOfRows; ++j) {
                        for (int i1 = 0; i1 < 9; ++i1) {
                            this.addSlot(new SlotBackpack(this.itemInventory, i1 + j * 9, 8 + i1 * 18, 18 + j * 18));
                        }
                    }
                    for (int k = 0; k < 3; ++k) {
                        for (int j1 = 0; j1 < 9; ++j1) {
                            this.addSlot(new Slot((Container)playerInv, j1 + k * 9 + 9, 8 + j1 * 18, 103 + k * 18 + i));
                        }
                    }
                    for (int l = 0; l < 9; ++l) {
                        this.addSlot(new Slot((Container)playerInv, l, 8 + l * 18, 161 + i));
                    }
                    break;
                }
                case REINFORCED: {
                    InventorySerializer.loadInvFromNBT(backpack, this.itemInventory, 54, 4);
                    for (int y = 0; y < 4; ++y) {
                        this.addFluidSlot(new SlotFluid(this.fluidInventory, y, 174, 36 + 18 * y));
                    }
                    int numberOfRows = 6;
                    int i = (numberOfRows - 4) * 18;
                    for (int j = 0; j < numberOfRows; ++j) {
                        for (int i1 = 0; i1 < 9; ++i1) {
                            this.addSlot(new SlotBackpack(this.itemInventory, i1 + j * 9, 8 + i1 * 18, 18 + j * 18));
                        }
                    }
                    for (int k = 0; k < 3; ++k) {
                        for (int j1 = 0; j1 < 9; ++j1) {
                            this.addSlot(new Slot((Container)playerInv, j1 + k * 9 + 9, 8 + j1 * 18, 103 + k * 18 + i));
                        }
                    }
                    for (int l = 0; l < 9; ++l) {
                        this.addSlot(new Slot((Container)playerInv, l, 8 + l * 18, 161 + i));
                    }
                    break;
                }
            }
        }
    }

    public FluidStack clickFluidSlot(int slotID, int button, boolean shift, boolean control, Player entityplayer) {
        return super.clickFluidSlot(slotID, button, shift, control, entityplayer);
    }

    public List<Integer> getTargetSlots(InventoryAction inventoryAction, Slot slot, int i, Player entityPlayer) {
        int lastDeviceSlot = this.slots.size() - 36 - 1;
        if (slot.index <= lastDeviceSlot) {
            return this.getSlots(lastDeviceSlot + 1, 36, true);
        }
        return this.getSlots(0, Math.max(lastDeviceSlot + 1, 1), false);
    }

    public void onCraftGuiClosed(Player player) {
        super.onCraftGuiClosed(player);
        ItemStack backpack = this.isArmor ? ((IPlayerPowerSuit)player).getPowerSuit().getAttachmentClass(ItemBackpackAttachment.class) : player.inventory.getItem(this.backpackSlotIndex);
        InventorySerializer.saveInvToNBT(backpack, this.itemInventory);
        for (int i = 0; i < this.slots.size(); ++i) {
            for (ContainerListener crafter : this.containerListeners) {
                ItemStack stack = ((Slot)this.slots.get(i)).getItemStack();
                stack = stack != null ? stack.copy() : null;
                crafter.updateInventorySlot((MenuAbstract)this, i, stack);
            }
        }
    }
}

