/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mixin;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.monster.MobMonster;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.SIWeather;

@Mixin(value={MobMonster.class}, remap=false)
public abstract class MobMonsterMixin
extends Mob {
    @Shadow
    protected int attackStrength;

    private MobMonsterMixin(@Nullable World world) {
        super(world);
    }

    @Inject(method={"attackEntity(Lnet/minecraft/core/entity/Entity;F)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void attackEntity(Entity entity, float f, CallbackInfo ci) {
        if (this.world != null && this.world.getCurrentWeather() == SIWeather.weatherBloodMoon && this.attackTime <= 0 && f < 2.0f && entity.bb.maxY > this.bb.minY && entity.bb.minY < this.bb.maxY) {
            this.attackTime = 15;
            entity.hurt((Entity)this, this.attackStrength * 2, DamageType.COMBAT);
            ci.cancel();
        }
    }

    public void onDeath(Entity entity) {
        super.onDeath(entity);
        if (this.world != null && !this.world.isClientSide) {
            if (this.random.nextInt(32) == 0) {
                this.dropItem(SIItems.monsterShard.id, 1);
            } else if (this.world != null && this.world.getCurrentWeather() == SIWeather.weatherBloodMoon && this.random.nextInt(16) == 0) {
                this.dropItem(SIItems.monsterShard.id, 1);
            }
        }
    }
}

