/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mixin;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.client.entity.player.PlayerRemote;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sunsetsatellite.signalindustries.interfaces.IPlayerPowerSuit;
import sunsetsatellite.signalindustries.items.ItemSignalumPowerSuit;
import sunsetsatellite.signalindustries.powersuit.SignalumPowerSuitRemote;

@Mixin(value={PlayerRemote.class}, remap=false)
public abstract class PlayerRemoteMixin
extends Player
implements IPlayerPowerSuit<SignalumPowerSuitRemote> {
    @Unique
    public SignalumPowerSuitRemote powerSuit = null;

    private PlayerRemoteMixin(World world) {
        super(world);
    }

    @Inject(method={"onLivingUpdate()V"}, at={@At(value="HEAD")})
    public void powerSuitUpdate(CallbackInfo ci) {
        ItemStack[] armorInventory;
        for (ItemStack itemStack : armorInventory = this.inventory.armorInventory) {
            if (itemStack == null) {
                this.powerSuit = null;
                return;
            }
            if (itemStack.getItem() instanceof ItemSignalumPowerSuit) continue;
            this.powerSuit = null;
            return;
        }
        if (this.powerSuit == null) {
            this.powerSuit = new SignalumPowerSuitRemote((PlayerRemote)this);
        } else {
            this.powerSuit.tick();
        }
    }

    @Override
    public SignalumPowerSuitRemote getPowerSuit() {
        return this.powerSuit;
    }

    @Override
    public CompoundTag getPowerSuitData() {
        return null;
    }
}

