/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mixin;

import java.util.Random;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeatureLabyrinth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.SIItems;

@Mixin(value={WorldFeatureLabyrinth.class}, remap=false)
public class WorldGenLabyrinthMixin {
    @Shadow
    public WeightedRandomBag<WeightedRandomLootObject> chestLoot;

    @Inject(method={"place(Lnet/minecraft/core/world/World;Ljava/util/Random;III)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/WeightedRandomBag;addEntry(Ljava/lang/Object;D)V", ordinal=0, shift=At.Shift.AFTER)})
    private void init(World world, Random random, int x, int y, int z, CallbackInfoReturnable<Boolean> cir) {
        this.chestLoot.addEntry((Object)new WeightedRandomLootObject(SIItems.romChipBoost.getDefaultStack()), 30.0);
        this.chestLoot.addEntry((Object)new WeightedRandomLootObject(SIItems.romChipProjectile.getDefaultStack()), 30.0);
        this.chestLoot.addEntry((Object)new WeightedRandomLootObject(SIItems.romChipShield.getDefaultStack()), 30.0);
        this.chestLoot.addEntry((Object)new WeightedRandomLootObject(SIItems.romChipScan.getDefaultStack()), 30.0);
        this.chestLoot.addEntry((Object)new WeightedRandomLootObject(SIItems.suitColorizerInverted.getDefaultStack()), 30.0);
        this.chestLoot.addEntry((Object)new WeightedRandomLootObject(SIItems.suitColorizerTransparent.getDefaultStack()), 30.0);
    }

    @Inject(method={"generateDungeon(Lnet/minecraft/core/world/World;Ljava/util/Random;IIIZ)V"}, at={@At(value="TAIL")})
    private void generateDungeon(World world, Random random, int blockX, int blockY, int blockZ, boolean doSpawner, CallbackInfo ci) {
        if (doSpawner && random.nextInt(4) == 0) {
            if (random.nextBoolean()) {
                world.setBlockWithNotify(blockX, blockY - 1, blockZ, SIBlocks.solarTotem.id());
            } else {
                world.setBlockWithNotify(blockX, blockY - 1, blockZ, SIBlocks.lunarTotem.id());
            }
        }
    }
}

