/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mp.message;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityDispatcher;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.tiles.TileEntityFilter;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class NetworkMessageFilterConfig
implements NetworkMessage {
    public Vec3i pos;
    public Class<? extends TileEntity> tileClass;
    public TileEntityFilter.FilterSide defaultSide;
    public boolean ignoreMeta;

    public NetworkMessageFilterConfig(Vec3i pos, Class<? extends TileEntity> tileClass, TileEntityFilter.FilterSide defaultSide, boolean ignoreMeta) {
        this.pos = pos;
        this.tileClass = tileClass;
        this.defaultSide = defaultSide;
        this.ignoreMeta = ignoreMeta;
    }

    public NetworkMessageFilterConfig() {
    }

    public void encodeToUniversalPacket(@NotNull UniversalPacket packet) {
        CompoundTag nbt = new CompoundTag();
        this.pos.writeToNBT(nbt);
        packet.writeCompoundTag(nbt);
        packet.writeString(TileEntityDispatcher.getIDFromClass(this.tileClass).toString());
        packet.writeByte(this.defaultSide.ordinal());
        packet.writeBoolean(this.ignoreMeta);
    }

    public void decodeFromUniversalPacket(@NotNull UniversalPacket packet) {
        this.pos = new Vec3i(packet.readCompoundTag());
        this.tileClass = TileEntityDispatcher.getClassFromID((String)packet.readString());
        this.defaultSide = TileEntityFilter.FilterSide.values()[packet.readByte()];
        this.ignoreMeta = packet.readBoolean();
    }

    public void handle(NetworkMessage.NetworkContext context) {
        TileEntity tileEntity;
        if (EnvironmentHelper.isServerEnvironment() && context.player.world != null && (tileEntity = context.player.world.getTileEntity(this.pos.x, this.pos.y, this.pos.z)) instanceof TileEntityFilter && tileEntity.worldObj != null) {
            ((TileEntityFilter)tileEntity).defaultSide = this.defaultSide;
            ((TileEntityFilter)tileEntity).ignoreMeta = this.ignoreMeta;
        }
    }
}

