/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.powersuit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import sunsetsatellite.catalyst.fluids.util.Fluid;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.invs.InventoryItemFluid;
import sunsetsatellite.signalindustries.items.ItemSignalumPowerSuit;
import sunsetsatellite.signalindustries.items.attachments.ItemExtendedEnergyPackAttachment;
import sunsetsatellite.signalindustries.util.InventorySerializer;

public class InventoryPowerSuit
extends InventoryItemFluid {
    private ItemStack armor;
    private int armorPiece;

    public InventoryPowerSuit(ItemStack item) {
        super(item);
        if (item.getItem() instanceof ItemSignalumPowerSuit) {
            this.armor = item;
            ItemSignalumPowerSuit armorPiece = (ItemSignalumPowerSuit)item.getItem();
            this.armorPiece = armorPiece.getArmorPiece();
            switch (armorPiece.getArmorPiece()) {
                case 2: {
                    this.fluidContents = new FluidStack[1];
                    this.fluidCapacity = new int[1];
                    this.fluidCapacity[0] = 32000;
                    this.contents = new ItemStack[9];
                    break;
                }
                case 0: 
                case 1: 
                case 3: {
                    this.fluidContents = new FluidStack[0];
                    this.fluidCapacity = new int[0];
                    this.contents = new ItemStack[2];
                }
            }
            this.acceptedFluids = new ArrayList(this.fluidContents.length);
            for (int i = 0; i < this.fluidContents.length; ++i) {
                ArrayList<Fluid> list = new ArrayList<Fluid>();
                list.add(SIFluids.ENERGY);
                this.acceptedFluids.add(list);
            }
            this.readFromNBT();
        }
    }

    @Override
    @Nullable
    public ItemStack removeItem(int index, int takeAmount) {
        if (this.armorPiece == 2 && index == 1) {
            this.fluidCapacity[0] = 32000;
        }
        if (this.locked(index)) {
            return null;
        }
        return super.removeItem(index, takeAmount);
    }

    @Override
    public void setItem(int index, @Nullable ItemStack itemstack) {
        super.setItem(index, itemstack);
        if (this.locked(index)) {
            return;
        }
        if (this.armorPiece == 2 && index == 1 && itemstack == null) {
            this.fluidCapacity[0] = 32000;
        } else if (this.armorPiece == 2 && index == 1 && itemstack.getItem() instanceof ItemExtendedEnergyPackAttachment) {
            this.fluidCapacity[0] = 64000;
        }
    }

    public boolean locked(int index) {
        if (index == 1 && this.getItem(1) != null && this.getItem(1).getItem() instanceof ItemExtendedEnergyPackAttachment && this.fluidContents[0] != null && this.fluidContents[0].amount > 32000) {
            return true;
        }
        return super.locked(index);
    }

    public boolean isEmpty() {
        return Arrays.stream(this.contents).allMatch(Objects::isNull);
    }

    public void readFromNBT() {
        InventorySerializer.loadInvFromNBT(this.armor, this, this.contents.length, this.fluidContents.length);
    }

    public void saveToNBT() {
        InventorySerializer.saveInvToNBT(this.armor, this);
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.powerSuit";
    }
}

