/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.powersuit;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.slot.Slot;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.fluids.impl.MenuFluid;
import sunsetsatellite.catalyst.fluids.impl.ScreenFluid;
import sunsetsatellite.catalyst.fluids.util.SlotFluid;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.interfaces.IPlayerPowerSuit;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageOpenSuit;
import sunsetsatellite.signalindustries.powersuit.InventoryPowerSuit;
import sunsetsatellite.signalindustries.powersuit.MenuPowerSuit;
import sunsetsatellite.signalindustries.powersuit.SignalumPowerSuit;
import sunsetsatellite.signalindustries.util.AttachmentPoint;
import sunsetsatellite.signalindustries.util.DrawUtil;
import sunsetsatellite.signalindustries.util.InventorySerializer;
import sunsetsatellite.signalindustries.util.SlotAttachment;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class ScreenPowerSuit
extends ScreenFluid {
    public ItemStack armorPiece;
    public ContainerInventory inv;
    public int slotIndex;

    public ScreenPowerSuit(ContainerInventory inventoryPlayer, int slotIndex, boolean isArmor) {
        super((MenuFluid)new MenuPowerSuit(inventoryPlayer, slotIndex, isArmor));
        this.armorPiece = inventoryPlayer.armorItemInSlot(slotIndex);
        this.inv = inventoryPlayer;
        this.slotIndex = slotIndex;
    }

    protected void drawGuiContainerBackgroundLayer(float f1) {
        int y;
        int x;
        super.drawGuiContainerBackgroundLayer(f1);
        int i = (this.width - this.xSize) / 2;
        int j = (this.height - this.ySize) / 2;
        DrawUtil drawUtil = new DrawUtil();
        this.drawGradientRect(i - 4, j - 4, i + this.xSize + 4, j, -1, 0x40FFFFFF);
        this.drawGradientRect(i - 4, j + this.ySize, i + this.xSize + 4, j + this.ySize + 4, 0x40FFFFFF, -1);
        drawUtil.drawGradientRect(i - 4, j - 4, i, j + this.ySize + 4, 0x40FFFFFF, -1, -1, 0x40FFFFFF);
        drawUtil.drawGradientRect(i + this.xSize, j - 4, i + this.xSize + 4, j + this.ySize + 4, -1, 0x40FFFFFF, 0x40FFFFFF, -1);
        this.drawGradientRect(i, j, i + this.xSize, j + this.ySize, 0x40FFFFFF, 0x40FFFFFF);
        for (Slot inventorySlot : this.inventorySlots.slots) {
            x = inventorySlot.x;
            y = inventorySlot.y;
            if (inventorySlot instanceof SlotAttachment && ((SlotAttachment)inventorySlot).getAttachmentPoint() == AttachmentPoint.CORE_MODULE) {
                this.drawGradientRect(i + x - 4, j + y - 4, i + x + 20, j + y + 20, -1602191232, -1602191232);
                continue;
            }
            this.drawGradientRect(i + x, j + y, i + x + 16, j + y + 16, -1602191232, -1602191232);
        }
        for (SlotFluid fluidSlot : this.fluidSlots.fluidSlots) {
            x = fluidSlot.x;
            y = fluidSlot.y;
            this.drawGradientRect(i + x, j + y, i + x + 16, j + y + 16, 0x40FF0000, 0x40FF0000);
        }
    }

    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        String name = I18n.getInstance().translateNameKey(this.fluidSlots.itemInventory.getNameTranslationKey());
        this.drawStringCentered(this.font, name, this.xSize / 2, -16, -1);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2896);
    }

    public void render(int x, int y, float f) {
        super.render(x, y, f);
        int i = (this.width - this.xSize) / 2;
        int j = (this.height - this.ySize) / 2;
        ItemStack helmet = new ItemStack((Item)SIItems.signalumPowerSuitHelmet);
        ItemStack chest = new ItemStack((Item)SIItems.signalumPowerSuitChestplate);
        ItemStack leg = new ItemStack((Item)SIItems.signalumPowerSuitLeggings);
        ItemStack boots = new ItemStack((Item)SIItems.signalumPowerSuitBoots);
        ItemModelDispatcher.getInstance().getDispatch(helmet).renderItemIntoGui(Tessellator.instance, this.font, this.mc.textureManager, helmet, i + this.xSize / 2 - 68, j + this.ySize / 2 - 23, 1.0f);
        ItemModelDispatcher.getInstance().getDispatch(chest).renderItemIntoGui(Tessellator.instance, this.font, this.mc.textureManager, chest, i + this.xSize / 2 - 38, j + this.ySize / 2 - 23, 1.0f);
        ItemModelDispatcher.getInstance().getDispatch(leg).renderItemIntoGui(Tessellator.instance, this.font, this.mc.textureManager, leg, i + this.xSize / 2 + 22, j + this.ySize / 2 - 23, 1.0f);
        ItemModelDispatcher.getInstance().getDispatch(boots).renderItemIntoGui(Tessellator.instance, this.font, this.mc.textureManager, boots, i + this.xSize / 2 + 52, j + this.ySize / 2 - 23, 1.0f);
        for (int k = 0; k < this.inventorySlots.slots.size(); ++k) {
            Slot slot = (Slot)this.inventorySlots.slots.get(k);
            if (!this.getIsMouseOverSlot(slot, x, y) || !(slot instanceof SlotAttachment) || slot.getItemStack() != null) continue;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2884);
            TooltipElement tooltip = new TooltipElement(this.mc);
            tooltip.render("Slot accepts attachments of type:\n- " + (Object)((Object)((SlotAttachment)slot).getAttachmentPoint()), x, y, 8, -8);
        }
        SignalumPowerSuit suit = (SignalumPowerSuit)((IPlayerPowerSuit)this.inv.player).getPowerSuit();
        if (suit != null) {
            for (int k = 0; k < this.fluidSlots.fluidSlots.size(); ++k) {
                SlotFluid slot = (SlotFluid)this.fluidSlots.fluidSlots.get(k);
                slot.putStack(suit.getArmorPiece((int)this.slotIndex).fluidContents[k]);
            }
        }
    }

    protected void buttonClicked(ButtonElement button) {
        super.buttonClicked(button);
        if (!button.enabled) {
            return;
        }
        if (this.inv.player.world != null && this.inv.player.world.isClientSide) {
            switch (button.id) {
                case 0: {
                    this.mc.thePlayer.closeScreen();
                    NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageOpenSuit(3));
                    break;
                }
                case 1: {
                    this.mc.thePlayer.closeScreen();
                    NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageOpenSuit(2));
                    break;
                }
                case 2: {
                    this.mc.thePlayer.closeScreen();
                    NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageOpenSuit(1));
                    break;
                }
                case 3: {
                    this.mc.thePlayer.closeScreen();
                    NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageOpenSuit(0));
                }
            }
        } else {
            switch (button.id) {
                case 0: {
                    this.mc.thePlayer.closeScreen();
                    Catalyst.displayGui((Player)this.inv.player, (Container)new InventoryPowerSuit(this.inv.armorItemInSlot(3)), (int)3, (boolean)true, (String)SignalIndustries.key("gui/power_suit"));
                    break;
                }
                case 1: {
                    this.mc.thePlayer.closeScreen();
                    Catalyst.displayGui((Player)this.inv.player, (Container)new InventoryPowerSuit(this.inv.armorItemInSlot(2)), (int)2, (boolean)true, (String)SignalIndustries.key("gui/power_suit"));
                    break;
                }
                case 2: {
                    this.mc.thePlayer.closeScreen();
                    Catalyst.displayGui((Player)this.inv.player, (Container)new InventoryPowerSuit(this.inv.armorItemInSlot(1)), (int)1, (boolean)true, (String)SignalIndustries.key("gui/power_suit"));
                    break;
                }
                case 3: {
                    this.mc.thePlayer.closeScreen();
                    Catalyst.displayGui((Player)this.inv.player, (Container)new InventoryPowerSuit(this.inv.armorItemInSlot(0)), (int)0, (boolean)true, (String)SignalIndustries.key("gui/power_suit"));
                }
            }
        }
    }

    public void init() {
        ButtonElement helmetButton = new ButtonElement(0, this.width / 2 - 70, this.height / 2 - 25, 20, 20, "");
        ButtonElement chestButton = new ButtonElement(1, this.width / 2 - 40, this.height / 2 - 25, 20, 20, "");
        ButtonElement legsButton = new ButtonElement(2, this.width / 2 + 20, this.height / 2 - 25, 20, 20, "");
        ButtonElement bootsButton = new ButtonElement(3, this.width / 2 + 50, this.height / 2 - 25, 20, 20, "");
        helmetButton.enabled = this.armorPiece.itemID != SIItems.signalumPowerSuitHelmet.id;
        chestButton.enabled = this.armorPiece.itemID != SIItems.signalumPowerSuitChestplate.id;
        legsButton.enabled = this.armorPiece.itemID != SIItems.signalumPowerSuitLeggings.id;
        bootsButton.enabled = this.armorPiece.itemID != SIItems.signalumPowerSuitBoots.id;
        this.buttons.add(helmetButton);
        this.buttons.add(chestButton);
        this.buttons.add(legsButton);
        this.buttons.add(bootsButton);
        super.init();
    }

    public void removed() {
        super.removed();
        InventorySerializer.saveInvToNBT(this.armorPiece, this.fluidSlots.itemInventory);
    }
}

