/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.recipes.entry;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeGroup;
import net.minecraft.core.data.registry.recipe.RecipeNamespace;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.io.InventoryWrapper;
import sunsetsatellite.catalyst.fluids.api.IFluidInventory;
import sunsetsatellite.catalyst.fluids.util.FluidInventoryWrapper;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.fluids.util.RecipeExtendedSymbol;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntrySI;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineSimple;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMultiblock;
import sunsetsatellite.signalindustries.util.RecipeProperties;

public class RecipeEntryMachineRandomOutput
extends RecipeEntrySI<RecipeExtendedSymbol[], WeightedRandomBag<WeightedRandomLootObject>, RecipeProperties> {
    public RecipeEntryMachineRandomOutput(RecipeExtendedSymbol[] input, WeightedRandomBag<WeightedRandomLootObject> output, RecipeProperties data) {
        super(input, output, data);
    }

    public RecipeEntryMachineRandomOutput() {
    }

    @Override
    public boolean matches(RecipeExtendedSymbol[] symbols) {
        if (symbols.length == 0) {
            return false;
        }
        HashMap<RecipeExtendedSymbol, RecipeExtendedSymbol> alreadyMatched = new HashMap<RecipeExtendedSymbol, RecipeExtendedSymbol>();
        block0: for (RecipeExtendedSymbol invInputSymbol2 : symbols) {
            for (RecipeExtendedSymbol recipeInputSymbol2 : (RecipeExtendedSymbol[])this.getInput()) {
                if (!recipeInputSymbol2.matches(invInputSymbol2) || alreadyMatched.containsKey(recipeInputSymbol2)) continue;
                alreadyMatched.put(recipeInputSymbol2, invInputSymbol2);
                continue block0;
            }
        }
        if (alreadyMatched.size() != ((RecipeExtendedSymbol[])this.getInput()).length) {
            return false;
        }
        HashMap alreadyMatchedResolved = new HashMap();
        alreadyMatched.forEach((recipeInputSymbol, invInputSymbol) -> alreadyMatchedResolved.put(recipeInputSymbol.asNormalSymbol().resolve(), invInputSymbol.asNormalSymbol().resolve()));
        return alreadyMatchedResolved.entrySet().stream().allMatch(e -> ((List)e.getKey()).stream().anyMatch(s -> ((List)e.getValue()).stream().anyMatch(s2 -> s.stackSize <= s2.stackSize)));
    }

    @Override
    public boolean matchesQuery(SearchQuery query) {
        switch (query.mode) {
            case ALL: {
                if (!this.matchesRecipe(query) && !this.matchesUsage(query) || !this.matchesScope(query)) break;
                return true;
            }
            case RECIPE: {
                if (!this.matchesRecipe(query) || !this.matchesScope(query)) break;
                return true;
            }
            case USAGE: {
                if (!this.matchesUsage(query) || !this.matchesScope(query)) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean matchesScope(SearchQuery query) {
        if (query.scope.getLeft() == SearchQuery.SearchScope.NONE) {
            return true;
        }
        if (query.scope.getLeft() == SearchQuery.SearchScope.NAMESPACE) {
            RecipeNamespace namespace = (RecipeNamespace)Registries.RECIPES.getItem((String)query.scope.getRight());
            return namespace == this.parent.getParent();
        }
        if (query.scope.getLeft() == SearchQuery.SearchScope.NAMESPACE_GROUP) {
            RecipeGroup group;
            try {
                group = Registries.RECIPES.getGroupFromKey((String)query.scope.getRight());
            }
            catch (IllegalArgumentException e) {
                group = null;
            }
            return group == this.parent;
        }
        return false;
    }

    @Override
    public boolean matchesRecipe(SearchQuery query) {
        if (query.query.getLeft() == SearchQuery.QueryType.NAME) {
            if (query.strict && ((WeightedRandomBag)this.getOutput()).getEntries().stream().map(WeightedRandomLootObject::getDefinedItemStack).anyMatch(s -> s != null && s.getDisplayName().equalsIgnoreCase((String)query.query.getRight()))) {
                return true;
            }
            return !query.strict && ((WeightedRandomBag)this.getOutput()).getEntries().stream().map(WeightedRandomLootObject::getDefinedItemStack).anyMatch(s -> s != null && s.getDisplayName().toLowerCase().contains(((String)query.query.getRight()).toLowerCase()));
        }
        if (query.query.getLeft() == SearchQuery.QueryType.GROUP && !Objects.equals(query.query.getRight(), "")) {
            List groupStacks = new RecipeSymbol((String)query.query.getRight()).resolve();
            if (groupStacks == null) {
                return false;
            }
            return groupStacks.contains(((WeightedRandomBag)this.getOutput()).getEntries().stream().map(WeightedRandomLootObject::getDefinedItemStack).filter(Objects::nonNull).findFirst().orElse(null));
        }
        return false;
    }

    @Override
    public boolean matchesUsage(SearchQuery query) {
        RecipeExtendedSymbol[] symbols;
        for (RecipeExtendedSymbol symbol : symbols = (RecipeExtendedSymbol[])this.getInput()) {
            if (symbol == null) continue;
            List stacks = symbol.resolve();
            if (query.query.getLeft() == SearchQuery.QueryType.NAME) {
                if (stacks == null) {
                    return false;
                }
                for (ItemStack stack : stacks) {
                    if (query.strict && stack.getDisplayName().equalsIgnoreCase((String)query.query.getRight())) {
                        return true;
                    }
                    if (query.strict || !stack.getDisplayName().toLowerCase().contains(((String)query.query.getRight()).toLowerCase())) continue;
                    return true;
                }
                continue;
            }
            if (query.query.getLeft() != SearchQuery.QueryType.GROUP || Objects.equals(query.query.getRight(), "")) continue;
            List groupStacks = new RecipeExtendedSymbol((String)query.query.getRight()).resolve();
            if (groupStacks == null) {
                return false;
            }
            if (!stacks.stream().anyMatch(groupStacks::contains)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void consumeMultiblockInputs(TileEntityTieredMultiblock multiblock) {
        InventoryWrapper wrapper;
        List remainingRecipeStacks;
        List<Object> recipeStacks;
        if (multiblock.usesItemInput) {
            recipeStacks = Catalyst.condenseItemList(Arrays.stream((RecipeExtendedSymbol[])this.getInput()).flatMap(symbol -> symbol.resolve().stream()).filter(Objects::nonNull).map(ItemStack::copy).collect(Collectors.toList()));
            remainingRecipeStacks = recipeStacks.stream().map(ItemStack::copy).peek(I -> I.stackSize *= multiblock.parallel).collect(Collectors.toList());
            wrapper = new InventoryWrapper((Container)multiblock.itemInput);
            for (ItemStack remainingRecipeStack : remainingRecipeStacks) {
                ItemStack stack = wrapper.removeUntil(remainingRecipeStack.itemID, remainingRecipeStack.getMetadata(), (long)remainingRecipeStack.stackSize, remainingRecipeStack.getData(), false, false);
                if (!stack.isStackEqual(remainingRecipeStack) || !stack.getItem().hasContainerItem() || ((RecipeProperties)this.getData()).consumeContainers) continue;
                wrapper.add(new ItemStack(stack.getItem().getContainerItem()));
            }
        }
        if (multiblock.usesFluidInput) {
            recipeStacks = Arrays.stream((RecipeExtendedSymbol[])this.getInput()).flatMap(symbol -> symbol.resolveFluids().stream()).filter(Objects::nonNull).map(FluidStack::copy).collect(Collectors.toList());
            remainingRecipeStacks = recipeStacks.stream().map(FluidStack::copy).peek(F -> F.amount *= multiblock.parallel).collect(Collectors.toList());
            wrapper = new FluidInventoryWrapper((IFluidInventory)multiblock.fluidInput);
            for (ItemStack remainingRecipeStack : remainingRecipeStacks) {
                wrapper.removeUntil(remainingRecipeStack.fluid.getFirstId(), remainingRecipeStack.amount, false);
            }
        }
    }

    @Override
    public boolean canMultiblockProcess(TileEntityTieredMultiblock multiblock) {
        for (WeightedRandomLootObject entry : ((WeightedRandomBag)this.getOutput()).getEntries()) {
            ItemStack stack = entry.getDefinedItemStack();
            if (stack == null) {
                return false;
            }
            int n = stack.copy().stackSize = entry.isRandomYield() ? entry.getMaxYield() : entry.getFixedYield();
            if (multiblock.areItemOutputsValid(stack)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void processMultiblockRecipe(TileEntityTieredMultiblock multiblock) {
        ItemStack stack;
        ItemStack itemStack = stack = this.getOutput() == null ? null : ((WeightedRandomLootObject)((WeightedRandomBag)this.getOutput()).getRandom()).getItemStack();
        if (stack != null) {
            multiblock.consumeInputs();
            if (multiblock.random.nextFloat() <= ((RecipeProperties)this.getData()).chance) {
                int multiplier = 1;
                int outputAmountRemaining = stack.stackSize * (multiplier *= multiblock.parallel);
                for (int i = 0; i < multiblock.itemOutput.itemContents.length; ++i) {
                    int willTake;
                    int maxAmountInSlot;
                    ItemStack outputStack = multiblock.itemOutput.itemContents[i];
                    if (outputStack == null) {
                        maxAmountInSlot = stack.getMaxStackSize();
                        if (maxAmountInSlot <= 0 || (willTake = Math.min(outputAmountRemaining, maxAmountInSlot)) <= 0) continue;
                        ItemStack copy = stack.copy();
                        copy.stackSize = willTake;
                        multiblock.itemOutput.setItem(i, copy);
                        if ((outputAmountRemaining -= willTake) > 0) continue;
                        break;
                    }
                    if (!outputStack.isItemEqual(stack) || (maxAmountInSlot = stack.getMaxStackSize() - outputStack.stackSize) <= 0 || (willTake = Math.min(outputAmountRemaining, maxAmountInSlot)) <= 0) continue;
                    outputStack.stackSize += willTake;
                    if ((outputAmountRemaining -= willTake) <= 0) break;
                }
            }
        }
    }

    @Override
    public void consumeMachineInputs(TileEntityTieredMachineSimple machine) {
    }

    @Override
    public boolean canMachineProcess(TileEntityTieredMachineSimple machine) {
        return false;
    }

    @Override
    public void processMachineRecipe(TileEntityTieredMachineSimple machine) {
    }
}

