/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.render;

import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.HologramWorld;
import sunsetsatellite.catalyst.core.util.model.IColorOverride;
import sunsetsatellite.catalyst.core.util.model.IFullbright;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.items.ItemBlueprint;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityBuilder;
import sunsetsatellite.signalindustries.util.SIMultiblock;

public class RenderBuilderPreview
extends TileEntityRenderer<TileEntity> {
    protected RenderBlocks blockRenderer;

    public void doRender(Tessellator tessellator, TileEntity tileEntity, double d, double e, double f, float g) {
        int i = tileEntity.x;
        int j = tileEntity.y;
        int k = tileEntity.z;
        World world = tileEntity.worldObj;
        TileEntityBuilder builder = (TileEntityBuilder)tileEntity;
        Direction dir = builder.rotation;
        if (builder.itemContents[0] != null && builder.itemContents[0].getItem() instanceof ItemBlueprint) {
            SIMultiblock multiblock = builder.getMultiblock();
            if (multiblock == null) {
                return;
            }
            ArrayList blocks = multiblock.getBlocks(new Vec3i(i, j, k).add(builder.offset), dir);
            blocks.add(multiblock.getOrigin(new Vec3i(i, j, k).add(builder.offset), dir.getOpposite().shiftAxis()));
            ArrayList substitutions = multiblock.getSubstitutions(new Vec3i(i, j, k).add(builder.offset), dir);
            this.blockRenderer = new RenderBlocks((WorldSource)new HologramWorld(blocks));
            for (BlockInstance block : blocks) {
                boolean foundSub;
                if (block.exists(world) || (foundSub = substitutions.stream().anyMatch(BI -> BI.pos.equals((Object)block.pos) && BI.exists(world))) || Objects.equals(world.getLevelData().getWorldName(), "modelviewer")) continue;
                GL11.glPushMatrix();
                GL11.glDisable((int)2896);
                GL11.glTranslatef((float)((float)d + (float)(block.pos.x - i) + 0.5f), (float)((float)e + (float)(block.pos.y - j) + 0.5f), (float)((float)f + (float)(block.pos.z - k) + 0.5f));
                BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch((Object)block.block);
                ((IFullbright)model).enableFullbright();
                if (world.getBlockId(block.pos.x, block.pos.y, block.pos.z) != 0) {
                    ((IColorOverride)model).enableColorOverride();
                    ((IColorOverride)model).overrideColor(1.0f, 0.0f, 0.0f, 0.9f);
                    GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
                } else {
                    ((IColorOverride)model).overrideColor(1.0f, 1.0f, 1.0f, 0.75f);
                    GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
                }
                this.drawBlock(tessellator, model, block.meta == -1 ? 0 : block.meta);
                GL11.glEnable((int)2896);
                GL11.glPopMatrix();
                ((IColorOverride)model).overrideColor(1.0f, 1.0f, 1.0f, 1.0f);
                ((IColorOverride)model).disableColorOverride();
                ((IFullbright)model).disableFullbright();
            }
            if (!Objects.equals(builder.currentlyBuilding, new Vec3i()) && builder.buildingMultiblock != null && !builder.buildingBlocks.isEmpty()) {
                this.renderLineBetweenTwoPoints(i, j, k, builder.currentlyBuilding.x, builder.currentlyBuilding.y, builder.currentlyBuilding.z, 1.0f, 0.0f, 0.0f, 1.0f, 8.0f, d, e, f);
            }
        }
    }

    public void renderLineBetweenTwoPoints(int x1, int y1, int z1, long x2, long y2, long z2, float red, float green, float blue, float alpha, float width, double x, double y, double z) {
        this.renderLineBetweenTwoPoints(x1, y1, z1, x2, y2, z2, red, green, blue, alpha, width, new ArrayList<Integer>(), new ArrayList<Integer>(), new ArrayList<Integer>(), new ArrayList<Integer>(), false, false, false, x, y, z);
    }

    public void renderLineBetweenTwoPoints(int x1, int y1, int z1, long x2, long y2, long z2, float red, float green, float blue, float alpha, float width, ArrayList<Integer> xadd, ArrayList<Integer> yadd, ArrayList<Integer> zadd, ArrayList<Integer> sideadd, boolean backwired, boolean firstblocksided, boolean secondblocksided, double x, double y, double z) {
        float zoffset;
        float yoffset;
        float xoffset;
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glLineWidth((float)width);
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glDepthMask((boolean)false);
        GL11.glBegin((int)3);
        LightmapHelper.setLightmapCoord((int)15, (int)15);
        if (!backwired) {
            if (firstblocksided) {
                xoffset = 0.0f;
                yoffset = 0.0f;
                zoffset = 0.0f;
                switch (Minecraft.getMinecraft().currentWorld.getBlockMetadata(x1, y1, z1)) {
                    case 0: {
                        xoffset = 0.5f;
                        yoffset = 0.9f;
                        zoffset = 0.5f;
                        break;
                    }
                    case 1: {
                        xoffset = 0.1f;
                        yoffset = 0.5f;
                        zoffset = 0.5f;
                        break;
                    }
                    case 2: {
                        xoffset = 0.9f;
                        yoffset = 0.5f;
                        zoffset = 0.5f;
                        break;
                    }
                    case 3: {
                        xoffset = 0.5f;
                        yoffset = 0.5f;
                        zoffset = 0.1f;
                        break;
                    }
                    case 4: {
                        xoffset = 0.5f;
                        yoffset = 0.5f;
                        zoffset = 0.9f;
                        break;
                    }
                    case 5: {
                        xoffset = 0.5f;
                        yoffset = 0.1f;
                        zoffset = 0.5f;
                    }
                }
                GL11.glVertex3f((float)xoffset, (float)yoffset, (float)zoffset);
            } else {
                GL11.glVertex3f((float)0.5f, (float)0.5f, (float)0.5f);
            }
        } else if (secondblocksided) {
            xoffset = 0.0f;
            yoffset = 0.0f;
            zoffset = 0.0f;
            switch (Minecraft.getMinecraft().currentWorld.getBlockMetadata((int)x2, (int)y2, (int)z2)) {
                case 0: {
                    xoffset = 0.5f;
                    yoffset = 0.9f;
                    zoffset = 0.5f;
                    break;
                }
                case 1: {
                    xoffset = 0.1f;
                    yoffset = 0.5f;
                    zoffset = 0.5f;
                    break;
                }
                case 2: {
                    xoffset = 0.9f;
                    yoffset = 0.5f;
                    zoffset = 0.5f;
                    break;
                }
                case 3: {
                    xoffset = 0.5f;
                    yoffset = 0.5f;
                    zoffset = 0.1f;
                    break;
                }
                case 4: {
                    xoffset = 0.5f;
                    yoffset = 0.5f;
                    zoffset = 0.9f;
                    break;
                }
                case 5: {
                    xoffset = 0.5f;
                    yoffset = 0.1f;
                    zoffset = 0.5f;
                }
            }
            GL11.glVertex3d((double)((float)(-((long)x1 - x2)) + xoffset), (double)((float)(-((long)y1 - y2)) + yoffset), (double)((float)(-((long)z1 - z2)) + zoffset));
        } else {
            GL11.glVertex3d((double)((float)(-((long)x1 - x2)) + 0.5f), (double)((float)(-((long)y1 - y2)) + 0.5f), (double)((float)(-((long)z1 - z2)) + 0.5f));
        }
        for (int i = xadd.size() - 1; i >= 0; --i) {
            float xoffset2 = 0.0f;
            float yoffset2 = 0.0f;
            float zoffset2 = 0.0f;
            switch (sideadd.get(i)) {
                case 0: {
                    xoffset2 = 0.5f;
                    yoffset2 = -0.1f;
                    zoffset2 = 0.5f;
                    break;
                }
                case 1: {
                    xoffset2 = 0.5f;
                    yoffset2 = 1.1f;
                    zoffset2 = 0.5f;
                    break;
                }
                case 2: {
                    xoffset2 = 0.5f;
                    yoffset2 = 0.5f;
                    zoffset2 = -0.1f;
                    break;
                }
                case 3: {
                    xoffset2 = 0.5f;
                    yoffset2 = 0.5f;
                    zoffset2 = 1.1f;
                    break;
                }
                case 4: {
                    xoffset2 = -0.1f;
                    yoffset2 = 0.5f;
                    zoffset2 = 0.5f;
                    break;
                }
                case 5: {
                    xoffset2 = 1.1f;
                    yoffset2 = 0.5f;
                    zoffset2 = 0.5f;
                }
            }
            GL11.glVertex3d((double)((float)(-(x1 - xadd.get(i))) + xoffset2), (double)((float)(-(y1 - yadd.get(i))) + yoffset2), (double)((float)(-(z1 - zadd.get(i))) + zoffset2));
        }
        if (backwired) {
            if (firstblocksided) {
                float xoffset3 = 0.0f;
                yoffset = 0.0f;
                zoffset = 0.0f;
                switch (Minecraft.getMinecraft().currentWorld.getBlockMetadata(x1, y1, z1)) {
                    case 0: {
                        xoffset3 = 0.5f;
                        yoffset = 0.9f;
                        zoffset = 0.5f;
                        break;
                    }
                    case 1: {
                        xoffset3 = 0.1f;
                        yoffset = 0.5f;
                        zoffset = 0.5f;
                        break;
                    }
                    case 2: {
                        xoffset3 = 0.9f;
                        yoffset = 0.5f;
                        zoffset = 0.5f;
                        break;
                    }
                    case 3: {
                        xoffset3 = 0.5f;
                        yoffset = 0.5f;
                        zoffset = 0.1f;
                        break;
                    }
                    case 4: {
                        xoffset3 = 0.5f;
                        yoffset = 0.5f;
                        zoffset = 0.9f;
                        break;
                    }
                    case 5: {
                        xoffset3 = 0.5f;
                        yoffset = 0.1f;
                        zoffset = 0.5f;
                    }
                }
                GL11.glVertex3f((float)xoffset3, (float)yoffset, (float)zoffset);
            } else {
                GL11.glVertex3f((float)0.5f, (float)0.5f, (float)0.5f);
            }
        } else if (secondblocksided) {
            float xoffset4 = 0.0f;
            yoffset = 0.0f;
            zoffset = 0.0f;
            switch (Minecraft.getMinecraft().currentWorld.getBlockMetadata((int)x2, (int)y2, (int)z2)) {
                case 0: {
                    xoffset4 = 0.5f;
                    yoffset = 0.9f;
                    zoffset = 0.5f;
                    break;
                }
                case 1: {
                    xoffset4 = 0.1f;
                    yoffset = 0.5f;
                    zoffset = 0.5f;
                    break;
                }
                case 2: {
                    xoffset4 = 0.9f;
                    yoffset = 0.5f;
                    zoffset = 0.5f;
                    break;
                }
                case 3: {
                    xoffset4 = 0.5f;
                    yoffset = 0.5f;
                    zoffset = 0.1f;
                    break;
                }
                case 4: {
                    xoffset4 = 0.5f;
                    yoffset = 0.5f;
                    zoffset = 0.9f;
                    break;
                }
                case 5: {
                    xoffset4 = 0.5f;
                    yoffset = 0.1f;
                    zoffset = 0.5f;
                }
            }
            GL11.glVertex3d((double)((float)(-((long)x1 - x2)) + xoffset4), (double)((float)(-((long)y1 - y2)) + yoffset), (double)((float)(-((long)z1 - z2)) + zoffset));
        } else {
            GL11.glVertex3d((double)((float)(-((long)x1 - x2)) + 0.5f), (double)((float)(-((long)y1 - y2)) + 0.5f), (double)((float)(-((long)z1 - z2)) + 0.5f));
        }
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }

    public void drawBlock(Tessellator tessellator, BlockModel<?> model, int meta) {
        TextureRegistry.blockAtlas.bind();
        GL11.glPushMatrix();
        RenderBlocks renderBlocks = BlockModel.renderBlocks;
        BlockModel.setRenderBlocks((RenderBlocks)this.blockRenderer);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        model.renderBlockOnInventory(tessellator, meta, 1.0f, null);
        BlockModel.setRenderBlocks((RenderBlocks)renderBlocks);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glEnable((int)2884);
    }
}

