/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.render;

import java.util.ArrayList;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.HologramWorld;
import sunsetsatellite.catalyst.core.util.conduit.ConduitCapability;
import sunsetsatellite.catalyst.core.util.conduit.IConduitBlock;
import sunsetsatellite.catalyst.core.util.model.IColorOverride;
import sunsetsatellite.catalyst.core.util.vector.Vec3f;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.fluids.util.Fluids;
import sunsetsatellite.signalindustries.blocks.logic.BlockLogicMultiConduit;
import sunsetsatellite.signalindustries.tiles.TileEntityMultiConduit;

public class RenderFluidInMultiConduit
extends TileEntityRenderer<TileEntityMultiConduit> {
    private RenderBlocks blockRenderer;

    public void doRender(Tessellator tessellator, TileEntityMultiConduit tile, double x, double y, double z, float f) {
        int i;
        Vec3i pos = new Vec3i(tile.x, tile.y, tile.z);
        boolean split = false;
        for (Direction dir : Direction.values()) {
            Direction side;
            Block connectedBlock = dir.getBlock((WorldSource)tile.worldObj, pos);
            if (connectedBlock != null && connectedBlock.getLogic() instanceof BlockLogicMultiConduit && (side = Direction.getDirectionFromSide((int)tile.worldObj.getBlockMetadata(tile.x, tile.y, tile.z))) != dir && side != dir.getOpposite()) {
                split = true;
                break;
            }
            if (connectedBlock == null || !(connectedBlock.getLogic() instanceof IConduitBlock)) continue;
            split = true;
            break;
        }
        if (split) {
            return;
        }
        BlockModel[] models = new BlockModel[4];
        Vec3f[][] vecs = new Vec3f[][]{{new Vec3f(0.5, (double)0.7f, (double)0.7f), new Vec3f(0.5, (double)0.7f, (double)0.3f), new Vec3f(0.5, (double)0.3f, (double)0.7f), new Vec3f(0.5, (double)0.3f, (double)0.3f)}, {new Vec3f((double)0.7f, 0.5, (double)0.7f), new Vec3f((double)0.3f, 0.5, (double)0.7f), new Vec3f((double)0.7f, 0.5, (double)0.3f), new Vec3f((double)0.3f, 0.5, (double)0.3f)}, {new Vec3f((double)0.7f, (double)0.7f, 0.5), new Vec3f((double)0.3f, (double)0.7f, 0.5), new Vec3f((double)0.7f, (double)0.3f, 0.5), new Vec3f((double)0.3f, (double)0.3f, 0.5)}};
        IConduitBlock[] conduits = tile.conduits;
        for (i = 0; i < conduits.length; ++i) {
            IConduitBlock conduit = conduits[i];
            if (conduit == null || conduit.getConduitCapability() != ConduitCapability.SIGNALUM && conduit.getConduitCapability() != ConduitCapability.FLUID) continue;
            models[i] = tile.fluidContents[i] != null ? (BlockModel)BlockModelDispatcher.getInstance().getDispatch((Object)((Block)tile.fluidContents[i].fluid.blocks.get(0))) : null;
        }
        for (i = 0; i < models.length; ++i) {
            BlockModel model = models[i];
            if (model == null || tile.fluidContents[i] == null) continue;
            ArrayList<BlockInstance> blockInstances = new ArrayList<BlockInstance>();
            for (FluidStack fluidStack : tile.fluidContents) {
                if (fluidStack == null) continue;
                blockInstances.add(new BlockInstance((Block)fluidStack.fluid.blocks.get(0), new Vec3i(i), null));
            }
            this.blockRenderer = new RenderBlocks((WorldSource)new HologramWorld(blockInstances));
            int amount = tile.fluidContents[i].amount;
            int maxAmount = tile.fluidCapacity[i];
            float ratio = (float)amount / (float)maxAmount;
            float mappedRatio = (float)Catalyst.map((double)ratio, (double)0.0, (double)1.0, (double)0.0, (double)0.3);
            Axis axis = Side.getSideById((int)tile.worldObj.getBlockMetadata(tile.x, tile.y, tile.z)).getAxis();
            int axisOrd = axis.ordinal();
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            GL11.glTranslated((double)(x + vecs[axisOrd][i].x), (double)(y + vecs[axisOrd][i].y), (double)(z + vecs[axisOrd][i].z));
            switch (axis) {
                case X: {
                    GL11.glScalef((float)0.98f, (float)mappedRatio, (float)0.3f);
                    break;
                }
                case Y: {
                    GL11.glScalef((float)mappedRatio, (float)0.98f, (float)mappedRatio);
                    break;
                }
                case Z: {
                    GL11.glScalef((float)0.3f, (float)mappedRatio, (float)0.98f);
                }
            }
            if (tile.fluidContents[i].fluid == Fluids.WATER) {
                ((IColorOverride)model).overrideColor(0.0f, 0.5f, 1.0f, 0.75f);
            }
            this.drawBlock(tessellator, model, 0);
            ((IColorOverride)model).overrideColor(1.0f, 1.0f, 1.0f, 1.0f);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
    }

    public void drawBlock(Tessellator tessellator, BlockModel<?> model, int meta) {
        TextureRegistry.blockAtlas.bind();
        GL11.glPushMatrix();
        RenderBlocks renderBlocks = BlockModel.renderBlocks;
        BlockModel.setRenderBlocks((RenderBlocks)this.blockRenderer);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        model.renderBlockOnInventory(tessellator, meta, 1.0f, 0.75f, null);
        BlockModel.setRenderBlocks((RenderBlocks)renderBlocks);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glEnable((int)2884);
    }
}

