/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.slot.Slot;
import sunsetsatellite.catalyst.fluids.impl.MenuFluid;
import sunsetsatellite.catalyst.fluids.impl.ScreenFluid;
import sunsetsatellite.signalindustries.interfaces.IPlayerPowerSuit;
import sunsetsatellite.signalindustries.items.attachments.ItemAbilityModule;
import sunsetsatellite.signalindustries.menus.MenuAbilityModule;
import sunsetsatellite.signalindustries.util.DrawUtil;
import sunsetsatellite.signalindustries.util.InventorySerializer;
import sunsetsatellite.signalindustries.util.Tier;

public class ScreenAbilityModule
extends ScreenFluid {
    public int slotIndex;
    public boolean isArmor;
    public ItemStack module;
    public Player player;

    public ScreenAbilityModule(ContainerInventory inventoryPlayer, int slotIndex, boolean isArmor) {
        super((MenuFluid)new MenuAbilityModule(inventoryPlayer, slotIndex, isArmor));
        this.slotIndex = slotIndex;
        this.isArmor = isArmor;
        this.player = inventoryPlayer.player;
        this.module = isArmor ? ((IPlayerPowerSuit)inventoryPlayer.player).getPowerSuit().getAttachmentClass(ItemAbilityModule.class) : inventoryPlayer.getItem(slotIndex);
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        super.drawGuiContainerBackgroundLayer(f);
        int i = (this.width - this.xSize) / 2;
        int j = (this.height - this.ySize) / 2;
        Tier tier = ((ItemAbilityModule)this.module.getItem()).getTier();
        int color = tier.getColor();
        int color2 = tier.getColor(64);
        DrawUtil drawUtil = new DrawUtil();
        this.drawGradientRect(i - 4, j - 4, i + this.xSize + 4, j, color, color2);
        this.drawGradientRect(i - 4, j + this.ySize, i + this.xSize + 4, j + this.ySize + 4, color2, color);
        drawUtil.drawGradientRect(i - 4, j - 4, i, j + this.ySize + 4, color2, color, color, color2);
        drawUtil.drawGradientRect(i + this.xSize, j - 4, i + this.xSize + 4, j + this.ySize + 4, color, color2, color2, color);
        this.drawGradientRect(i, j, i + this.xSize, j + this.ySize, color2, color2);
        for (Slot inventorySlot : this.inventorySlots.slots) {
            int x = inventorySlot.x;
            int y = inventorySlot.y;
            this.drawGradientRect(i + x, j + y, i + x + 16, j + y + 16, tier.getColor(160), tier.getColor(160));
        }
    }

    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        String name = I18n.getInstance().translateNameKey(this.fluidSlots.itemInventory.getNameTranslationKey());
        Tier tier = ((ItemAbilityModule)this.module.getItem()).getTier();
        if (this.module.getItem() instanceof ItemAbilityModule) {
            switch (tier) {
                case REINFORCED: {
                    name = I18n.getInstance().translateNameKey("container.signalindustries.abilityModule");
                    break;
                }
                case AWAKENED: {
                    name = I18n.getInstance().translateNameKey("container.signalindustries.awakenedAbilityModule");
                }
            }
            this.font.drawCenteredString(name, 90, 6, tier.getColor());
        }
    }

    public void removed() {
        super.removed();
        this.module = this.isArmor ? ((IPlayerPowerSuit)this.player).getPowerSuit().getAttachmentClass(ItemAbilityModule.class) : this.player.inventory.getItem(this.slotIndex);
        InventorySerializer.saveInvToNBT(this.module, this.fluidSlots.itemInventory);
    }
}

