/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.core.util.mp.PacketScreenAction;
import sunsetsatellite.catalyst.fluids.impl.MenuFluid;
import sunsetsatellite.catalyst.fluids.impl.ScreenFluid;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.signalindustries.menus.MenuAutoMiner;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageAutoMinerStart;
import sunsetsatellite.signalindustries.screens.ScreenFluidIOConfig;
import sunsetsatellite.signalindustries.screens.ScreenItemIOConfig;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityAutoMiner;
import sunsetsatellite.signalindustries.util.Tier;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class ScreenAutoMiner
extends ScreenFluid {
    public Player player;
    public TileEntityAutoMiner tile;
    public ButtonElement itemIoButton;
    public ButtonElement fluidIoButton;

    public ScreenAutoMiner(ContainerInventory inv, TileEntity tile) {
        super((MenuFluid)new MenuAutoMiner(inv, (TileEntityFluidItemContainer)tile));
        this.tile = (TileEntityAutoMiner)tile;
        this.player = inv.player;
        if (this.tile.tier == Tier.REINFORCED) {
            this.ySize = 249;
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        super.drawGuiContainerBackgroundLayer(f);
        Texture bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/autominer.png");
        switch (this.tile.tier) {
            case PROTOTYPE: 
            case BASIC: {
                bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/autominer.png");
                break;
            }
            case REINFORCED: {
                bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/reinforced_autominer.png");
                break;
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(bg);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        if (this.tile.isBurning()) {
            int counter = this.tile.getBurnTimeRemainingScaled(12);
            this.drawTexturedModalRect(x + 9, y + 36 + 12 - counter, 176, 12 - counter, 14, counter + 2);
        }
        if (this.tile.speedMultiplier > 1.0f) {
            this.drawStringCentered(this.font, this.tile.speedMultiplier + "x", x + this.xSize - 16, y + this.ySize / 2 - 16, this.tile.speedMultiplier >= 3.0f ? -23296 : (this.tile.speedMultiplier >= 2.0f ? -65281 : -32640));
        }
    }

    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        int color = -1;
        switch (this.tile.tier) {
            case PROTOTYPE: {
                break;
            }
            case BASIC: {
                color = -32640;
                break;
            }
            case REINFORCED: {
                color = -65536;
                break;
            }
            case AWAKENED: {
                color = -23296;
            }
        }
        this.font.drawCenteredString(I18n.getInstance().translateNameKey(this.tile.getNameTranslationKey()), 90, 6, color);
        this.font.drawStringWithShadow("X: " + (this.tile.current.x - this.tile.x), 38, 20, -65536);
        this.font.drawStringWithShadow("Y: " + (this.tile.current.y - this.tile.y), 38, 32, -12549889);
        this.font.drawStringWithShadow("Z: " + (this.tile.current.z - this.tile.z), 38, 44, -16711936);
        this.font.drawStringWithShadow("C: " + this.tile.cost + "/" + this.tile.fuelMaxBurnTicks + "t", 80, 32, -8388608);
        this.font.drawStringWithShadow("S: " + this.tile.workTimer.max + "t", 80, 44, Short.MIN_VALUE);
        this.font.drawStringWithShadow("M: " + this.tile.multiplier, 80, 56, -65281);
        if (this.tile.tier == Tier.REINFORCED) {
            this.font.drawCenteredString("Size", 42, 82, -65536);
            this.font.drawString(String.valueOf(this.tile.size.x), 35, 100, -1, true);
            this.font.drawString(String.valueOf(this.tile.size.y), 35, 125, -1, true);
        }
    }

    public void init() {
        ButtonElement fluidIo = new ButtonElement(0, Math.round((float)this.width / 2.0f) + 60, this.tile.tier == Tier.BASIC ? Math.round((float)this.height / 2.0f) - 80 : Math.round((float)this.height / 2.0f) - 120, 20, 20, "F");
        this.buttons.add(fluidIo);
        ButtonElement itemIo = new ButtonElement(1, Math.round((float)this.width / 2.0f) + 60, this.tile.tier == Tier.BASIC ? Math.round((float)this.height / 2.0f) - 60 : Math.round((float)this.height / 2.0f) - 100, 20, 20, "I");
        this.buttons.add(itemIo);
        this.fluidIoButton = fluidIo;
        this.itemIoButton = itemIo;
        this.buttons.add(new ButtonElement(2, Math.round((float)this.width / 2.0f) - 81, this.tile.tier == Tier.BASIC ? Math.round((float)this.height / 2.0f) - 80 : Math.round((float)this.height / 2.0f) - 120, 20, 20, this.tile.workTimer.isPaused() ? "OFF" : "ON"));
        if (this.tile.tier == Tier.REINFORCED) {
            this.buttons.add(new ButtonElement(4, Math.round((float)this.width / 2.0f) - 75, Math.round((float)this.height / 2.0f) - 30, 20, 20, "-"));
            this.buttons.add(new ButtonElement(3, Math.round((float)this.width / 2.0f) - 35, Math.round((float)this.height / 2.0f) - 30, 20, 20, "+"));
            this.buttons.add(new ButtonElement(6, Math.round((float)this.width / 2.0f) - 75, Math.round((float)this.height / 2.0f) - 5, 20, 20, "-"));
            this.buttons.add(new ButtonElement(5, Math.round((float)this.width / 2.0f) - 35, Math.round((float)this.height / 2.0f) - 5, 20, 20, "+"));
        }
        super.init();
    }

    protected void buttonClicked(ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button == this.itemIoButton) {
            this.mc.displayScreen((Screen)new ScreenItemIOConfig((Player)this.mc.thePlayer, (MenuAbstract)this.fluidSlots, (Screen)this, this.tile));
        } else if (button == this.fluidIoButton) {
            this.mc.displayScreen((Screen)new ScreenFluidIOConfig((Player)this.mc.thePlayer, (MenuAbstract)this.fluidSlots, (Screen)this, this.tile));
        } else if (button.id == 2) {
            if (this.tile.workTimer.isPaused()) {
                this.tile.workTimer.unpause();
            } else {
                this.tile.workTimer.pause();
            }
            String string = button.displayString = this.tile.workTimer.isPaused() ? "OFF" : "ON";
            if (EnvironmentHelper.isClientWorld()) {
                NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageAutoMinerStart(this.tile.getPosition(), this.tile.getClass()));
            }
        } else if (button.id == 3) {
            if (this.tile.size.x < this.tile.maxSize.x) {
                ++this.tile.size.x;
            }
        } else if (button.id == 4) {
            if (this.tile.size.x > 3) {
                --this.tile.size.x;
            }
        } else if (button.id == 5) {
            if (this.tile.size.y < this.tile.maxSize.y) {
                ++this.tile.size.y;
            }
        } else if (button.id == 6 && this.tile.size.y > 3) {
            --this.tile.size.y;
        }
        if (EnvironmentHelper.isClientWorld()) {
            NetworkHandler.sendToServer((NetworkMessage)new PacketScreenAction(button.id, 0, 0, this.tile.getPosition(), this.tile.getClass()));
        }
        super.buttonClicked(button);
    }
}

