/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.fluids.impl.MenuFluid;
import sunsetsatellite.catalyst.fluids.impl.ScreenFluid;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.signalindustries.menus.MenuSIFluidTank;
import sunsetsatellite.signalindustries.screens.ScreenFluidIOConfig;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityEnergyCell;
import sunsetsatellite.signalindustries.util.Tier;

public class ScreenEnergyCell
extends ScreenFluid {
    public Player player;
    public TileEntityEnergyCell tile;
    public ButtonElement fluidIoButton;

    public ScreenEnergyCell(ContainerInventory inv, TileEntity tile) {
        super((MenuFluid)new MenuSIFluidTank(inv, (TileEntityFluidItemContainer)tile));
        this.tile = (TileEntityEnergyCell)tile;
        this.player = inv.player;
    }

    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        this.font.drawString(I18n.getInstance().translateNameKey(this.tile.getNameTranslationKey()), 64, 6, -12566464);
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        @NotNull Texture t = this.mc.textureManager.loadTexture("/assets/catalyst-fluids/gui/tank_gui.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(t);
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
    }

    protected void buttonClicked(ButtonElement guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton == this.fluidIoButton) {
            this.mc.displayScreen((Screen)new ScreenFluidIOConfig((Player)this.mc.thePlayer, (MenuAbstract)this.fluidSlots, (Screen)this, this.tile));
        }
        if (this.tile.getTier() == Tier.INFINITE && guibutton.id == 1) {
            this.tile.isInfiniteSource = !this.tile.isInfiniteSource;
            guibutton.displayString = this.tile.isInfiniteSource ? "INF" : "VOID";
        }
    }

    public void init() {
        ButtonElement fluidIo = new ButtonElement(0, Math.round((float)this.width / 2.0f) + 60, Math.round((float)this.height / 2.0f) - 80, 20, 20, "F");
        this.buttons.add(fluidIo);
        this.fluidIoButton = fluidIo;
        if (this.tile.getTier() == Tier.INFINITE) {
            this.buttons.add(new ButtonElement(1, Math.round((float)this.width / 2.0f) - 80, Math.round((float)this.height / 2.0f) - 30, 20, 20, this.tile.isInfiniteSource ? "INF" : "VOID"));
        }
        super.init();
    }
}

