/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.container.ScreenContainerAbstract;
import net.minecraft.client.option.enums.DescriptionPromptEnum;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.mp.PacketScreenAction;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.signalindustries.covers.RedstoneCover;
import sunsetsatellite.signalindustries.menus.MenuCover;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageRedstoneCoverSetFilter;
import sunsetsatellite.signalindustries.tiles.base.TileEntityCoverable;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class ScreenRedstoneCoverConfig
extends ScreenContainerAbstract {
    public RedstoneCover cover;
    public Player player;
    public TileEntityTieredMachineBase tile;
    public ItemElement guiRenderItem;
    public TooltipElement TooltipElement;

    public ScreenRedstoneCoverConfig(ContainerInventory playerInv, TileEntity tile, CompoundTag data) {
        super((MenuAbstract)new MenuCover(playerInv, (TileEntityFluidItemContainer)tile, data));
        this.xSize = 176;
        this.ySize = 166;
        this.player = playerInv.player;
        this.tile = (TileEntityTieredMachineBase)tile;
        this.cover = (RedstoneCover)((TileEntityCoverable)tile).getCovers().get(Direction.values()[data.getInteger("side")]);
        Minecraft mc = Minecraft.getMinecraft();
        this.guiRenderItem = new ItemElement(mc);
        this.TooltipElement = new TooltipElement(mc);
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        super.render(mouseX, mouseY, partialTick);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        int pseudoSlotX = 45;
        int pseudoSlotY = 35;
        ItemStack grabbedItem = this.player.inventory.getHeldItemStack();
        if ((mouseX -= k) >= pseudoSlotX - 1 && mouseX < pseudoSlotX + 16 + 1 && (mouseY -= l) >= pseudoSlotY - 1 && mouseY < pseudoSlotY + 16 + 1) {
            boolean showDescription;
            String str;
            this.guiRenderItem.render(this.cover.sensorStack, k + 45, l + 35, true);
            if (grabbedItem == null && this.cover.sensorStack != null && !(str = this.TooltipElement.getTooltipText(this.cover.sensorStack, showDescription = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157) || this.mc.gameSettings.itemDescriptions.value == DescriptionPromptEnum.ALWAYS_SHOW)).isEmpty()) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.TooltipElement.render(str, k + mouseX, l + mouseY, 8, -8);
            }
        } else if (this.cover.sensorStack != null) {
            this.guiRenderItem.render(this.cover.sensorStack, k + 45, l + 35, false);
        }
        GL11.glEnable((int)2929);
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        @NotNull Texture i = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/sensor_pipe_gui.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(i);
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
    }

    protected void drawGuiContainerForegroundLayer() {
        this.font.drawString("Configure: Sensor", 45, 6, -12566464);
        this.font.drawString("Slot", 8, 8, 0x404040);
        this.font.drawString(String.valueOf(this.cover.sensorAmount), 120, 42, 0x404040);
        if (this.cover.sensorSlot == -1) {
            this.font.drawString("*", 10, 42, 0x404040);
        } else {
            this.font.drawString(String.valueOf(this.cover.sensorSlot), 10, 42, 0x404040);
        }
    }

    public void init() {
        super.init();
        ButtonElement button = new ButtonElement(0, Math.round((float)this.width / 2.0f - 10.0f), Math.round((float)this.height / 2.0f - 50.0f), 20, 20, "=");
        this.buttons.add(button);
        this.buttons.add(new ButtonElement(1, Math.round((float)this.width / 2.0f + 30.0f), Math.round((float)this.height / 2.0f - 65.0f), 20, 20, "+"));
        this.buttons.add(new ButtonElement(2, Math.round((float)this.width / 2.0f + 30.0f), Math.round((float)this.height / 2.0f - 30.0f), 20, 20, "-"));
        this.buttons.add(new ButtonElement(3, Math.round((float)this.width / 2.0f + 60.0f), Math.round((float)this.height / 2.0f) - 75, 20, 20, this.cover.sensorUseMeta ? "M" : "!M"));
        this.buttons.add(new ButtonElement(4, Math.round((float)this.width / 2.0f + 60.0f), Math.round((float)this.height / 2.0f) - 55, 20, 20, this.cover.sensorUseData ? "D" : "!D"));
        this.buttons.add(new ButtonElement(5, Math.round((float)this.width / 2.0f - 80.0f), Math.round((float)this.height / 2.0f - 65.0f), 20, 20, "+"));
        this.buttons.add(new ButtonElement(6, Math.round((float)this.width / 2.0f - 80.0f), Math.round((float)this.height / 2.0f - 30.0f), 20, 20, "-"));
        switch (this.cover.sensorMode) {
            case 0: {
                button.displayString = "=";
                break;
            }
            case 1: {
                button.displayString = "!=";
                break;
            }
            case 2: {
                button.displayString = ">";
                break;
            }
            case 3: {
                button.displayString = "<";
                break;
            }
            case 4: {
                button.displayString = ">=";
                break;
            }
            case 5: {
                button.displayString = "<=";
                break;
            }
            case 6: {
                this.cover.sensorMode = 0;
                button.displayString = "=";
            }
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        int pseudoSlotX = 45;
        int pseudoSlotY = 35;
        ItemStack grabbedItem = this.player.inventory.getHeldItemStack();
        if ((mouseX -= k) >= pseudoSlotX - 1 && mouseX < pseudoSlotX + 16 + 1 && (mouseY -= l) >= pseudoSlotY - 1 && mouseY < pseudoSlotY + 16 + 1) {
            if (mouseButton == 0 && grabbedItem != null) {
                ItemStack copy = grabbedItem.copy();
                copy.stackSize = 1;
                this.cover.sensorStack = copy;
            } else if (mouseButton == 1) {
                this.cover.sensorStack = null;
            }
            if (EnvironmentHelper.isClientWorld()) {
                NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageRedstoneCoverSetFilter(new Vec3i(this.tile.x, this.tile.y, this.tile.z), this.cover.sensorStack, this.tile.getClass(), this.cover.getDir()));
            }
        }
    }

    protected void buttonClicked(ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 2 && this.cover.sensorAmount > 0) {
            --this.cover.sensorAmount;
        }
        if (button.id == 1) {
            ++this.cover.sensorAmount;
        }
        if (button.id == 3) {
            this.cover.sensorUseMeta = !this.cover.sensorUseMeta;
            String string = button.displayString = this.cover.sensorUseMeta ? "M" : "!M";
        }
        if (button.id == 4) {
            this.cover.sensorUseData = !this.cover.sensorUseData;
            String string = button.displayString = this.cover.sensorUseData ? "D" : "!D";
        }
        if (button.id == 6 && this.cover.sensorSlot >= 0) {
            --this.cover.sensorSlot;
        }
        if (button.id == 5 && this.cover.sensorSlot < this.tile.itemContents.length - 1) {
            ++this.cover.sensorSlot;
        }
        if (button.id == 0) {
            ++this.cover.sensorMode;
            switch (this.cover.sensorMode) {
                case 0: {
                    button.displayString = "=";
                    break;
                }
                case 1: {
                    button.displayString = "!=";
                    break;
                }
                case 2: {
                    button.displayString = ">";
                    break;
                }
                case 3: {
                    button.displayString = "<";
                    break;
                }
                case 4: {
                    button.displayString = ">=";
                    break;
                }
                case 5: {
                    button.displayString = "<=";
                    break;
                }
                case 6: {
                    this.cover.sensorMode = 0;
                    button.displayString = "=";
                }
            }
        }
        if (EnvironmentHelper.isClientWorld()) {
            NetworkHandler.sendToServer((NetworkMessage)new PacketScreenAction(button.id, 0, 100 + this.cover.getDir().getSideNumber(), new Vec3i(this.tile.x, this.tile.y, this.tile.z), this.tile.getClass()));
        }
    }
}

