/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.container.ScreenContainerAbstract;
import net.minecraft.client.option.enums.DescriptionPromptEnum;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.core.util.mp.PacketScreenAction;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.menus.MenuSensorPipe;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageSensorPipeSetFilter;
import sunsetsatellite.signalindustries.tiles.TileEntityItemConduit;
import sunsetsatellite.signalindustries.util.PipeMode;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class ScreenSensorPipeConfig
extends ScreenContainerAbstract {
    public ItemElement guiRenderItem;
    public TooltipElement TooltipElement;
    public ContainerInventory inventoryPlayer;
    private final TileEntityItemConduit tile;

    public ScreenSensorPipeConfig(ContainerInventory inventoryplayer, TileEntityItemConduit conduit) {
        super((MenuAbstract)new MenuSensorPipe(inventoryplayer, conduit));
        this.inventoryPlayer = inventoryplayer;
        this.tile = conduit;
        Minecraft mc = Minecraft.getMinecraft();
        this.guiRenderItem = new ItemElement(mc);
        this.TooltipElement = new TooltipElement(mc);
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        @NotNull Texture l = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/sensor_pipe_gui.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(l);
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
    }

    protected void drawGuiContainerForegroundLayer() {
        this.font.drawString("Configure: Sensor", 45, 6, 0x404040);
        this.font.drawString("Inventory", 8, this.ySize - 96 + 2, 0x404040);
        this.font.drawString(String.valueOf(this.tile.sensorAmount), 120, 42, 0x404040);
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        super.render(mouseX, mouseY, partialTick);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        int pseudoSlotX = 45;
        int pseudoSlotY = 35;
        ItemStack grabbedItem = this.inventoryPlayer.getHeldItemStack();
        if ((mouseX -= k) >= pseudoSlotX - 1 && mouseX < pseudoSlotX + 16 + 1 && (mouseY -= l) >= pseudoSlotY - 1 && mouseY < pseudoSlotY + 16 + 1) {
            boolean showDescription;
            String str;
            this.guiRenderItem.render(this.tile.sensorStack, k + 45, l + 35, true);
            if (grabbedItem == null && this.tile.sensorStack != null && !(str = this.TooltipElement.getTooltipText(this.tile.sensorStack, showDescription = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157) || this.mc.gameSettings.itemDescriptions.value == DescriptionPromptEnum.ALWAYS_SHOW)).isEmpty()) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.TooltipElement.render(str, k + mouseX, l + mouseY, 8, -8);
            }
        } else if (this.tile.sensorStack != null) {
            this.guiRenderItem.render(this.tile.sensorStack, k + 45, l + 35, false);
        }
        GL11.glEnable((int)2929);
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        int pseudoSlotX = 45;
        int pseudoSlotY = 35;
        ItemStack grabbedItem = this.inventoryPlayer.getHeldItemStack();
        if ((mouseX -= k) >= pseudoSlotX - 1 && mouseX < pseudoSlotX + 16 + 1 && (mouseY -= l) >= pseudoSlotY - 1 && mouseY < pseudoSlotY + 16 + 1) {
            if (mouseButton == 0 && grabbedItem != null) {
                ItemStack copy = grabbedItem.copy();
                copy.stackSize = 1;
                this.tile.sensorStack = copy;
            } else if (mouseButton == 1) {
                this.tile.sensorStack = null;
            }
            if (EnvironmentHelper.isClientWorld()) {
                NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageSensorPipeSetFilter(new Vec3i(this.tile.x, this.tile.y, this.tile.z), this.tile.sensorStack, this.tile.getClass()));
            }
        }
    }

    public void init() {
        super.init();
        ButtonElement guibutton = new ButtonElement(0, Math.round((float)this.width / 2.0f - 10.0f), Math.round((float)this.height / 2.0f - 50.0f), 20, 20, "=");
        this.buttons.add(guibutton);
        this.buttons.add(new ButtonElement(1, Math.round((float)this.width / 2.0f + 30.0f), Math.round((float)this.height / 2.0f - 65.0f), 20, 20, "+"));
        this.buttons.add(new ButtonElement(2, Math.round((float)this.width / 2.0f + 30.0f), Math.round((float)this.height / 2.0f - 30.0f), 20, 20, "-"));
        this.buttons.add(new ButtonElement(3, Math.round((float)this.width / 2.0f + 60.0f), Math.round((float)this.height / 2.0f) - 75, 20, 20, this.tile.sensorUseMeta ? "M" : "!M"));
        this.buttons.add(new ButtonElement(4, Math.round((float)this.width / 2.0f + 60.0f), Math.round((float)this.height / 2.0f) - 55, 20, 20, this.tile.sensorUseData ? "D" : "!D"));
        this.buttons.add(new ButtonElement(5, Math.round((float)this.width / 2.0f) - 25, Math.round((float)this.height / 2.0f) - 25, 50, 15, String.valueOf((Object)this.tile.mode)));
        switch (this.tile.sensorMode) {
            case 0: {
                guibutton.displayString = "=";
                break;
            }
            case 1: {
                guibutton.displayString = "!=";
                break;
            }
            case 2: {
                guibutton.displayString = ">";
                break;
            }
            case 3: {
                guibutton.displayString = "<";
                break;
            }
            case 4: {
                guibutton.displayString = ">=";
                break;
            }
            case 5: {
                guibutton.displayString = "<=";
                break;
            }
            case 6: {
                this.tile.sensorMode = 0;
                guibutton.displayString = "=";
            }
        }
    }

    protected void buttonClicked(ButtonElement guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == 2 && this.tile.sensorAmount > 0) {
            --this.tile.sensorAmount;
        }
        if (guibutton.id == 1) {
            ++this.tile.sensorAmount;
        }
        if (guibutton.id == 3) {
            this.tile.sensorUseMeta = !this.tile.sensorUseMeta;
            String string = guibutton.displayString = this.tile.sensorUseMeta ? "M" : "!M";
        }
        if (guibutton.id == 4) {
            this.tile.sensorUseData = !this.tile.sensorUseData;
            String string = guibutton.displayString = this.tile.sensorUseData ? "D" : "!D";
        }
        if (guibutton.id == 0) {
            ++this.tile.sensorMode;
            switch (this.tile.sensorMode) {
                case 0: {
                    guibutton.displayString = "=";
                    break;
                }
                case 1: {
                    guibutton.displayString = "!=";
                    break;
                }
                case 2: {
                    guibutton.displayString = ">";
                    break;
                }
                case 3: {
                    guibutton.displayString = "<";
                    break;
                }
                case 4: {
                    guibutton.displayString = ">=";
                    break;
                }
                case 5: {
                    guibutton.displayString = "<=";
                    break;
                }
                case 6: {
                    this.tile.sensorMode = 0;
                    guibutton.displayString = "=";
                }
            }
        }
        if (guibutton.id == 5) {
            switch (this.tile.mode) {
                case RANDOM: {
                    this.tile.mode = PipeMode.SPLIT;
                    break;
                }
                case SPLIT: {
                    this.tile.mode = PipeMode.RANDOM;
                }
            }
            guibutton.displayString = String.valueOf((Object)this.tile.mode);
        }
        if (EnvironmentHelper.isClientWorld()) {
            NetworkHandler.sendToServer((NetworkMessage)new PacketScreenAction(guibutton.id, 0, 0, new Vec3i(this.tile.x, this.tile.y, this.tile.z), this.tile.getClass()));
        }
    }
}

