/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import net.minecraft.core.util.helper.Color;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.CatalystEnergy;
import sunsetsatellite.catalyst.fluids.impl.MenuFluid;
import sunsetsatellite.catalyst.fluids.impl.ScreenFluid;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.signalindustries.menus.MenuSignalumDynamo;
import sunsetsatellite.signalindustries.screens.ScreenFluidIOConfig;
import sunsetsatellite.signalindustries.screens.ScreenItemIOConfig;
import sunsetsatellite.signalindustries.tiles.TileEntitySignalumDynamo;

public class ScreenSignalumDynamo
extends ScreenFluid {
    public Player player;
    public TileEntitySignalumDynamo tile;
    public ButtonElement itemIoButton;
    public ButtonElement fluidIoButton;

    public ScreenSignalumDynamo(ContainerInventory inv, TileEntity tile) {
        super((MenuFluid)new MenuSignalumDynamo(inv, (TileEntityFluidItemContainer)tile));
        this.tile = (TileEntitySignalumDynamo)tile;
        this.player = inv.player;
    }

    public void render(int x, int y, float renderPartialTicks) {
        int i = (this.width - this.xSize) / 2;
        int j = (this.height - this.ySize) / 2;
        super.render(x, y, renderPartialTicks);
        I18n trans = I18n.getInstance();
        StringBuilder text = new StringBuilder();
        if (x > i + 80 && x < i + 94 && y > j + 40 && y < j + 46) {
            text.append(CatalystEnergy.ENERGY_NAME).append(": ").append(this.tile.getEnergy()).append(" ").append(CatalystEnergy.ENERGY_SUFFIX).append("/").append(this.tile.getCapacity()).append(" ").append(CatalystEnergy.ENERGY_SUFFIX);
            TooltipElement tooltip = new TooltipElement(this.mc);
            tooltip.render(text.toString(), x, y, 8, -8);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        super.drawGuiContainerBackgroundLayer(f);
        Texture bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/dynamo_basic.png");
        switch (this.tile.tier) {
            case PROTOTYPE: 
            case BASIC: {
                bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/dynamo_basic.png");
                break;
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(bg);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        double color_mapped = Catalyst.map((double)((float)this.tile.getEnergy() / (float)this.tile.getCapacity()), (double)0.0, (double)1.0, (double)1.0, (double)0.65);
        double x_mapped = Catalyst.map((double)((float)this.tile.getEnergy() / (float)this.tile.getCapacity()), (double)0.0, (double)1.0, (double)0.0, (double)15.0);
        Color c = new Color();
        byte[] colorArray = Catalyst.HSBtoRGB((float)((float)color_mapped), (float)1.0f, (float)1.0f);
        c.setRGB((int)colorArray[0], (int)colorArray[1], (int)colorArray[2]);
        int color = c.getAlpha() << 24 | c.getRed() << 16 | c.getBlue() << 8 | c.getGreen();
        this.drawRectWidthHeight(x + 80, y + 40, (int)x_mapped, 7, color);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tile.isBurning()) {
            int counter = this.tile.getBurnTimeRemainingScaled(12);
            this.drawTexturedModalRect(x + 9, y + 39 + 12 - counter, 176, 12 - counter, 14, counter + 2);
        }
        if (this.tile.speedMultiplier > 1.0f) {
            this.drawStringCentered(this.font, this.tile.speedMultiplier + "x", x + this.xSize - 16, y + this.ySize / 2 - 16, this.tile.speedMultiplier >= 3.0f ? -23296 : (this.tile.speedMultiplier >= 2.0f ? -65281 : -32640));
        }
    }

    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        int color = -1;
        switch (this.tile.tier) {
            case PROTOTYPE: {
                break;
            }
            case BASIC: {
                color = -32640;
                break;
            }
            case REINFORCED: {
                color = -65536;
                break;
            }
            case AWAKENED: {
                color = -23296;
            }
        }
        this.font.drawCenteredString(I18n.getInstance().translateNameKey(this.tile.getNameTranslationKey()), 90, 6, color);
    }

    public void init() {
        ButtonElement fluidIo = new ButtonElement(0, Math.round((float)this.width / 2.0f) + 60, Math.round((float)this.height / 2.0f) - 80, 20, 20, "F");
        this.buttons.add(fluidIo);
        ButtonElement itemIo = new ButtonElement(1, Math.round((float)this.width / 2.0f) + 60, Math.round((float)this.height / 2.0f) - 60, 20, 20, "I");
        this.buttons.add(itemIo);
        this.fluidIoButton = fluidIo;
        this.itemIoButton = itemIo;
        super.init();
    }

    protected void buttonClicked(ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button == this.itemIoButton) {
            this.mc.displayScreen((Screen)new ScreenItemIOConfig((Player)this.mc.thePlayer, (MenuAbstract)this.fluidSlots, (Screen)this, this.tile));
        } else if (button == this.fluidIoButton) {
            this.mc.displayScreen((Screen)new ScreenFluidIOConfig((Player)this.mc.thePlayer, (MenuAbstract)this.fluidSlots, (Screen)this, this.tile));
        }
        super.buttonClicked(button);
    }
}

